/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opentripplanner.common.pqueue.BinHeap;
import org.opentripplanner.graph_builder.module.map.EndMatchState;
import org.opentripplanner.graph_builder.module.map.MatchState;
import org.opentripplanner.graph_builder.module.map.MidblockMatchState;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetMatcher {
    private static final Logger log = LoggerFactory.getLogger(StreetMatcher.class);
    private static final double DISTANCE_THRESHOLD = 2.0E-4;
    Graph graph;
    private STRtree index;

    STRtree createIndex() {
        STRtree edgeIndex = new STRtree();
        for (Vertex v : this.graph.getVertices()) {
            for (Edge e : v.getOutgoing()) {
                if (!(e instanceof StreetEdge)) continue;
                LineString geometry = e.getGeometry();
                Envelope envelope = geometry.getEnvelopeInternal();
                edgeIndex.insert(envelope, (Object)e);
            }
        }
        log.debug("Created index");
        return edgeIndex;
    }

    public StreetMatcher(Graph graph) {
        this.graph = graph;
        this.index = this.createIndex();
        this.index.build();
    }

    public List<Edge> match(Geometry routeGeometry) {
        if ((routeGeometry = this.removeDuplicatePoints(routeGeometry)) == null) {
            return null;
        }
        routeGeometry = DouglasPeuckerSimplifier.simplify((Geometry)routeGeometry, (double)1.0E-5);
        LocationIndexedLine indexedLine = new LocationIndexedLine(routeGeometry);
        LinearLocation startIndex = indexedLine.getStartIndex();
        Coordinate routeStartCoordinate = startIndex.getCoordinate(routeGeometry);
        Envelope envelope = new Envelope(routeStartCoordinate);
        double distanceThreshold = 2.0E-4;
        envelope.expandBy(distanceThreshold);
        BinHeap<MatchState> states = new BinHeap<MatchState>();
        List nearbyEdges = this.index.query(envelope);
        while (nearbyEdges.isEmpty()) {
            envelope.expandBy(distanceThreshold);
            distanceThreshold *= 2.0;
            nearbyEdges = this.index.query(envelope);
        }
        for (Edge initialEdge : nearbyEdges) {
            LineString edgeGeometry = initialEdge.getGeometry();
            LocationIndexedLine indexedEdge = new LocationIndexedLine((Geometry)edgeGeometry);
            LinearLocation initialLocation = indexedEdge.project(routeStartCoordinate);
            double error = MatchState.distance(initialLocation.getCoordinate((Geometry)edgeGeometry), routeStartCoordinate);
            MidblockMatchState state = new MidblockMatchState(null, routeGeometry, initialEdge, startIndex, initialLocation, error, 0.01);
            states.insert(state, 0.0);
        }
        int seen_count = 0;
        int total = 0;
        HashSet<MatchState> seen = new HashSet<MatchState>();
        while (!states.empty()) {
            double k = states.peek_min_key();
            MatchState state = (MatchState)states.extract_min();
            if (++total % 50000 == 0) {
                log.debug("seen / total: " + seen_count + " / " + total);
            }
            if (seen.contains(state)) {
                ++seen_count;
                continue;
            }
            if (k != 0.0) {
                seen.add(state);
            }
            if (state instanceof EndMatchState) {
                return this.toEdgeList(state);
            }
            for (MatchState next : state.getNextStates()) {
                if (seen.contains(next)) continue;
                states.insert(next, next.getTotalError() - next.getDistanceAlongRoute());
            }
        }
        return null;
    }

    private Geometry removeDuplicatePoints(Geometry routeGeometry) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        Coordinate last = null;
        for (Coordinate c : routeGeometry.getCoordinates()) {
            if (c.equals(last)) continue;
            last = c;
            coords.add(c);
        }
        if (coords.size() < 2) {
            return null;
        }
        Coordinate[] coordArray = new Coordinate[coords.size()];
        return routeGeometry.getFactory().createLineString(coords.toArray(coordArray));
    }

    private List<Edge> toEdgeList(MatchState next) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Edge lastEdge = null;
        while (next != null) {
            Edge edge = next.getEdge();
            if (edge != lastEdge) {
                edges.add(edge);
                lastEdge = edge;
            }
            next = next.parent;
        }
        Collections.reverse(edges);
        return edges;
    }
}

