/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.map.StreetMatcher;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusRouteStreetMatcher
implements GraphBuilderModule {
    private static final Logger log = LoggerFactory.getLogger(BusRouteStreetMatcher.class);

    public List<String> provides() {
        return List.of("edge matching");
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets", "transit");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        graph.index();
        StreetMatcher matcher = new StreetMatcher(graph);
        log.info("Finding corresponding street edges for trip patterns...");
        Collection<Route> allRoutes = graph.index.getAllRoutes();
        ProgressTracker progress = ProgressTracker.track("Match route to street edges", 10, allRoutes.size());
        log.info(progress.startMessage());
        for (Route route : allRoutes) {
            for (TripPattern pattern : graph.index.getPatternsForRoute().get((Object)route)) {
                if (!pattern.getMode().onStreet()) continue;
                log.debug("Matching {}", (Object)pattern);
                if (pattern.getGeometry() == null) continue;
                for (int i = 0; i < pattern.numHopGeometries(); ++i) {
                    LineString hopGeometry = pattern.getHopGeometry(i);
                    List<Edge> edges = matcher.match((Geometry)hopGeometry);
                    if (edges == null || edges.isEmpty()) {
                        log.warn("Could not match to street network: {}", (Object)pattern);
                        continue;
                    }
                    ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                    for (Edge e : edges) {
                        coordinates.addAll(Arrays.asList(e.getGeometry().getCoordinates()));
                    }
                    Coordinate[] coordinateArray = new Coordinate[coordinates.size()];
                    LineString ls = GeometryUtils.getGeometryFactory().createLineString(coordinates.toArray(coordinateArray));
                    pattern.setHopGeometry(i, ls);
                }
            }
            progress.step(arg_0 -> ((Logger)log).info(arg_0));
        }
        log.info(progress.completeMessage());
    }

    @Override
    public void checkInputs() {
    }
}

