/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.geometry;

import org.apache.commons.math3.util.FastMath;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;

class IndexedLineSegment {
    private static final double RADIUS = 6371010.0;
    int index;
    Coordinate start;
    Coordinate end;
    private double lineLength;

    public IndexedLineSegment(int index, Coordinate start, Coordinate end) {
        this.index = index;
        this.start = start;
        this.end = end;
        this.lineLength = SphericalDistanceLibrary.fastDistance(start, end);
    }

    static double bearing(Coordinate c1, Coordinate c2) {
        double deltaLon = (c2.x - c1.x) * Math.PI / 180.0;
        double lat1Radians = c1.y * Math.PI / 180.0;
        double lat2Radians = c2.y * Math.PI / 180.0;
        double y = FastMath.sin((double)deltaLon) * FastMath.cos((double)lat2Radians);
        double x = FastMath.cos((double)lat1Radians) * FastMath.sin((double)lat2Radians) - FastMath.sin((double)lat1Radians) * FastMath.cos((double)lat2Radians) * FastMath.cos((double)deltaLon);
        return FastMath.atan2((double)y, (double)x);
    }

    double crossTrackError(Coordinate coord) {
        double distanceFromStart = SphericalDistanceLibrary.fastDistance(this.start, coord);
        double bearingToCoord = IndexedLineSegment.bearing(this.start, coord);
        double bearingToEnd = IndexedLineSegment.bearing(this.start, this.end);
        return FastMath.asin((double)(FastMath.sin((double)(distanceFromStart / 6371010.0)) * FastMath.sin((double)(bearingToCoord - bearingToEnd)))) * 6371010.0;
    }

    double distance(Coordinate coord) {
        double distanceToEnd;
        double cte = this.crossTrackError(coord);
        double atd = this.alongTrackDistance(coord, cte);
        double inverseAtd = this.inverseAlongTrackDistance(coord, -cte);
        double distanceToStart = SphericalDistanceLibrary.fastDistance(coord, this.start);
        if (distanceToStart < (distanceToEnd = SphericalDistanceLibrary.fastDistance(coord, this.end))) {
            if (inverseAtd > this.lineLength) {
                return distanceToStart;
            }
            return Math.abs(cte);
        }
        if (atd > this.lineLength) {
            return distanceToEnd;
        }
        return Math.abs(cte);
    }

    private double inverseAlongTrackDistance(Coordinate coord, double inverseCrossTrackError) {
        double distanceFromEnd = SphericalDistanceLibrary.fastDistance(this.end, coord);
        double alongTrackDistance = FastMath.acos((double)(FastMath.cos((double)(distanceFromEnd / 6371010.0)) / FastMath.cos((double)(inverseCrossTrackError / 6371010.0)))) * 6371010.0;
        return alongTrackDistance;
    }

    public double fraction(Coordinate coord) {
        double cte = this.crossTrackError(coord);
        double distanceToStart = SphericalDistanceLibrary.fastDistance(coord, this.start);
        double distanceToEnd = SphericalDistanceLibrary.fastDistance(coord, this.end);
        if (cte < distanceToStart && cte < distanceToEnd) {
            double atd = this.alongTrackDistance(coord, cte);
            return atd / this.lineLength;
        }
        if (distanceToStart < distanceToEnd) {
            return 0.0;
        }
        return 1.0;
    }

    private double alongTrackDistance(Coordinate coord, double crossTrackError) {
        double distanceFromStart = SphericalDistanceLibrary.fastDistance(this.start, coord);
        double alongTrackDistance = FastMath.acos((double)(FastMath.cos((double)(distanceFromStart / 6371010.0)) / FastMath.cos((double)(crossTrackError / 6371010.0)))) * 6371010.0;
        return alongTrackDistance;
    }
}

