/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.geometry;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.util.FastMath;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.BogusShapeDistanceTraveled;
import org.opentripplanner.graph_builder.issues.BogusShapeGeometry;
import org.opentripplanner.graph_builder.issues.BogusShapeGeometryCaught;
import org.opentripplanner.graph_builder.module.geometry.BlockIdAndServiceId;
import org.opentripplanner.graph_builder.module.geometry.IndexedLineSegment;
import org.opentripplanner.graph_builder.module.geometry.IndexedLineSegmentComparator;
import org.opentripplanner.graph_builder.module.geometry.ShapeSegmentKey;
import org.opentripplanner.gtfs.GtfsContext;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryAndBlockProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryAndBlockProcessor.class);
    private DataImportIssueStore issueStore;
    private static GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
    private OtpTransitService transitService;
    private Map<ShapeSegmentKey, LineString> geometriesByShapeSegmentKey = new ConcurrentHashMap<ShapeSegmentKey, LineString>();
    private Map<FeedScopedId, LineString> geometriesByShapeId = new ConcurrentHashMap<FeedScopedId, LineString>();
    private Map<FeedScopedId, double[]> distancesByShapeId = new ConcurrentHashMap<FeedScopedId, double[]>();
    private FareServiceFactory fareServiceFactory;
    private final double maxStopToShapeSnapDistance;
    private final int maxInterlineDistance;

    public GeometryAndBlockProcessor(GtfsContext context) {
        this(context.getTransitService(), null, -1.0, -1);
    }

    public GeometryAndBlockProcessor(OtpTransitService transitService, FareServiceFactory fareServiceFactory, double maxStopToShapeSnapDistance, int maxInterlineDistance) {
        this.transitService = transitService;
        this.fareServiceFactory = fareServiceFactory != null ? fareServiceFactory : new DefaultFareServiceFactory();
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance > 0.0 ? maxStopToShapeSnapDistance : 150.0;
        this.maxInterlineDistance = maxInterlineDistance > 0 ? maxInterlineDistance : 200;
    }

    public void run(Graph graph) {
        this.run(graph, new DataImportIssueStore(false));
    }

    public void run(Graph graph, DataImportIssueStore issueStore) {
        this.issueStore = issueStore;
        this.fareServiceFactory.processGtfs(this.transitService);
        for (FeedScopedId serviceId : this.transitService.getAllServiceIds()) {
            graph.getServiceCodes().put(serviceId, graph.getServiceCodes().size());
        }
        LOG.info("Processing geometries and blocks on graph...");
        ConcurrentHashMap geometriesByTripPattern = new ConcurrentHashMap();
        Collection<TripPattern> tripPatterns = this.transitService.getTripPatterns();
        TripPattern.generateUniqueNames(tripPatterns, issueStore);
        ProgressTracker progress = ProgressTracker.track("Generate TripPattern geometries", 100, tripPatterns.size());
        LOG.info(progress.startMessage());
        tripPatterns.parallelStream().forEach(tripPattern -> {
            tripPattern.scheduledTripsAsStream().forEach(trip -> {
                if (!geometriesByTripPattern.containsKey(tripPattern) && trip.getShapeId() != null && trip.getShapeId().getId() != null && !trip.getShapeId().getId().equals("")) {
                    geometriesByTripPattern.put(tripPattern, this.createGeometry(trip.getShapeId(), this.transitService.getStopTimesForTrip((Trip)trip)));
                }
            });
            progress.step(m -> LOG.info(m));
        });
        LOG.info(progress.completeMessage());
        for (TripPattern tripPattern2 : tripPatterns) {
            LineString[] hopGeometries = (LineString[])geometriesByTripPattern.get(tripPattern2);
            if (hopGeometries != null) {
                tripPattern2.setHopGeometries(hopGeometries);
            }
            tripPattern2.setServiceCodes(graph.getServiceCodes());
            graph.tripPatternForId.put(tripPattern2.getId(), tripPattern2);
        }
        this.interline(tripPatterns, graph);
        for (TripPattern tableTripPattern : tripPatterns) {
            tableTripPattern.getScheduledTimetable().finish();
        }
        graph.putService(FareService.class, this.fareServiceFactory.makeFareService());
    }

    private void interline(Collection<TripPattern> tripPatterns, Graph graph) {
        HashMap<TripTimes, TripPattern> patternForTripTimes = new HashMap<TripTimes, TripPattern>();
        ArrayListMultimap tripTimesForBlock = ArrayListMultimap.create();
        LOG.info("Finding interlining trips based on block IDs.");
        for (TripPattern pattern : tripPatterns) {
            Timetable timetable = pattern.getScheduledTimetable();
            for (TripTimes tripTimes : timetable.getTripTimes()) {
                Trip trip = tripTimes.getTrip();
                if (Strings.isNullOrEmpty((String)trip.getBlockId())) continue;
                tripTimesForBlock.put((Object)new BlockIdAndServiceId(trip), (Object)tripTimes);
                patternForTripTimes.put(tripTimes, pattern);
            }
        }
        ArrayListMultimap interlines = ArrayListMultimap.create();
        block2: for (BlockIdAndServiceId block : tripTimesForBlock.keySet()) {
            List blockTripTimes = tripTimesForBlock.get((Object)block);
            Collections.sort(blockTripTimes);
            TripTimes prev = null;
            for (TripTimes curr : blockTripTimes) {
                if (prev != null) {
                    if (prev.getDepartureTime(prev.getNumStops() - 1) > curr.getArrivalTime(0)) {
                        LOG.error("Trip times within block {} are not increasing on service {} after trip {}.", new Object[]{block.blockId, block.serviceId, prev.getTrip().getId()});
                        continue block2;
                    }
                    TripPattern prevPattern = (TripPattern)patternForTripTimes.get(prev);
                    TripPattern currPattern = (TripPattern)patternForTripTimes.get(curr);
                    StopLocation fromStop = prevPattern.lastStop();
                    StopLocation toStop = currPattern.firstStop();
                    double teleportationDistance = SphericalDistanceLibrary.fastDistance(fromStop.getLat(), fromStop.getLon(), toStop.getLat(), toStop.getLon());
                    if (!(teleportationDistance > (double)this.maxInterlineDistance)) {
                        interlines.put(new P2<TripPattern>(prevPattern, currPattern), new P2<Trip>(prev.getTrip(), curr.getTrip()));
                    }
                }
                prev = curr;
            }
        }
        for (P2 patterns : interlines.keySet()) {
            for (P2 trips : interlines.get((Object)patterns)) {
                graph.interlinedTrips.put((Object)((Trip)trips.first), (Object)((Trip)trips.second));
            }
        }
        LOG.info("Done finding interlining trips.");
    }

    private LineString[] createGeometry(FeedScopedId shapeId, List<StopTime> stopTimes) {
        if (this.hasShapeDist(shapeId, stopTimes)) {
            return this.getHopGeometriesViaShapeDistTravelled(stopTimes, shapeId);
        }
        LineString shapeLineString = this.getLineStringForShapeId(shapeId);
        if (shapeLineString == null) {
            return this.createStraightLineHopeGeometries(stopTimes, shapeId);
        }
        List<LinearLocation> locations = this.getLinearLocations(stopTimes, shapeLineString);
        if (locations == null) {
            return this.createStraightLineHopeGeometries(stopTimes, shapeId);
        }
        return this.getGeometriesByShape(stopTimes, shapeId, shapeLineString, locations);
    }

    private boolean hasShapeDist(FeedScopedId shapeId, List<StopTime> stopTimes) {
        StopTime st0 = stopTimes.get(0);
        return st0.isShapeDistTraveledSet() && this.getDistanceForShapeId(shapeId) != null;
    }

    private LineString[] getGeometriesByShape(List<StopTime> stopTimes, FeedScopedId shapeId, LineString shape, List<LinearLocation> locations) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        Iterator<LinearLocation> locationIt = locations.iterator();
        LinearLocation endLocation = locationIt.next();
        double distanceSoFar = 0.0;
        int last = 0;
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            LinearLocation startLocation = endLocation;
            endLocation = locationIt.next();
            for (int j = last; j < startLocation.getSegmentIndex(); ++j) {
                Coordinate from = shape.getCoordinateN(j);
                Coordinate to = shape.getCoordinateN(j + 1);
                double xd = from.x - to.x;
                double yd = from.y - to.y;
                distanceSoFar += FastMath.sqrt((double)(xd * xd + yd * yd));
            }
            last = startLocation.getSegmentIndex();
            double startIndex = distanceSoFar + startLocation.getSegmentFraction() * startLocation.getSegmentLength((Geometry)shape);
            for (int j = last; j < endLocation.getSegmentIndex(); ++j) {
                Coordinate from = shape.getCoordinateN(j);
                Coordinate to = shape.getCoordinateN(j + 1);
                double xd = from.x - to.x;
                double yd = from.y - to.y;
                distanceSoFar += FastMath.sqrt((double)(xd * xd + yd * yd));
            }
            last = startLocation.getSegmentIndex();
            double endIndex = distanceSoFar + endLocation.getSegmentFraction() * endLocation.getSegmentLength((Geometry)shape);
            ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startIndex, endIndex);
            LineString geometry = this.geometriesByShapeSegmentKey.get(key);
            if (geometry == null) {
                LocationIndexedLine locationIndexed = new LocationIndexedLine((Geometry)shape);
                geometry = (LineString)locationIndexed.extractLine(startLocation, endLocation);
                PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(geometry.getCoordinates(), 2);
                geometry = geometryFactory.createLineString((CoordinateSequence)sequence);
            }
            geoms[i] = geometry;
        }
        return geoms;
    }

    private List<LinearLocation> getLinearLocations(List<StopTime> stopTimes, LineString shape) {
        boolean isFlexTrip = FlexTrip.containsFlexStops(stopTimes);
        ArrayList<IndexedLineSegment> segments = new ArrayList<IndexedLineSegment>();
        for (int i = 0; i < shape.getNumPoints() - 1; ++i) {
            segments.add(new IndexedLineSegment(i, shape.getCoordinateN(i), shape.getCoordinateN(i + 1)));
        }
        ArrayList<List<IndexedLineSegment>> possibleSegmentsForStop = new ArrayList<List<IndexedLineSegment>>();
        int minSegmentIndex = 0;
        for (int i = 0; i < stopTimes.size(); ++i) {
            StopLocation stop = stopTimes.get(i).getStop();
            Coordinate coord = stop.getCoordinate().asJtsCoordinate();
            ArrayList<IndexedLineSegment> stopSegments = new ArrayList<IndexedLineSegment>();
            double bestDistance = Double.MAX_VALUE;
            IndexedLineSegment bestSegment = null;
            int maxSegmentIndex = -1;
            int index = -1;
            int minSegmentIndexForThisStop = -1;
            for (IndexedLineSegment segment : segments) {
                ++index;
                if (segment.index < minSegmentIndex) continue;
                double distance = segment.distance(coord);
                if (distance < this.maxStopToShapeSnapDistance || isFlexTrip) {
                    stopSegments.add(segment);
                    maxSegmentIndex = index;
                    if (minSegmentIndexForThisStop != -1) continue;
                    minSegmentIndexForThisStop = index;
                    continue;
                }
                if (!(distance < bestDistance)) continue;
                bestDistance = distance;
                bestSegment = segment;
                if (maxSegmentIndex == -1) continue;
                maxSegmentIndex = index;
            }
            if (stopSegments.size() == 0 && bestSegment != null) {
                stopSegments.add(bestSegment);
                minSegmentIndex = bestSegment.index;
            } else {
                minSegmentIndex = minSegmentIndexForThisStop;
                stopSegments.sort(new IndexedLineSegmentComparator(coord));
            }
            for (int j = i - 1; j >= 0; --j) {
                Iterator it = ((List)possibleSegmentsForStop.get(j)).iterator();
                while (it.hasNext()) {
                    IndexedLineSegment segment = (IndexedLineSegment)it.next();
                    if (segment.index <= maxSegmentIndex) continue;
                    it.remove();
                }
            }
            possibleSegmentsForStop.add(stopSegments);
        }
        return this.getStopLocations(possibleSegmentsForStop, stopTimes, 0, -1);
    }

    private LineString[] createStraightLineHopeGeometries(List<StopTime> stopTimes, FeedScopedId shapeId) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            LineString geometry;
            StopTime st0 = stopTimes.get(i);
            StopTime st1 = stopTimes.get(i + 1);
            geoms[i] = geometry = this.createSimpleGeometry(st0.getStop(), st1.getStop());
            this.issueStore.add(new BogusShapeGeometryCaught(shapeId, st0, st1));
        }
        return geoms;
    }

    private LineString[] getHopGeometriesViaShapeDistTravelled(List<StopTime> stopTimes, FeedScopedId shapeId) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            StopTime st0 = stopTimes.get(i);
            StopTime st1 = stopTimes.get(i + 1);
            geoms[i] = this.getHopGeometryViaShapeDistTraveled(shapeId, st0, st1);
        }
        return geoms;
    }

    private List<LinearLocation> getStopLocations(List<List<IndexedLineSegment>> possibleSegmentsForStop, List<StopTime> stopTimes, int index, int prevSegmentIndex) {
        if (index == stopTimes.size()) {
            return new LinkedList<LinearLocation>();
        }
        StopTime st = stopTimes.get(index);
        StopLocation stop = st.getStop();
        Coordinate stopCoord = stop.getCoordinate().asJtsCoordinate();
        for (IndexedLineSegment segment : possibleSegmentsForStop.get(index)) {
            List<LinearLocation> locations;
            if (segment.index < prevSegmentIndex || (locations = this.getStopLocations(possibleSegmentsForStop, stopTimes, index + 1, segment.index)) == null) continue;
            LinearLocation location = new LinearLocation(0, segment.index, segment.fraction(stopCoord));
            locations.add(0, location);
            return locations;
        }
        return null;
    }

    private LineString getHopGeometryViaShapeDistTraveled(FeedScopedId shapeId, StopTime st0, StopTime st1) {
        LinearLocation endIndex;
        double endDistance;
        double startDistance = st0.getShapeDistTraveled();
        ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startDistance, endDistance = st1.getShapeDistTraveled());
        LineString geometry = this.geometriesByShapeSegmentKey.get(key);
        if (geometry != null) {
            return geometry;
        }
        double[] distances = this.getDistanceForShapeId(shapeId);
        if (distances == null) {
            this.issueStore.add(new BogusShapeGeometry(shapeId));
            return null;
        }
        LinearLocation startIndex = this.getSegmentFraction(distances, startDistance);
        if (GeometryAndBlockProcessor.equals(startIndex, endIndex = this.getSegmentFraction(distances, endDistance))) {
            this.issueStore.add(new BogusShapeDistanceTraveled(st1));
            return this.createSimpleGeometry(st0.getStop(), st1.getStop());
        }
        LineString line = this.getLineStringForShapeId(shapeId);
        LocationIndexedLine lol = new LocationIndexedLine((Geometry)line);
        geometry = this.getSegmentGeometry(shapeId, lol, startIndex, endIndex, startDistance, endDistance, st0, st1);
        return geometry;
    }

    private static boolean equals(LinearLocation startIndex, LinearLocation endIndex) {
        return startIndex.getSegmentIndex() == endIndex.getSegmentIndex() && startIndex.getSegmentFraction() == endIndex.getSegmentFraction() && startIndex.getComponentIndex() == endIndex.getComponentIndex();
    }

    private LineString createSimpleGeometry(StopLocation s0, StopLocation s1) {
        Coordinate[] coordinates = new Coordinate[]{s0.getCoordinate().asJtsCoordinate(), s1.getCoordinate().asJtsCoordinate()};
        PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(coordinates, 2);
        return geometryFactory.createLineString((CoordinateSequence)sequence);
    }

    private boolean isValid(Geometry geometry, StopLocation s0, StopLocation s1) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (coordinates.length < 2) {
            return false;
        }
        if (geometry.getLength() == 0.0) {
            return false;
        }
        for (Coordinate coordinate : coordinates) {
            if (!Double.isNaN(coordinate.x) && !Double.isNaN(coordinate.y)) continue;
            return false;
        }
        Coordinate geometryStartCoord = coordinates[0];
        Coordinate geometryEndCoord = coordinates[coordinates.length - 1];
        Coordinate startCoord = s0.getCoordinate().asJtsCoordinate();
        Coordinate endCoord = s1.getCoordinate().asJtsCoordinate();
        if (SphericalDistanceLibrary.fastDistance(startCoord, geometryStartCoord) > this.maxStopToShapeSnapDistance) {
            return false;
        }
        return !(SphericalDistanceLibrary.fastDistance(endCoord, geometryEndCoord) > this.maxStopToShapeSnapDistance);
    }

    private LineString getSegmentGeometry(FeedScopedId shapeId, LocationIndexedLine locationIndexedLine, LinearLocation startIndex, LinearLocation endIndex, double startDistance, double endDistance, StopTime st0, StopTime st1) {
        ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startDistance, endDistance);
        LineString geometry = this.geometriesByShapeSegmentKey.get(key);
        if (geometry == null) {
            geometry = (LineString)locationIndexedLine.extractLine(startIndex, endIndex);
            PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(geometry.getCoordinates(), 2);
            if (!this.isValid((Geometry)(geometry = geometryFactory.createLineString((CoordinateSequence)sequence)), st0.getStop(), st1.getStop())) {
                this.issueStore.add(new BogusShapeGeometryCaught(shapeId, st0, st1));
                geometry = this.createSimpleGeometry(st0.getStop(), st1.getStop());
            }
            this.geometriesByShapeSegmentKey.put(key, geometry);
        }
        return geometry;
    }

    private List<ShapePoint> getUniqueShapePointsForShapeId(FeedScopedId shapeId) {
        List<ShapePoint> points = this.transitService.getShapePointsForShapeId(shapeId);
        ArrayList<ShapePoint> filtered = new ArrayList<ShapePoint>(points.size());
        ShapePoint last = null;
        for (ShapePoint sp : points) {
            if (last == null || last.getSequence() != sp.getSequence()) {
                if (last != null && last.getLat() == sp.getLat() && last.getLon() == sp.getLon()) {
                    LOG.trace("pair of identical shape points (skipping): {} {}", (Object)last, (Object)sp);
                } else {
                    filtered.add(sp);
                }
            }
            last = sp;
        }
        if (filtered.size() != points.size()) {
            filtered.trimToSize();
            return filtered;
        }
        return new ArrayList<ShapePoint>(points);
    }

    private LineString getLineStringForShapeId(FeedScopedId shapeId) {
        LineString geometry = this.geometriesByShapeId.get(shapeId);
        if (geometry != null) {
            return geometry;
        }
        List<ShapePoint> points = this.getUniqueShapePointsForShapeId(shapeId);
        if (points.size() < 2) {
            return null;
        }
        Coordinate[] coordinates = new Coordinate[points.size()];
        double[] distances = new double[points.size()];
        boolean hasAllDistances = true;
        int i = 0;
        for (ShapePoint point : points) {
            coordinates[i] = new Coordinate(point.getLon(), point.getLat());
            distances[i] = point.getDistTraveled();
            if (!point.isDistTraveledSet()) {
                hasAllDistances = false;
            }
            ++i;
        }
        PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(coordinates, 2);
        geometry = geometryFactory.createLineString((CoordinateSequence)sequence);
        this.geometriesByShapeId.put(shapeId, geometry);
        if (hasAllDistances) {
            this.distancesByShapeId.put(shapeId, distances);
        }
        return geometry;
    }

    private double[] getDistanceForShapeId(FeedScopedId shapeId) {
        this.getLineStringForShapeId(shapeId);
        return this.distancesByShapeId.get(shapeId);
    }

    private LinearLocation getSegmentFraction(double[] distances, double distance) {
        int index = Arrays.binarySearch(distances, distance);
        if (index < 0) {
            index = -(index + 1);
        }
        if (index == 0) {
            return new LinearLocation(0, 0.0);
        }
        if (index == distances.length) {
            return new LinearLocation(distances.length, 0.0);
        }
        double prevDistance = distances[index - 1];
        if (prevDistance == distances[index]) {
            return new LinearLocation(index - 1, 1.0);
        }
        double indexPart = (distance - distances[index - 1]) / (distances[index] - prevDistance);
        return new LinearLocation(index - 1, indexPart);
    }

    public void setFareServiceFactory(FareServiceFactory fareServiceFactory) {
        this.fareServiceFactory = fareServiceFactory;
    }
}

