/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.edgetype.StreetTransitStopLink;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.TransitStopStreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitToTaggedStopsModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(TransitToTaggedStopsModule.class);
    StreetVertexIndex index;
    private double searchRadiusM = 250.0;
    private double searchRadiusLat = SphericalDistanceLibrary.metersToDegrees(this.searchRadiusM);

    public List<String> provides() {
        return Arrays.asList("street to transit", "linking");
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        LOG.info("Linking transit stops to tagged bus stops...");
        this.index = graph.getStreetIndex();
        ArrayList vertices = new ArrayList();
        for (TransitStopVertex ts : graph.getVerticesOfType(TransitStopVertex.class)) {
            boolean alreadyLinked = false;
            for (Edge e : ts.getOutgoing()) {
                if (!(e instanceof StreetTransitStopLink)) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked || ts.hasPathways() || this.connectVertexToStop(ts)) continue;
            LOG.debug("Could not connect " + ts.getStop().getCode() + " at " + ts.getCoordinate().toString());
        }
    }

    private boolean connectVertexToStop(TransitStopVertex ts) {
        String stopCode = ts.getStop().getCode();
        if (stopCode == null) {
            return false;
        }
        Envelope envelope = new Envelope(ts.getCoordinate());
        double xscale = Math.cos(ts.getCoordinate().y * Math.PI / 180.0);
        envelope.expandBy(this.searchRadiusLat / xscale, this.searchRadiusLat);
        List<Vertex> vertices = this.index.getVerticesForEnvelope(envelope);
        for (Vertex v : vertices) {
            if (!(v instanceof TransitStopStreetVertex)) continue;
            TransitStopStreetVertex tsv = (TransitStopStreetVertex)v;
            if (tsv.stopCode == null || !tsv.stopCode.equals(stopCode)) continue;
            new StreetTransitStopLink(ts, tsv);
            new StreetTransitStopLink(tsv, ts);
            LOG.debug("Connected " + ts.toString() + " to " + tsv.getLabel());
            return true;
        }
        return false;
    }

    @Override
    public void checkInputs() {
    }
}

