/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ParkAndRideEntranceRemoved;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetTransitEntranceLink;
import org.opentripplanner.routing.edgetype.StreetTransitStopLink;
import org.opentripplanner.routing.edgetype.StreetVehicleParkingLink;
import org.opentripplanner.routing.edgetype.VehicleParkingEdge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingHelper;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitEntranceVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetLinkerModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(StreetLinkerModule.class);
    private Boolean addExtraEdgesToAreas = true;

    public void setAddExtraEdgesToAreas(Boolean addExtraEdgesToAreas) {
        this.addExtraEdgesToAreas = addExtraEdgesToAreas;
    }

    public List<String> provides() {
        return Arrays.asList("street to transit", "linking");
    }

    public List<String> getPrerequisites() {
        return List.of("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        graph.getLinker().setAddExtraEdgesToAreas(this.addExtraEdgesToAreas);
        if (graph.hasStreets) {
            this.linkTransitStops(graph);
            this.linkTransitEntrances(graph);
            this.linkVehicleParks(graph, issueStore);
        }
        graph.calculateConvexHull();
    }

    public void linkTransitStops(Graph graph) {
        List<TransitStopVertex> vertices = graph.getVerticesOfType(TransitStopVertex.class);
        ProgressTracker progress = ProgressTracker.track("Linking transit stops to graph", 5000, vertices.size());
        LOG.info(progress.startMessage());
        for (TransitStopVertex tStop : vertices) {
            if (tStop.hasPathways() || tStop.getDegreeOut() + tStop.getDegreeIn() > 0) continue;
            TraverseModeSet modes = new TraverseModeSet(TraverseMode.WALK);
            if (OTPFeature.FlexRouting.isOn() && graph.getAllFlexStopsFlat().contains(tStop.getStop())) {
                modes = new TraverseModeSet(TraverseMode.WALK, TraverseMode.CAR);
            }
            graph.getLinker().linkVertexPermanently(tStop, modes, LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetTransitStopLink((TransitStopVertex)vertex, (StreetVertex)streetVertex), new StreetTransitStopLink((StreetVertex)streetVertex, (TransitStopVertex)vertex)));
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private void linkTransitEntrances(Graph graph) {
        LOG.info("Linking transit entrances to graph...");
        for (TransitEntranceVertex tEntrance : graph.getVerticesOfType(TransitEntranceVertex.class)) {
            graph.getLinker().linkVertexPermanently(tEntrance, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetTransitEntranceLink((TransitEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetTransitEntranceLink((StreetVertex)streetVertex, (TransitEntranceVertex)vertex)));
        }
    }

    private void linkVehicleParks(Graph graph, DataImportIssueStore issueStore) {
        if (graph.hasLinkedBikeParks) {
            LOG.info("Already linked vehicle parks to graph...");
            return;
        }
        LOG.info("Linking vehicle parks to graph...");
        for (VehicleParkingEntranceVertex vehicleParkingEntranceVertex : graph.getVerticesOfType(VehicleParkingEntranceVertex.class)) {
            if (this.vehicleParkingEntranceHasLinks(vehicleParkingEntranceVertex)) continue;
            if (vehicleParkingEntranceVertex.getParkingEntrance().getVertex() == null) {
                StreetLinkerModule.linkVehicleParkingWithLinker(graph, vehicleParkingEntranceVertex);
                continue;
            }
            if (graph.containsVertex(vehicleParkingEntranceVertex.getParkingEntrance().getVertex())) {
                VehicleParkingHelper.linkToGraph(vehicleParkingEntranceVertex);
                continue;
            }
            issueStore.add(new ParkAndRideEntranceRemoved(vehicleParkingEntranceVertex.getParkingEntrance()));
            this.removeVehicleParkingEntranceVertexFromGraph(vehicleParkingEntranceVertex, graph);
        }
        graph.hasLinkedBikeParks = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean vehicleParkingEntranceHasLinks(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        if (!vehicleParkingEntranceVertex.getIncoming().stream().allMatch(VehicleParkingEdge.class::isInstance)) return true;
        if (vehicleParkingEntranceVertex.getOutgoing().stream().allMatch(VehicleParkingEdge.class::isInstance)) return false;
        return true;
    }

    private static void linkVehicleParkingWithLinker(Graph graph, VehicleParkingEntranceVertex vehicleParkingVertex) {
        if (vehicleParkingVertex.isWalkAccessible()) {
            graph.getLinker().linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleParkingLink((StreetVertex)streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
        if (vehicleParkingVertex.isCarAccessible()) {
            graph.getLinker().linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.CAR), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleParkingLink((StreetVertex)streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
    }

    private void removeVehicleParkingEntranceVertexFromGraph(VehicleParkingEntranceVertex vehicleParkingEntranceVertex, Graph graph) {
        VehicleParkingEdge vehicleParkingEdge = vehicleParkingEntranceVertex.getOutgoing().stream().filter(VehicleParkingEdge.class::isInstance).map(VehicleParkingEdge.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("VehicleParkingEdge missing from vertex: " + vehicleParkingEntranceVertex));
        VehicleParkingEntrance entrance = vehicleParkingEntranceVertex.getParkingEntrance();
        VehicleParking vehicleParking = vehicleParkingEdge.getVehicleParking();
        boolean removeVehicleParking = vehicleParking.getEntrances().size() == 1 && vehicleParking.getEntrances().get(0).equals(entrance);
        vehicleParkingEntranceVertex.getIncoming().forEach(graph::removeEdge);
        vehicleParkingEntranceVertex.getOutgoing().forEach(graph::removeEdge);
        graph.remove(vehicleParkingEntranceVertex);
        if (removeVehicleParking) {
            VehicleParkingService vehicleParkingService = graph.getService(VehicleParkingService.class);
            vehicleParkingService.removeVehicleParking(vehicleParking);
        } else {
            vehicleParking.getEntrances().remove(entrance);
        }
    }

    @Override
    public void checkInputs() {
    }
}

