/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.common.geometry.Subgraph;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.GraphConnectivity;
import org.opentripplanner.graph_builder.issues.GraphIsland;
import org.opentripplanner.graph_builder.issues.IsolatedStop;
import org.opentripplanner.graph_builder.issues.PrunedIslandStop;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.ElevatorEdge;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTransitEntityLink;
import org.opentripplanner.routing.edgetype.StreetTransitEntranceLink;
import org.opentripplanner.routing.edgetype.StreetTransitStopLink;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PruneNoThruIslands
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(PruneNoThruIslands.class);
    private static int islandCounter = 0;
    private int pruningThresholdIslandWithoutStops;
    private int pruningThresholdIslandWithStops;
    private final StreetLinkerModule streetLinkerModule;

    public PruneNoThruIslands(StreetLinkerModule streetLinkerModule) {
        this.streetLinkerModule = streetLinkerModule;
    }

    public List<String> provides() {
        return Collections.emptyList();
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        LOG.info("Pruning islands and areas isolated by nothru edges in street network");
        PruneNoThruIslands.pruneNoThruIslands(graph, this.pruningThresholdIslandWithoutStops, this.pruningThresholdIslandWithStops, issueStore, TraverseMode.BICYCLE);
        PruneNoThruIslands.pruneNoThruIslands(graph, this.pruningThresholdIslandWithoutStops, this.pruningThresholdIslandWithStops, issueStore, TraverseMode.WALK);
        PruneNoThruIslands.pruneNoThruIslands(graph, this.pruningThresholdIslandWithoutStops, this.pruningThresholdIslandWithStops, issueStore, TraverseMode.CAR);
        if (this.streetLinkerModule != null) {
            LOG.info("Reconnecting stops");
            this.streetLinkerModule.linkTransitStops(graph);
            int isolated = 0;
            for (TransitStopVertex tStop : graph.getVerticesOfType(TransitStopVertex.class)) {
                if (tStop.getDegreeOut() + tStop.getDegreeIn() != 0) continue;
                issueStore.add(new IsolatedStop(tStop));
                ++isolated;
            }
            LOG.info("{} stops remain isolated", (Object)isolated);
        }
        int removed = 0;
        LinkedList<Vertex> toRemove = new LinkedList<Vertex>();
        for (Vertex vertex : graph.getVerticesOfType(StreetVertex.class)) {
            if (vertex.getDegreeOut() + vertex.getDegreeIn() != 0) continue;
            toRemove.add(vertex);
        }
        for (Vertex vertex : toRemove) {
            graph.remove(vertex);
            ++removed;
        }
        LOG.info("Removed {} edgeless street vertices", (Object)removed);
    }

    @Override
    public void checkInputs() {
    }

    public void setPruningThresholdIslandWithoutStops(int pruningThresholdIslandWithoutStops) {
        this.pruningThresholdIslandWithoutStops = pruningThresholdIslandWithoutStops;
    }

    public void setPruningThresholdIslandWithStops(int pruningThresholdIslandWithStops) {
        this.pruningThresholdIslandWithStops = pruningThresholdIslandWithStops;
    }

    private static void pruneNoThruIslands(Graph graph, int maxIslandSize, int islandWithStopMaxSize, DataImportIssueStore issueStore, TraverseMode traverseMode) {
        LOG.debug("nothru pruning");
        HashMap<Vertex, Subgraph> subgraphs = new HashMap<Vertex, Subgraph>();
        HashMap<Vertex, Subgraph> extgraphs = new HashMap<Vertex, Subgraph>();
        HashMap<Vertex, ArrayList<Vertex>> neighborsForVertex = new HashMap<Vertex, ArrayList<Vertex>>();
        HashMap<Edge, Boolean> isolated = new HashMap<Edge, Boolean>();
        ArrayList<Subgraph> islands = new ArrayList<Subgraph>();
        PruneNoThruIslands.collectNeighbourVertices(graph, neighborsForVertex, traverseMode, false);
        int count = PruneNoThruIslands.collectSubGraphs(graph, neighborsForVertex, subgraphs, null, null);
        LOG.info("Islands without {} noThruTraffic edges: {}", (Object)traverseMode, (Object)count);
        PruneNoThruIslands.collectNeighbourVertices(graph, neighborsForVertex, traverseMode, true);
        count = PruneNoThruIslands.collectSubGraphs(graph, neighborsForVertex, extgraphs, null, islands);
        LOG.info("Islands with {} noThruTraffic edges: {}", (Object)traverseMode, (Object)count);
        PruneNoThruIslands.processIslands(graph, islands, isolated, true, maxIslandSize, islandWithStopMaxSize, issueStore, traverseMode);
        extgraphs = new HashMap();
        islands = new ArrayList();
        PruneNoThruIslands.collectSubGraphs(graph, neighborsForVertex, extgraphs, subgraphs, islands);
        count = PruneNoThruIslands.collectSubGraphs(graph, neighborsForVertex, extgraphs, null, islands);
        LOG.info("{} noThruTraffic island count: {}", (Object)traverseMode, (Object)count);
        LOG.info("Total {} sub graphs found", (Object)islands.size());
        count = PruneNoThruIslands.processIslands(graph, islands, isolated, false, maxIslandSize, islandWithStopMaxSize, issueStore, traverseMode);
        LOG.info("Modified {} islands", (Object)count);
    }

    private static int processIslands(Graph graph, ArrayList<Subgraph> islands, Map<Edge, Boolean> isolated, boolean markIsolated, int maxIslandSize, int islandWithStopMaxSize, DataImportIssueStore issueStore, TraverseMode traverseMode) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("isolated", 0);
        stats.put("removed", 0);
        stats.put("noThru", 0);
        stats.put("restricted", 0);
        int count = 0;
        int islandsWithStops = 0;
        int islandsWithStopsChanged = 0;
        for (Subgraph island : islands) {
            boolean changed = false;
            if (island.stopSize() > 0) {
                ++islandsWithStops;
                if (island.streetSize() >= islandWithStopMaxSize) continue;
                PruneNoThruIslands.restrictOrRemove(graph, island, isolated, stats, markIsolated, traverseMode, issueStore);
                changed = true;
                ++islandsWithStopsChanged;
                ++count;
                continue;
            }
            if (island.streetSize() >= maxIslandSize) continue;
            PruneNoThruIslands.restrictOrRemove(graph, island, isolated, stats, markIsolated, traverseMode, issueStore);
            changed = true;
            ++count;
        }
        if (markIsolated) {
            LOG.info("Detected {} isolated edges", stats.get("isolated"));
        } else {
            LOG.info("Number of islands with stops: {}", (Object)islandsWithStops);
            LOG.warn("Modified connectivity of {} islands with stops", (Object)islandsWithStopsChanged);
            LOG.info("Removed {} edges", stats.get("removed"));
            LOG.info("Removed traversal mode from {} edges", stats.get("restricted"));
            LOG.info("Converted {} edges to noThruTraffic", stats.get("noThru"));
            issueStore.add(new GraphConnectivity(traverseMode, islands.size(), islandsWithStops, islandsWithStopsChanged, ((Integer)stats.get("removed")).intValue(), ((Integer)stats.get("restricted")).intValue(), ((Integer)stats.get("noThru")).intValue()));
        }
        return count;
    }

    private static void collectNeighbourVertices(Graph graph, Map<Vertex, ArrayList<Vertex>> neighborsForVertex, TraverseMode traverseMode, boolean shouldMatchNoThruType) {
        RoutingRequest options = new RoutingRequest(new TraverseModeSet(traverseMode));
        for (Vertex gv : graph.getVertices()) {
            if (!(gv instanceof StreetVertex)) continue;
            State s0 = new State(gv, options);
            for (Edge e : gv.getOutgoing()) {
                State s1;
                Vertex in = gv;
                if (!(e instanceof StreetEdge) && !(e instanceof StreetTransitStopLink) && !(e instanceof StreetTransitEntranceLink) && !(e instanceof ElevatorEdge) && !(e instanceof FreeEdge) && !(e instanceof StreetTransitEntityLink) || e instanceof StreetEdge && shouldMatchNoThruType != ((StreetEdge)e).isNoThruTraffic(traverseMode) || (s1 = e.traverse(s0)) == null) continue;
                Vertex out = s1.getVertex();
                ArrayList<Vertex> vertexList = neighborsForVertex.get(in);
                if (vertexList == null) {
                    vertexList = new ArrayList();
                    neighborsForVertex.put(in, vertexList);
                }
                vertexList.add(out);
                vertexList = neighborsForVertex.get(out);
                if (vertexList == null) {
                    vertexList = new ArrayList();
                    neighborsForVertex.put(out, vertexList);
                }
                vertexList.add(in);
            }
        }
    }

    private static int collectSubGraphs(Graph graph, Map<Vertex, ArrayList<Vertex>> neighborsForVertex, Map<Vertex, Subgraph> newgraphs, Map<Vertex, Subgraph> subgraphs, ArrayList<Subgraph> islands) {
        int count = 0;
        for (Vertex gv : graph.getVertices()) {
            Subgraph subgraph;
            if (!(gv instanceof StreetVertex)) continue;
            Vertex vertex = gv;
            if (subgraphs != null && !subgraphs.containsKey(vertex) || newgraphs.containsKey(vertex) || !neighborsForVertex.containsKey(vertex) || (subgraph = PruneNoThruIslands.computeConnectedSubgraph(neighborsForVertex, vertex, subgraphs)) == null) continue;
            Iterator<Vertex> vIter = subgraph.streetIterator();
            while (vIter.hasNext()) {
                Vertex subnode = vIter.next();
                newgraphs.put(subnode, subgraph);
            }
            if (islands != null) {
                islands.add(subgraph);
            }
            ++count;
        }
        return count;
    }

    private static void restrictOrRemove(Graph graph, Subgraph island, Map<Edge, Boolean> isolated, Map<String, Integer> stats, boolean markIsolated, TraverseMode traverseMode, DataImportIssueStore issueStore) {
        Vertex v;
        Iterator<Vertex> vIter = island.streetIterator();
        while (vIter.hasNext()) {
            v = vIter.next();
            ArrayList<Edge> outgoing = new ArrayList<Edge>(v.getOutgoing());
            for (Edge e : outgoing) {
                if (!(e instanceof StreetEdge)) continue;
                if (markIsolated) {
                    isolated.put(e, true);
                    stats.put("isolated", stats.get("isolated") + 1);
                    continue;
                }
                StreetEdge pse = (StreetEdge)e;
                if (!isolated.containsKey(e)) {
                    if (traverseMode == TraverseMode.CAR) {
                        pse.setMotorVehicleNoThruTraffic(true);
                    } else if (traverseMode == TraverseMode.BICYCLE) {
                        pse.setBicycleNoThruTraffic(true);
                    } else if (traverseMode == TraverseMode.WALK) {
                        pse.setWalkNoThruTraffic(true);
                    }
                    stats.put("noThru", stats.get("noThru") + 1);
                    continue;
                }
                StreetTraversalPermission permission = pse.getPermission();
                if (traverseMode == TraverseMode.CAR) {
                    permission = permission.remove(StreetTraversalPermission.CAR);
                } else if (traverseMode == TraverseMode.BICYCLE) {
                    permission = permission.remove(StreetTraversalPermission.BICYCLE);
                } else if (traverseMode == TraverseMode.WALK) {
                    permission = permission.remove(StreetTraversalPermission.PEDESTRIAN);
                }
                if (permission == StreetTraversalPermission.NONE) {
                    graph.getLinker().removePermanentEdgeFromIndex(pse);
                    graph.removeEdge(pse);
                    stats.put("removed", stats.get("removed") + 1);
                    continue;
                }
                pse.setPermission(permission);
                stats.put("restricted", stats.get("restricted") + 1);
            }
        }
        if (markIsolated) {
            return;
        }
        vIter = island.streetIterator();
        while (vIter.hasNext()) {
            v = vIter.next();
            if (v.getDegreeOut() + v.getDegreeIn() != 0) continue;
            graph.remove(v);
        }
        if (traverseMode == TraverseMode.WALK) {
            vIter = island.stopIterator();
            while (vIter.hasNext()) {
                v = vIter.next();
                ArrayList<Edge> edges = new ArrayList<Edge>(v.getOutgoing());
                edges.addAll(v.getIncoming());
                for (Edge e : edges) {
                    if (!(e instanceof StreetTransitStopLink) && !(e instanceof StreetTransitEntranceLink)) continue;
                    graph.removeEdge(e);
                }
                issueStore.add(new PrunedIslandStop(v));
            }
        }
        issueStore.add(new GraphIsland(island.getRepresentativeVertex(), island.streetSize()));
    }

    private static Subgraph computeConnectedSubgraph(Map<Vertex, ArrayList<Vertex>> neighborsForVertex, Vertex startVertex, Map<Vertex, Subgraph> anchors) {
        Subgraph subgraph = new Subgraph();
        LinkedList<Vertex> q = new LinkedList<Vertex>();
        Subgraph anchor = null;
        if (anchors != null) {
            anchor = anchors.get(startVertex);
        }
        q.add(startVertex);
        while (!q.isEmpty()) {
            Vertex vertex = (Vertex)q.poll();
            for (Vertex neighbor : neighborsForVertex.get(vertex)) {
                Subgraph compare;
                if (subgraph.contains(neighbor) || anchor != null && (compare = anchors.get(neighbor)) != null && compare != anchor) continue;
                subgraph.addVertex(neighbor);
                q.add(neighbor);
            }
        }
        return subgraph;
    }
}

