/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.common.MinMap;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.algorithm.astar.AStar;
import org.opentripplanner.routing.algorithm.astar.strategies.DurationSkipEdgeStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.TrivialRemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.location.TemporaryStreetLocation;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NearbyStopFinder {
    private static final Logger LOG = LoggerFactory.getLogger(NearbyStopFinder.class);
    public final boolean useStreets;
    private final Graph graph;
    private final double durationLimitInSeconds;
    private DirectGraphFinder directGraphFinder;

    public NearbyStopFinder(Graph graph, double durationLimitInSeconds) {
        this(graph, durationLimitInSeconds, graph.hasStreets);
    }

    public NearbyStopFinder(Graph graph, double durationLimitInSeconds, boolean useStreets) {
        this.graph = graph;
        this.useStreets = useStreets;
        this.durationLimitInSeconds = durationLimitInSeconds;
        if (!useStreets) {
            this.directGraphFinder = new DirectGraphFinder(graph);
        }
    }

    public Set<NearbyStop> findNearbyStopsConsideringPatterns(Vertex vertex, RoutingRequest routingRequest, boolean reverseDirection) {
        MinMap<TripPattern, NearbyStop> closestStopForPattern = new MinMap<TripPattern, NearbyStop>();
        MinMap<FlexTrip, NearbyStop> closestStopForFlexTrip = new MinMap<FlexTrip, NearbyStop>();
        for (NearbyStop nearbyStop : this.findNearbyStops(vertex, routingRequest.clone(), reverseDirection)) {
            StopLocation ts1 = nearbyStop.stop;
            if (ts1 instanceof Stop) {
                for (TripPattern pattern : this.graph.index.getPatternsForStop(ts1)) {
                    closestStopForPattern.putMin(pattern, nearbyStop);
                }
            }
            if (!OTPFeature.FlexRouting.isOn()) continue;
            for (FlexTrip trip : this.graph.index.getFlexIndex().flexTripsByStop.get((Object)ts1)) {
                closestStopForFlexTrip.putMin(trip, nearbyStop);
            }
        }
        Set uniqueStops = Sets.newHashSet();
        uniqueStops.addAll(closestStopForFlexTrip.values());
        uniqueStops.addAll(closestStopForPattern.values());
        return uniqueStops;
    }

    public List<NearbyStop> findNearbyStops(Vertex vertex, RoutingRequest routingRequest, boolean reverseDirection) {
        if (this.useStreets) {
            return this.findNearbyStopsViaStreets(Set.of(vertex), reverseDirection, true, routingRequest);
        }
        double limitMeters = this.durationLimitInSeconds * new RoutingRequest((TraverseMode)TraverseMode.WALK).walkSpeed;
        Coordinate c0 = vertex.getCoordinate();
        return this.directGraphFinder.findClosestStops(c0.y, c0.x, limitMeters);
    }

    public List<NearbyStop> findNearbyStopsViaStreets(Set<Vertex> originVertices, boolean reverseDirection, boolean removeTempEdges, RoutingRequest routingRequest) {
        List stopsFound = Lists.newArrayList();
        for (Vertex vertex : originVertices) {
            if (!(vertex instanceof TransitStopVertex)) continue;
            stopsFound.add(new NearbyStop((TransitStopVertex)vertex, 0.0, Collections.emptyList(), new State(vertex, routingRequest)));
        }
        if (!routingRequest.streetSubRequestModes.isValid()) {
            return stopsFound;
        }
        routingRequest.setArriveBy(reverseDirection);
        if (!reverseDirection) {
            routingRequest.setRoutingContext(this.graph, originVertices, null);
        } else {
            routingRequest.setRoutingContext(this.graph, null, originVertices);
        }
        routingRequest.disableRemainingWeightHeuristic = true;
        routingRequest.rctx.remainingWeightHeuristic = new TrivialRemainingWeightHeuristic();
        routingRequest.dominanceFunction = new DominanceFunction.MinimumWeight();
        AStar astar = new AStar();
        astar.setSkipEdgeStrategy(new DurationSkipEdgeStrategy(this.durationLimitInSeconds));
        ShortestPathTree spt = astar.getShortestPathTree(routingRequest);
        ArrayListMultimap locationsMap = ArrayListMultimap.create();
        if (spt != null) {
            for (State state : spt.getAllStates()) {
                Vertex targetVertex = state.getVertex();
                if (originVertices.contains(targetVertex)) continue;
                if (targetVertex instanceof TransitStopVertex && state.isFinal()) {
                    stopsFound.add(NearbyStop.nearbyStopForState(state, ((TransitStopVertex)targetVertex).getStop()));
                }
                if (!OTPFeature.FlexRouting.isOn() || !(targetVertex instanceof StreetVertex) || ((StreetVertex)targetVertex).flexStopLocations == null) continue;
                for (FlexStopLocation flexStopLocation : ((StreetVertex)targetVertex).flexStopLocations) {
                    if (!this.canBoardFlex(state, reverseDirection)) continue;
                    locationsMap.put((Object)flexStopLocation, (Object)state);
                }
            }
        }
        if (OTPFeature.FlexRouting.isOn()) {
            for (Map.Entry entry : locationsMap.asMap().entrySet()) {
                FlexStopLocation flexStopLocation = (FlexStopLocation)entry.getKey();
                Collection states = (Collection)entry.getValue();
                State min = Collections.min(states, Comparator.comparing(State::getWeight));
                if (min.getBackState().getVertex() instanceof TemporaryStreetLocation) {
                    min = min.getBackState();
                }
                stopsFound.add(NearbyStop.nearbyStopForState(min, flexStopLocation));
            }
        }
        if (removeTempEdges) {
            routingRequest.cleanup();
        }
        return stopsFound;
    }

    public List<NearbyStop> findNearbyStopsViaStreets(Set<Vertex> originVertices, boolean reverseDirection, boolean removeTempEdges) {
        RoutingRequest routingRequest = new RoutingRequest(TraverseMode.WALK);
        return this.findNearbyStopsViaStreets(originVertices, reverseDirection, removeTempEdges, routingRequest);
    }

    private boolean canBoardFlex(State state, boolean reverse) {
        Collection<Edge> edges = reverse ? state.getVertex().getIncoming() : state.getVertex().getOutgoing();
        return edges.stream().anyMatch(e -> e instanceof StreetEdge && ((StreetEdge)e).getPermission().allows(TraverseMode.CAR));
    }
}

