/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GtfsBundle;
import org.opentripplanner.graph_builder.module.AddTransitModelEntitiesToGraph;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.graph_builder.module.geometry.GeometryAndBlockProcessor;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.gtfs.GenerateTripPatternsOperation;
import org.opentripplanner.gtfs.RepairStopTimesForEachTripOperation;
import org.opentripplanner.gtfs.mapping.GTFSToOtpTransitServiceMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsModule.class);
    private DataImportIssueStore issueStore;
    private EntityHandler counter = new EntityCounter();
    private FareServiceFactory fareServiceFactory;
    private Set<String> agencyIdsSeen = Sets.newHashSet();
    private int nextAgencyId = 1;
    private final ServiceDateInterval transitPeriodLimit;
    private List<GtfsBundle> gtfsBundles;

    public GtfsModule(List<GtfsBundle> bundles, ServiceDateInterval transitPeriodLimit) {
        this.gtfsBundles = bundles;
        this.transitPeriodLimit = transitPeriodLimit;
    }

    public List<String> provides() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("transit");
        return result;
    }

    public List<String> getPrerequisites() {
        return Collections.emptyList();
    }

    public void setFareServiceFactory(FareServiceFactory factory) {
        this.fareServiceFactory = factory;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        this.issueStore = issueStore;
        graph.clearTimeZone();
        CalendarServiceData calendarServiceData = graph.getCalendarDataService();
        try {
            for (GtfsBundle gtfsBundle : this.gtfsBundles) {
                GtfsMutableRelationalDao gtfsDao = this.loadBundle(gtfsBundle);
                GTFSToOtpTransitServiceMapper mapper = new GTFSToOtpTransitServiceMapper(gtfsBundle.getFeedId().getId(), issueStore, (GtfsRelationalDao)gtfsDao);
                mapper.mapStopTripAndRouteDatantoBuilder();
                OtpTransitServiceBuilder builder = mapper.getBuilder();
                builder.limitServiceDays(this.transitPeriodLimit);
                calendarServiceData.add(builder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    builder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(builder, issueStore));
                }
                this.repairStopTimesForEachTrip(builder.getStopTimesSortedByTrip());
                this.createTripPatterns(graph, builder, calendarServiceData.getServiceIds());
                OtpTransitService transitModel = builder.build();
                this.addTransitModelToGraph(graph, gtfsBundle, transitModel);
                this.createGeometryAndBlockProcessor(gtfsBundle, transitModel).run(graph, issueStore);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.gtfsBundles.forEach(GtfsBundle::close);
        }
        graph.clearCachedCalenderService();
        graph.putService(CalendarServiceData.class, calendarServiceData);
        graph.updateTransitFeedValidity(calendarServiceData, issueStore);
        graph.hasTransit = true;
        graph.calculateTransitCenter();
    }

    private void repairStopTimesForEachTrip(TripStopTimes stopTimesByTrip) {
        new RepairStopTimesForEachTripOperation(stopTimesByTrip, this.issueStore).run();
    }

    private void createTripPatterns(Graph graph, OtpTransitServiceBuilder builder, Set<FeedScopedId> calServiceIds) {
        GenerateTripPatternsOperation buildTPOp = new GenerateTripPatternsOperation(builder, this.issueStore, graph.deduplicator, calServiceIds);
        buildTPOp.run();
        graph.hasFrequencyService = graph.hasFrequencyService || buildTPOp.hasFrequencyBasedTrips();
        graph.hasScheduledService = graph.hasScheduledService || buildTPOp.hasScheduledTrips();
    }

    private void addTransitModelToGraph(Graph graph, GtfsBundle gtfsBundle, OtpTransitService transitModel) {
        AddTransitModelEntitiesToGraph.addToGraph(gtfsBundle.getFeedId(), transitModel, gtfsBundle.subwayAccessTime, graph);
    }

    private GeometryAndBlockProcessor createGeometryAndBlockProcessor(GtfsBundle gtfsBundle, OtpTransitService transitService) {
        return new GeometryAndBlockProcessor(transitService, this.fareServiceFactory, gtfsBundle.getMaxStopToShapeSnapDistance(), gtfsBundle.maxInterlineDistance);
    }

    private GtfsMutableRelationalDao loadBundle(GtfsBundle gtfsBundle) throws IOException {
        StoreImpl store = new StoreImpl((GtfsMutableRelationalDao)new GtfsRelationalDaoImpl());
        store.open();
        LOG.info("reading {}", (Object)gtfsBundle.toString());
        GtfsFeedId gtfsFeedId = gtfsBundle.getFeedId();
        GtfsReader reader = new GtfsReader();
        reader.setInputSource(gtfsBundle.getCsvInputSource());
        reader.setEntityStore((GenericMutableDao)store);
        reader.setInternStrings(true);
        reader.setDefaultAgencyId(gtfsFeedId.getId());
        if (LOG.isDebugEnabled()) {
            reader.addEntityHandler(this.counter);
        }
        for (Class entityClass : reader.getEntityClasses()) {
            LOG.info("reading entities: " + entityClass.getName());
            reader.readEntities(entityClass);
            store.flush();
            if (entityClass != Agency.class) continue;
            for (Agency agency : reader.getAgencies()) {
                Object agencyId = agency.getId();
                LOG.info("This Agency has the ID {}", agencyId);
                if (agencyId == null || this.agencyIdsSeen.contains(gtfsFeedId.getId() + (String)agencyId)) {
                    String generatedAgencyId = null;
                    while (generatedAgencyId == null || this.agencyIdsSeen.contains(generatedAgencyId)) {
                        generatedAgencyId = "F" + this.nextAgencyId;
                        ++this.nextAgencyId;
                    }
                    LOG.warn("The agency ID '{}' was already seen, or I think it's bad. Replacing with '{}'.", agencyId, (Object)generatedAgencyId);
                    reader.addAgencyIdMapping((String)agencyId, generatedAgencyId);
                    agency.setId(generatedAgencyId);
                    agencyId = generatedAgencyId;
                }
                if (agencyId == null) continue;
                this.agencyIdsSeen.add(gtfsFeedId.getId() + (String)agencyId);
            }
        }
        for (ShapePoint shapePoint : store.getAllEntitiesForType(ShapePoint.class)) {
            shapePoint.getShapeId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Route route : store.getAllEntitiesForType(Route.class)) {
            route.getId().setAgencyId(reader.getDefaultAgencyId());
            this.generateRouteColor(route);
        }
        for (Stop stop : store.getAllEntitiesForType(Stop.class)) {
            stop.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Trip trip : store.getAllEntitiesForType(Trip.class)) {
            trip.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (ServiceCalendar serviceCalendar : store.getAllEntitiesForType(ServiceCalendar.class)) {
            serviceCalendar.getServiceId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (ServiceCalendarDate serviceCalendarDate : store.getAllEntitiesForType(ServiceCalendarDate.class)) {
            serviceCalendarDate.getServiceId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (FareAttribute fareAttribute : store.getAllEntitiesForType(FareAttribute.class)) {
            fareAttribute.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        for (Pathway pathway : store.getAllEntitiesForType(Pathway.class)) {
            pathway.getId().setAgencyId(reader.getDefaultAgencyId());
        }
        store.close();
        return store.dao;
    }

    private void generateRouteColor(Route route) {
        double newBlue;
        double newGreen;
        String routeColor = route.getColor();
        if (routeColor == null) {
            return;
        }
        String textColor = route.getTextColor();
        if (textColor != null) {
            return;
        }
        Color routeColorColor = Color.decode("#" + routeColor);
        float[] colorComponents = routeColorColor.getRGBColorComponents(null);
        double newRed = 0.299 * Math.pow(colorComponents[0], 2.0);
        double luminance = Math.sqrt(newRed + (newGreen = 0.587 * Math.pow(colorComponents[1], 2.0)) + (newBlue = 0.114 * Math.pow(colorComponents[2], 2.0)));
        textColor = luminance > 0.5 ? "000000" : "FFFFFF";
        route.setTextColor(textColor);
    }

    @Override
    public void checkInputs() {
        for (GtfsBundle bundle : this.gtfsBundles) {
            bundle.checkInputs();
        }
    }

    private static class EntityCounter
    implements EntityHandler {
        private Map<Class<?>, Integer> _count = new HashMap();

        private EntityCounter() {
        }

        public void handleEntity(Object bean) {
            int count = this.incrementCount(bean.getClass());
            if (count % 1000000 == 0 && LOG.isDebugEnabled()) {
                String name = bean.getClass().getName();
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                LOG.debug("loading " + name + ": " + count);
            }
        }

        private int incrementCount(Class<?> entityType) {
            Integer value = this._count.get(entityType);
            if (value == null) {
                value = 0;
            }
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
            this._count.put(entityType, value);
            return value;
        }
    }

    private class StoreImpl
    implements GenericMutableDao {
        private GtfsMutableRelationalDao dao;

        StoreImpl(GtfsMutableRelationalDao dao) {
            this.dao = dao;
        }

        public void open() {
            this.dao.open();
        }

        public <T> T getEntityForId(Class<T> type, Serializable id) {
            return (T)this.dao.getEntityForId(type, id);
        }

        public void saveEntity(Object entity) {
            this.dao.saveEntity(entity);
        }

        public void flush() {
            this.dao.flush();
        }

        public void close() {
            this.dao.close();
        }

        public <T> void clearAllEntitiesForType(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
            throw new UnsupportedOperationException();
        }

        public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
            return this.dao.getAllEntitiesForType(type);
        }

        public void saveOrUpdateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }

        public void updateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }
    }
}

