/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.stats.DiscreteDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStatisticsModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(GraphStatisticsModule.class);

    public List<String> provides() {
        return Collections.emptyList();
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        DiscreteDistribution<DiscreteDistribution.ConstantQuantifiable<String>> edgeTypeDistribution = new DiscreteDistribution<DiscreteDistribution.ConstantQuantifiable<String>>();
        DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>> edgeNameDistribution = new DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>>();
        DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>> geomSizeDistribution = new DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>>();
        DiscreteDistribution<DiscreteDistribution.LogQuantifiable<Double>> geomLenDistribution = new DiscreteDistribution<DiscreteDistribution.LogQuantifiable<Double>>();
        DiscreteDistribution<DiscreteDistribution.ConstantQuantifiable<String>> vertexTypeDistribution = new DiscreteDistribution<DiscreteDistribution.ConstantQuantifiable<String>>();
        DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>> vertexNameDistribution = new DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>>();
        DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>> vertexLabelDistribution = new DiscreteDistribution<DiscreteDistribution.NumberQuantifiable<Integer>>();
        for (Edge e : graph.getEdges()) {
            edgeTypeDistribution.add(new DiscreteDistribution.ConstantQuantifiable<String>(e.getClass().toString()));
            edgeNameDistribution.add(new DiscreteDistribution.NumberQuantifiable<Integer>(e.getDefaultName() == null ? 0 : e.getDefaultName().length()), e.getDefaultName());
            if (e.getGeometry() == null) continue;
            LineString geometry = e.getGeometry();
            geomSizeDistribution.add(new DiscreteDistribution.NumberQuantifiable<Integer>(geometry.getNumPoints()));
            double lenMeters = SphericalDistanceLibrary.fastLength(geometry);
            geomLenDistribution.add(new DiscreteDistribution.LogQuantifiable<Double>(lenMeters, 5.0));
        }
        for (Vertex v : graph.getVertices()) {
            vertexTypeDistribution.add(new DiscreteDistribution.ConstantQuantifiable<String>(v.getClass().toString()));
            vertexNameDistribution.add(new DiscreteDistribution.NumberQuantifiable<Integer>(v.getDefaultName() == null ? 0 : v.getDefaultName().length()), v.getDefaultName());
            vertexLabelDistribution.add(new DiscreteDistribution.NumberQuantifiable<Integer>(v.getLabel().length()), v.getLabel());
        }
        LOG.info("Geometry size distribution (linear scale, # points):\n" + geomSizeDistribution.toString());
        LOG.info("Geometry length distribution (log scale, meters):\n" + geomLenDistribution.toString());
        LOG.info("Edge type distribution:\n" + edgeTypeDistribution.toString());
        LOG.info("Edge name distribution:\n" + edgeNameDistribution.toString());
        LOG.info("Vertex type distribution:\n" + vertexTypeDistribution.toString());
        LOG.info("Vertex name distribution:\n" + vertexNameDistribution.toString());
        LOG.info("Vertex label distribution:\n" + vertexLabelDistribution.toString());
    }

    @Override
    public void checkInputs() {
    }
}

