/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCoherencyCheckerModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(GraphCoherencyCheckerModule.class);

    public List<String> provides() {
        return Collections.emptyList();
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        boolean coherent = true;
        LOG.info("checking graph coherency...");
        for (Vertex v : graph.getVertices()) {
            if (v.getOutgoing().isEmpty() && v.getIncoming().isEmpty()) {
                LOG.error("vertex {} has no edges", (Object)v);
                coherent = false;
            }
            for (Edge e : v.getOutgoing()) {
                if (e.getFromVertex() != v) {
                    LOG.error("outgoing edge of {}: from vertex {} does not match", (Object)v, (Object)e);
                    coherent = false;
                }
                if (e.getToVertex() != null) continue;
                LOG.error("outgoing edge has no to vertex {}", (Object)e);
                coherent = false;
            }
            for (Edge e : v.getIncoming()) {
                if (e.getFromVertex() == null) {
                    LOG.error("incoming edge has no from vertex {}", (Object)e);
                    coherent = false;
                }
                if (e.getToVertex() == v) continue;
                LOG.error("incoming edge of {}: to vertex {} does not match", (Object)v, (Object)e);
                coherent = false;
            }
        }
        LOG.info("edge lists and from/to members are {}coherent.", (Object)(coherent ? "" : "not "));
    }

    @Override
    public void checkInputs() {
    }
}

