/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipFile;
import org.onebusaway.csv_entities.CsvInputSource;
import org.onebusaway.csv_entities.ZipFileCsvInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadableGtfsInputSource
implements CsvInputSource {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadableGtfsInputSource.class);
    private URL url;
    private File cacheDirectory;
    private String defaultAgencyId;
    public boolean useCached = true;
    private ZipFileCsvInputSource zip;

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    private void copyStreams(InputStream in, OutputStream out) throws IOException {
        int rc;
        byte[] buffer = new byte[1024];
        while ((rc = in.read(buffer)) != -1) {
            out.write(buffer, 0, rc);
        }
        in.close();
        out.close();
    }

    private File getTemporaryDirectory() {
        if (this.cacheDirectory != null) {
            if (!this.cacheDirectory.exists() && !this.cacheDirectory.mkdirs()) {
                throw new RuntimeException("Failed to create cache directory " + this.cacheDirectory);
            }
            return this.cacheDirectory;
        }
        return new File(System.getProperty("java.io.tmpdir"));
    }

    private File getPathForGtfsBundle() throws IOException {
        if (this.url != null) {
            String fileName;
            File gtfsFile;
            File tmpDir = this.getTemporaryDirectory();
            String cacheFile = this.defaultAgencyId;
            if (cacheFile == null) {
                cacheFile = (this.url.getHost() + this.url.getFile()).replace("/", "_");
            }
            if ((gtfsFile = new File(tmpDir, fileName = cacheFile + "_gtfs.zip")).exists()) {
                if (this.useCached) {
                    LOG.info("using already downloaded gtfs file: path=" + gtfsFile);
                    return gtfsFile;
                }
                LOG.info("useCached=false; GTFS will be re-downloaded." + gtfsFile);
            }
            LOG.info("downloading gtfs: url=" + this.url + " path=" + gtfsFile);
            BufferedInputStream in = new BufferedInputStream(this.url.openStream());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(gtfsFile));
            try {
                this.copyStreams(in, out);
            }
            catch (RuntimeException e) {
                out.close();
                if (!gtfsFile.delete()) {
                    LOG.error("Failed to delete incomplete file " + gtfsFile);
                }
                throw e;
            }
            return gtfsFile;
        }
        throw new IllegalStateException("DownloadableGtfsInputSource did not include an url");
    }

    private synchronized void checkIfDownloaded() throws IOException {
        if (this.zip == null) {
            this.zip = new ZipFileCsvInputSource(new ZipFile(this.getPathForGtfsBundle()));
        }
    }

    public boolean hasResource(String name) throws IOException {
        this.checkIfDownloaded();
        return this.zip.hasResource(name);
    }

    public InputStream getResource(String name) throws IOException {
        this.checkIfDownloaded();
        return this.zip.getResource(name);
    }

    public void close() throws IOException {
        this.checkIfDownloaded();
        this.zip.close();
    }
}

