/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.StopNotLinkedForTransfers;
import org.opentripplanner.graph_builder.module.NearbyStopFinder;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTransferGenerator
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(DirectTransferGenerator.class);
    final double radiusByDurationInSeconds;
    private final List<RoutingRequest> transferRequests;

    public List<String> provides() {
        return List.of("linking");
    }

    public List<String> getPrerequisites() {
        return List.of("street to transit");
    }

    public DirectTransferGenerator(double radiusByDurationInSeconds, List<RoutingRequest> transferRequests) {
        this.radiusByDurationInSeconds = radiusByDurationInSeconds;
        this.transferRequests = transferRequests;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        if (graph.index == null) {
            graph.index = new GraphIndex(graph);
        }
        NearbyStopFinder nearbyStopFinder = new NearbyStopFinder(graph, this.radiusByDurationInSeconds);
        if (nearbyStopFinder.useStreets) {
            LOG.info("Creating direct transfer edges between stops using the street network from OSM...");
        } else {
            LOG.info("Creating direct transfer edges between stops using straight line distance (not streets)...");
        }
        List<TransitStopVertex> stops = graph.getVerticesOfType(TransitStopVertex.class);
        ProgressTracker progress = ProgressTracker.track("Create transfer edges for stops", 1000, stops.size());
        AtomicInteger nTransfersTotal = new AtomicInteger();
        AtomicInteger nLinkedStops = new AtomicInteger();
        Multimap transfersByStop = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        ((Stream)stops.stream().parallel()).forEach(ts0 -> {
            HashMap<TransferKey, PathTransfer> distinctTransfers = new HashMap<TransferKey, PathTransfer>();
            Stop stop = ts0.getStop();
            LOG.debug("Linking stop '{}' {}", (Object)stop, ts0);
            for (RoutingRequest transferProfile : this.transferRequests) {
                RoutingRequest streetRequest = Transfer.prepareTransferRoutingRequest(transferProfile);
                for (NearbyStop sd : nearbyStopFinder.findNearbyStopsConsideringPatterns((Vertex)ts0, streetRequest, false)) {
                    if (sd.stop == stop) continue;
                    distinctTransfers.put(new TransferKey(stop, sd.stop, sd.edges), new PathTransfer(stop, sd.stop, sd.distance, sd.edges));
                }
                if (!OTPFeature.FlexRouting.isOn()) continue;
                for (NearbyStop sd : nearbyStopFinder.findNearbyStopsConsideringPatterns((Vertex)ts0, streetRequest, true)) {
                    if (sd.stop == stop || sd.stop instanceof Stop) continue;
                    distinctTransfers.put(new TransferKey(sd.stop, stop, sd.edges), new PathTransfer(sd.stop, stop, sd.distance, sd.edges));
                }
            }
            LOG.debug("Linked stop {} with {} transfers to stops with different patterns.", (Object)stop, (Object)distinctTransfers.size());
            if (distinctTransfers.isEmpty()) {
                issueStore.add(new StopNotLinkedForTransfers((TransitStopVertex)ts0));
            } else {
                distinctTransfers.values().forEach(transfer -> transfersByStop.put((Object)transfer.from, transfer));
                nLinkedStops.incrementAndGet();
                nTransfersTotal.addAndGet(distinctTransfers.size());
            }
            progress.step(m -> LOG.info(m));
        });
        graph.transfersByStop.putAll(transfersByStop);
        LOG.info(progress.completeMessage());
        LOG.info("Done connecting stops to one another. Created a total of {} transfers from {} stops.", (Object)nTransfersTotal, (Object)nLinkedStops);
        graph.hasDirectTransfers = true;
    }

    @Override
    public void checkInputs() {
    }

    private static class TransferKey {
        private final StopLocation source;
        private final StopLocation target;
        private final List<Edge> edges;

        private TransferKey(StopLocation source, StopLocation target, List<Edge> edges) {
            this.source = source;
            this.target = target;
            this.edges = edges;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransferKey that = (TransferKey)o;
            return this.source.equals(that.source) && this.target.equals(that.target) && Objects.equals(this.edges, that.edges);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target, this.edges);
        }
    }
}

