/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.BogusEdgeGeometry;
import org.opentripplanner.graph_builder.issues.BogusVertexGeometry;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckGeometryModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(CheckGeometryModule.class);
    private static final double MAX_VERTEX_SHAPE_ERROR = 150.0;

    public List<String> provides() {
        return Collections.emptyList();
    }

    public List<String> getPrerequisites() {
        return Arrays.asList("streets");
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        for (Vertex gv : graph.getVertices()) {
            if (Double.isNaN(gv.getCoordinate().x) || Double.isNaN(gv.getCoordinate().y)) {
                LOG.warn("Vertex " + gv + " has NaN location; this will cause doom.");
                issueStore.add(new BogusVertexGeometry(gv));
            }
            for (Edge e : gv.getOutgoing()) {
                LineString g = e.getGeometry();
                if (g == null) continue;
                for (Coordinate c : g.getCoordinates()) {
                    if (!Double.isNaN(c.x) && !Double.isNaN(c.y)) continue;
                    issueStore.add(new BogusEdgeGeometry(e));
                }
            }
        }
    }

    @Override
    public void checkInputs() {
    }
}

