/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.gtfs.GtfsContext;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BoardingArea;
import org.opentripplanner.model.Entrance;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.GroupOfStations;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.Pathway;
import org.opentripplanner.model.PathwayNode;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StationElement;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.WheelChairBoarding;
import org.opentripplanner.routing.edgetype.ElevatorAlightEdge;
import org.opentripplanner.routing.edgetype.ElevatorBoardEdge;
import org.opentripplanner.routing.edgetype.ElevatorHopEdge;
import org.opentripplanner.routing.edgetype.PathwayEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.routing.vertextype.TransitBoardingAreaVertex;
import org.opentripplanner.routing.vertextype.TransitEntranceVertex;
import org.opentripplanner.routing.vertextype.TransitPathwayNodeVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTransitModelEntitiesToGraph {
    private static final Logger LOG = LoggerFactory.getLogger(AddTransitModelEntitiesToGraph.class);
    private final GtfsFeedId feedId;
    private final OtpTransitService transitService;
    private final Map<StationElement, Vertex> stationElementNodes = new HashMap<StationElement, Vertex>();
    private final int subwayAccessTime;

    public static void addToGraph(GtfsContext context, Graph graph) {
        new AddTransitModelEntitiesToGraph(context).applyToGraph(graph);
    }

    public static void addToGraph(GtfsFeedId feedId, OtpTransitService transitModel, int subwayAccessTime, Graph graph) {
        new AddTransitModelEntitiesToGraph(feedId, transitModel, subwayAccessTime).applyToGraph(graph);
    }

    private AddTransitModelEntitiesToGraph(GtfsContext context) {
        this(context.getFeedId(), context.getTransitService(), 0);
    }

    private AddTransitModelEntitiesToGraph(GtfsFeedId feedId, OtpTransitService transitModel, int subwayAccessTime) {
        this.feedId = feedId;
        this.transitService = transitModel;
        this.subwayAccessTime = Math.max(subwayAccessTime, 0);
    }

    private void applyToGraph(Graph graph) {
        this.addStopsToGraphAndGenerateStopVertexes(graph);
        this.addStationsToGraph(graph);
        this.addMultiModalStationsToGraph(graph);
        this.addGroupsOfStationsToGraph(graph);
        this.addEntrancesToGraph(graph);
        this.addPathwayNodesToGraph(graph);
        this.addBoardingAreasToGraph(graph);
        this.createPathwayEdgesAndAddThemToGraph(graph);
        if (OTPFeature.FlexRouting.isOn()) {
            this.addLocationsToGraph(graph);
            this.addLocationGroupsToGraph(graph);
        }
        this.addFeedInfoToGraph(graph);
        this.addAgenciesToGraph(graph);
        this.addTransfersToGraph(graph);
        if (OTPFeature.FlexRouting.isOn()) {
            this.addFlexTripsToGraph(graph);
        }
    }

    private void addStopsToGraphAndGenerateStopVertexes(Graph graph) {
        HashMap<StopLocation, Set> stopModeMap = new HashMap<StopLocation, Set>();
        for (TripPattern pattern : this.transitService.getTripPatterns()) {
            TransitMode mode = pattern.getMode();
            graph.addTransitMode(mode);
            for (StopLocation stop : pattern.getStops()) {
                Set set = stopModeMap.computeIfAbsent(stop, s -> new HashSet());
                set.add(mode);
            }
        }
        for (Stop stop : this.transitService.getAllStops()) {
            Set modes = (Set)stopModeMap.get(stop);
            TransitStopVertex stopVertex = new TransitStopVertex(graph, stop, modes);
            if (modes != null && modes.contains((Object)TransitMode.SUBWAY)) {
                stopVertex.setStreetToStopTime(this.subwayAccessTime);
            }
            this.stationElementNodes.put(stop, stopVertex);
        }
    }

    private void addStationsToGraph(Graph graph) {
        for (Station station : this.transitService.getAllStations()) {
            graph.stationById.put(station.getId(), station);
        }
    }

    private void addMultiModalStationsToGraph(Graph graph) {
        for (MultiModalStation multiModalStation : this.transitService.getAllMultiModalStations()) {
            graph.multiModalStationById.put(multiModalStation.getId(), multiModalStation);
        }
    }

    private void addGroupsOfStationsToGraph(Graph graph) {
        for (GroupOfStations groupOfStations : this.transitService.getAllGroupsOfStations()) {
            graph.groupOfStationsById.put(groupOfStations.getId(), groupOfStations);
        }
    }

    private void addEntrancesToGraph(Graph graph) {
        for (Entrance entrance : this.transitService.getAllEntrances()) {
            TransitEntranceVertex entranceVertex = new TransitEntranceVertex(graph, entrance);
            this.stationElementNodes.put(entrance, entranceVertex);
        }
    }

    private void addPathwayNodesToGraph(Graph graph) {
        for (PathwayNode node : this.transitService.getAllPathwayNodes()) {
            TransitPathwayNodeVertex nodeVertex = new TransitPathwayNodeVertex(graph, node);
            this.stationElementNodes.put(node, nodeVertex);
        }
    }

    private void addBoardingAreasToGraph(Graph graph) {
        for (BoardingArea boardingArea : this.transitService.getAllBoardingAreas()) {
            TransitBoardingAreaVertex boardingAreaVertex = new TransitBoardingAreaVertex(graph, boardingArea);
            this.stationElementNodes.put(boardingArea, boardingAreaVertex);
            if (boardingArea.getParentStop() == null) continue;
            Vertex platformVertex = this.stationElementNodes.get(boardingArea.getParentStop());
            boolean wheelchair = boardingArea.getWheelchairBoarding() == WheelChairBoarding.POSSIBLE;
            NonLocalizedString name = new NonLocalizedString(boardingArea.getName());
            PathwayEdge.lowCost(boardingAreaVertex, platformVertex, boardingArea.getId(), name, wheelchair);
            PathwayEdge.lowCost(platformVertex, boardingAreaVertex, boardingArea.getId(), name, wheelchair);
        }
    }

    private void createPathwayEdgesAndAddThemToGraph(Graph graph) {
        for (Pathway pathway : this.transitService.getAllPathways()) {
            Vertex fromVertex = this.stationElementNodes.get(pathway.getFromStop());
            Vertex toVertex = this.stationElementNodes.get(pathway.getToStop());
            if (fromVertex != null && toVertex != null) {
                if (pathway.getPathwayMode() == 5) {
                    this.createElevatorEdgesAndAddThemToGraph(graph, pathway, fromVertex, toVertex);
                    continue;
                }
                double distance = Optional.of(pathway.getLength()).filter(l -> l > 0.0).orElseGet(() -> SphericalDistanceLibrary.distance(fromVertex.getCoordinate(), toVertex.getCoordinate()));
                new PathwayEdge(fromVertex, toVertex, pathway.getId(), NonLocalizedString.ofNullable(pathway.getName()), pathway.getTraversalTime(), distance, pathway.getStairCount(), pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible());
                if (!pathway.isBidirectional()) continue;
                new PathwayEdge(toVertex, fromVertex, pathway.getId(), NonLocalizedString.ofNullable(pathway.getReversedName()), pathway.getTraversalTime(), distance, -1 * pathway.getStairCount(), -1.0 * pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible());
                continue;
            }
            if (fromVertex == null) {
                LOG.warn("The 'fromVertex' is missing for pathway from stop {}", (Object)pathway.getFromStop());
            }
            if (toVertex != null) continue;
            LOG.warn("The 'toVertex' is missing for pathway to stop {}", (Object)pathway.getToStop());
        }
    }

    private void createElevatorEdgesAndAddThemToGraph(Graph graph, Pathway pathway, Vertex fromVertex, Vertex toVertex) {
        StationElement fromStation = fromVertex.getStationElement();
        I18NString fromVertexLevelName = fromStation == null || fromStation.getLevelName() == null ? fromVertex.getName() : new NonLocalizedString(fromStation.getLevelName());
        Double fromVertexLevelIndex = fromStation == null ? null : fromStation.getLevelIndex();
        StationElement toStation = toVertex.getStationElement();
        I18NString toVertexLevelName = toStation == null || toStation.getLevelName() == null ? toVertex.getName() : new NonLocalizedString(toStation.getLevelName());
        Double toVertexLevelIndex = toStation == null ? null : toStation.getLevelIndex();
        double levels = 1.0;
        if (fromVertexLevelIndex != null && toVertexLevelIndex != null && !fromVertexLevelIndex.equals(toVertexLevelIndex)) {
            levels = Math.abs(fromVertexLevelIndex - toVertexLevelIndex);
        }
        ElevatorOffboardVertex fromOffboardVertex = new ElevatorOffboardVertex(graph, fromVertex.getLabel() + "_" + pathway.getId() + "_offboard", fromVertex.getX(), fromVertex.getY(), fromVertexLevelName);
        ElevatorOffboardVertex toOffboardVertex = new ElevatorOffboardVertex(graph, toVertex.getLabel() + "_" + pathway.getId() + "_offboard", toVertex.getX(), toVertex.getY(), toVertexLevelName);
        PathwayEdge.lowCost(fromVertex, fromOffboardVertex, fromVertex.getName());
        PathwayEdge.lowCost(toOffboardVertex, toVertex, toVertex.getName());
        ElevatorOnboardVertex fromOnboardVertex = new ElevatorOnboardVertex(graph, fromVertex.getLabel() + "_" + pathway.getId() + "_onboard", fromVertex.getX(), fromVertex.getY(), fromVertexLevelName);
        ElevatorOnboardVertex toOnboardVertex = new ElevatorOnboardVertex(graph, toVertex.getLabel() + "_" + pathway.getId() + "_onboard", toVertex.getX(), toVertex.getY(), toVertexLevelName);
        new ElevatorBoardEdge(fromOffboardVertex, fromOnboardVertex);
        new ElevatorAlightEdge(toOnboardVertex, toOffboardVertex, toVertexLevelName);
        StreetTraversalPermission permission = StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE;
        new ElevatorHopEdge(fromOnboardVertex, toOnboardVertex, permission, levels, pathway.getTraversalTime());
        if (pathway.isBidirectional()) {
            PathwayEdge.lowCost(fromOffboardVertex, fromVertex, fromVertex.getName());
            PathwayEdge.lowCost(toVertex, toOffboardVertex, toVertex.getName());
            new ElevatorBoardEdge(toOffboardVertex, toOnboardVertex);
            new ElevatorAlightEdge(fromOnboardVertex, fromOffboardVertex, fromVertexLevelName);
            new ElevatorHopEdge(toOnboardVertex, fromOnboardVertex, permission, levels, pathway.getTraversalTime());
        }
    }

    private void addLocationsToGraph(Graph graph) {
        for (FlexStopLocation flexStopLocation : this.transitService.getAllLocations()) {
            graph.locationsById.put(flexStopLocation.getId(), flexStopLocation);
        }
    }

    private void addLocationGroupsToGraph(Graph graph) {
        for (FlexLocationGroup flexLocationGroup : this.transitService.getAllLocationGroups()) {
            graph.locationGroupsById.put(flexLocationGroup.getId(), flexLocationGroup);
        }
    }

    private void addFeedInfoToGraph(Graph graph) {
        for (FeedInfo info : this.transitService.getAllFeedInfos()) {
            graph.addFeedInfo(info);
        }
    }

    private void addAgenciesToGraph(Graph graph) {
        for (Agency agency : this.transitService.getAllAgencies()) {
            graph.addAgency(this.feedId.getId(), agency);
        }
    }

    private void addTransfersToGraph(Graph graph) {
        graph.getTransferService().addAll(this.transitService.getAllTransfers());
    }

    private void addFlexTripsToGraph(Graph graph) {
        for (FlexTrip flexTrip : this.transitService.getAllFlexTrips()) {
            graph.flexTripsById.put(flexTrip.getId(), flexTrip);
        }
    }
}

