/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.client.ClientProtocolException;
import org.onebusaway.csv_entities.CsvInputSource;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.configure.DataStoreFactory;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsBundle {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsBundle.class);
    private final CompositeDataSource dataSource;
    private URL url;
    private GtfsFeedId feedId;
    private CsvInputSource csvInputSource;
    public boolean parentStationTransfers = false;
    public boolean linkStopsToParentStations = false;
    public int subwayAccessTime;
    private double maxStopToShapeSnapDistance = 150.0;
    public int maxInterlineDistance;

    public GtfsBundle(File gtfsFile) {
        this(DataStoreFactory.compositeSource(gtfsFile, FileType.GTFS));
    }

    public GtfsBundle(CompositeDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public CsvInputSource getCsvInputSource() {
        if (this.csvInputSource == null) {
            this.csvInputSource = new CsvInputSource(){

                public boolean hasResource(String s) {
                    return GtfsBundle.this.dataSource.content().stream().anyMatch(it -> it.name().equals(s));
                }

                public InputStream getResource(String s) {
                    return GtfsBundle.this.dataSource.entry(s).asInputStream();
                }

                public void close() {
                }
            };
        }
        return this.csvInputSource;
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close datasource {}, details: {}", new Object[]{this.dataSource.path(), e.getLocalizedMessage(), e});
        }
    }

    public String toString() {
        Object src = this.dataSource.path();
        if (this.feedId != null) {
            src = (String)src + " (" + this.feedId.getId() + ")";
        }
        return "GTFS bundle at " + (String)src;
    }

    public GtfsFeedId getFeedId() {
        if (this.feedId == null) {
            this.feedId = new GtfsFeedId.Builder().fromGtfsFeed(this.getCsvInputSource()).build();
        }
        return this.feedId;
    }

    public void setFeedId(GtfsFeedId feedId) {
        this.feedId = feedId;
    }

    public void checkInputs() {
        if (this.csvInputSource != null) {
            LOG.warn("unknown CSV source type; cannot check inputs");
            return;
        }
        if (!this.dataSource.exists()) {
            throw new RuntimeException("GTFS Path " + this.dataSource.path() + " does not exist or cannot be read.");
        }
        if (this.url != null) {
            try {
                HttpUtils.testUrl(this.url.toExternalForm());
            }
            catch (ClientProtocolException e) {
                throw new RuntimeException("Error connecting to " + this.url.toExternalForm() + "\n" + e);
            }
            catch (IOException e) {
                throw new RuntimeException("GTFS url " + this.url.toExternalForm() + " cannot be read.\n" + e);
            }
        }
    }

    public double getMaxStopToShapeSnapDistance() {
        return this.maxStopToShapeSnapDistance;
    }

    public void setMaxStopToShapeSnapDistance(double maxStopToShapeSnapDistance) {
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
    }
}

