/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.linking;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.FlexLocationAdder;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.Scope;
import org.opentripplanner.graph_builder.linking.StreetSpatialIndex;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.SplitterVertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TemporarySplitterVertex;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexLinker {
    private static final Logger LOG = LoggerFactory.getLogger(VertexLinker.class);
    private final StreetSpatialIndex streetSpatialIndex = new StreetSpatialIndex();
    private final Graph graph;
    private static final double DUPLICATE_WAY_EPSILON_METERS = 0.001;
    private static final int INITIAL_SEARCH_RADIUS_METERS = 100;
    private static final int MAX_SEARCH_RADIUS_METERS = 1000;
    private static final GeometryFactory GEOMETRY_FACTORY = GeometryUtils.getGeometryFactory();
    private Boolean addExtraEdgesToAreas = false;

    public VertexLinker(Graph graph) {
        for (StreetEdge se : graph.getEdgesOfType(StreetEdge.class)) {
            this.streetSpatialIndex.insert(se.getGeometry(), se, Scope.PERMANENT);
        }
        this.graph = graph;
    }

    public void linkVertexPermanently(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        this.link(vertex, traverseModes, direction, Scope.PERMANENT, edgeFunction);
    }

    public DisposableEdgeCollection linkVertexForRealTime(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        return this.link(vertex, traverseModes, direction, Scope.REALTIME, edgeFunction);
    }

    public DisposableEdgeCollection linkVertexForRequest(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        return this.link(vertex, traverseModes, direction, Scope.REQUEST, edgeFunction);
    }

    public void removeEdgeFromIndex(Edge edge, Scope scope) {
        if (edge.getGeometry() != null) {
            this.streetSpatialIndex.remove(edge.getGeometry().getEnvelopeInternal(), edge, scope);
        }
    }

    public void removePermanentEdgeFromIndex(Edge edge) {
        this.removeEdgeFromIndex(edge, Scope.PERMANENT);
    }

    private DisposableEdgeCollection link(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, Scope scope, BiFunction<Vertex, StreetVertex, List<Edge>> edgeFunction) {
        DisposableEdgeCollection tempEdges = scope != Scope.PERMANENT ? new DisposableEdgeCollection(this.graph, scope) : null;
        try {
            Set<StreetVertex> streetVertices = this.linkToStreetEdges(vertex, traverseModes, direction, scope, 100, tempEdges);
            if (streetVertices.isEmpty()) {
                streetVertices = this.linkToStreetEdges(vertex, traverseModes, direction, scope, 1000, tempEdges);
            }
            for (StreetVertex streetVertex : streetVertices) {
                List<Edge> edges = edgeFunction.apply(vertex, streetVertex);
                if (tempEdges == null) continue;
                for (Edge edge : edges) {
                    tempEdges.addEdge(edge);
                }
            }
        }
        catch (Exception e) {
            if (tempEdges != null) {
                tempEdges.disposeEdges();
            }
            throw e;
        }
        return tempEdges;
    }

    private Set<StreetVertex> linkToStreetEdges(Vertex vertex, TraverseModeSet traverseModes, LinkingDirection direction, Scope scope, int radiusMeters, DisposableEdgeCollection tempEdges) {
        double radiusDeg = SphericalDistanceLibrary.metersToDegrees(radiusMeters);
        Envelope env = new Envelope(vertex.getCoordinate());
        double xscale = Math.cos(vertex.getLat() * Math.PI / 180.0);
        env.expandBy(radiusDeg / xscale, radiusDeg);
        List<DistanceTo<StreetEdge>> candidateEdges = this.streetSpatialIndex.query(env, scope).filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).filter(e -> e.canTraverse(traverseModes) && VertexLinker.edgeReachableFromGraph(e)).map(e -> new DistanceTo<StreetEdge>((StreetEdge)e, VertexLinker.distance(vertex, e, xscale))).filter(ead -> ead.distanceDegreesLat < radiusDeg).collect(Collectors.toList());
        if (candidateEdges.isEmpty()) {
            return Set.of();
        }
        Set<DistanceTo<StreetEdge>> closesEdges = this.getClosestEdgesPerMode(traverseModes, candidateEdges);
        return closesEdges.stream().map(ce -> this.link(vertex, (StreetEdge)ce.item, xscale, scope, direction, tempEdges)).collect(Collectors.toSet());
    }

    private Set<DistanceTo<StreetEdge>> getClosestEdgesPerMode(TraverseModeSet traverseModeSet, List<DistanceTo<StreetEdge>> candidateEdges) {
        double DUPLICATE_WAY_EPSILON_DEGREES = SphericalDistanceLibrary.metersToDegrees(0.001);
        HashSet<DistanceTo<StreetEdge>> closesEdges = new HashSet<DistanceTo<StreetEdge>>();
        for (TraverseMode mode : traverseModeSet.getModes()) {
            TraverseModeSet modeSet = new TraverseModeSet(mode);
            List candidateEdgesForMode = candidateEdges.stream().filter(e -> ((StreetEdge)e.item).canTraverse(modeSet)).collect(Collectors.toList());
            if (candidateEdgesForMode.isEmpty()) continue;
            double closestDistance = candidateEdgesForMode.stream().mapToDouble(ce -> ce.distanceDegreesLat).min().getAsDouble();
            closesEdges.addAll(candidateEdges.stream().filter(ce -> ce.distanceDegreesLat <= closestDistance + DUPLICATE_WAY_EPSILON_DEGREES).collect(Collectors.toSet()));
        }
        return closesEdges;
    }

    private static boolean edgeReachableFromGraph(Edge edge) {
        boolean edgeReachableFromGraph = edge.getToVertex().getIncoming().contains(edge);
        if (!edgeReachableFromGraph) {
            LOG.error("Edge returned from spatial index is no longer reachable from graph. That is not expected.");
        }
        return edgeReachableFromGraph;
    }

    private StreetVertex link(Vertex vertex, StreetEdge edge, double xScale, Scope scope, LinkingDirection direction, DisposableEdgeCollection tempEdges) {
        LineString orig = edge.getGeometry();
        LineString transformed = VertexLinker.equirectangularProject(orig, xScale);
        LocationIndexedLine il = new LocationIndexedLine((Geometry)transformed);
        LinearLocation ll = il.project(new Coordinate(vertex.getLon() * xScale, vertex.getLat()));
        double length = SphericalDistanceLibrary.length(orig);
        if (ll.getSegmentIndex() == 0 && (ll.getSegmentFraction() < 1.0E-8 || ll.getSegmentFraction() * length < 0.1)) {
            return (StreetVertex)edge.getFromVertex();
        }
        if (ll.getSegmentIndex() == orig.getNumPoints() - 1) {
            return (StreetVertex)edge.getToVertex();
        }
        if (ll.getSegmentIndex() == orig.getNumPoints() - 2 && (ll.getSegmentFraction() > 0.99999999 || (1.0 - ll.getSegmentFraction()) * length < 0.1)) {
            return (StreetVertex)edge.getToVertex();
        }
        SplitterVertex v0 = this.split(edge, ll, scope, direction, tempEdges);
        if (scope == Scope.PERMANENT && this.addExtraEdgesToAreas.booleanValue() && edge instanceof AreaEdge) {
            ((AreaEdge)edge).getArea().addVertex(v0);
        }
        if (OTPFeature.FlexRouting.isOn()) {
            FlexLocationAdder.addFlexLocations(edge, v0, this.graph);
        }
        return v0;
    }

    private static double distance(Vertex tstop, StreetEdge edge, double xscale) {
        LineString transformed = VertexLinker.equirectangularProject(edge.getGeometry(), xscale);
        return transformed.distance((Geometry)GEOMETRY_FACTORY.createPoint(new Coordinate(tstop.getLon() * xscale, tstop.getLat())));
    }

    private static LineString equirectangularProject(LineString geometry, double xScale) {
        Coordinate[] coords = new Coordinate[geometry.getNumPoints()];
        for (int i = 0; i < coords.length; ++i) {
            Coordinate c = geometry.getCoordinateN(i);
            c = (Coordinate)c.clone();
            c.x *= xScale;
            coords[i] = c;
        }
        return GEOMETRY_FACTORY.createLineString(coords);
    }

    private SplitterVertex split(StreetEdge originalEdge, LinearLocation ll, Scope scope, LinkingDirection direction, DisposableEdgeCollection tempEdges) {
        P2<StreetEdge> newEdges;
        SplitterVertex v;
        LineString geometry = originalEdge.getGeometry();
        Coordinate splitPoint = ll.getCoordinate((Geometry)geometry);
        String uniqueSplitLabel = "split_" + this.graph.nextSplitNumber++;
        if (scope != Scope.PERMANENT) {
            TemporarySplitterVertex tsv = new TemporarySplitterVertex(uniqueSplitLabel, splitPoint.x, splitPoint.y, originalEdge, direction == LinkingDirection.OUTGOING);
            tsv.setWheelchairAccessible(originalEdge.isWheelchairAccessible());
            v = tsv;
        } else {
            v = new SplitterVertex(this.graph, uniqueSplitLabel, splitPoint.x, splitPoint.y, originalEdge);
        }
        P2<StreetEdge> p2 = newEdges = scope == Scope.PERMANENT ? originalEdge.splitDestructively(v) : originalEdge.splitNonDestructively(v, tempEdges, direction);
        if (scope == Scope.REALTIME || scope == Scope.PERMANENT) {
            if (newEdges.first != null) {
                this.streetSpatialIndex.insert(((StreetEdge)newEdges.first).getGeometry(), newEdges.first, scope);
            }
            if (newEdges.second != null) {
                this.streetSpatialIndex.insert(((StreetEdge)newEdges.second).getGeometry(), newEdges.second, scope);
            }
            if (scope == Scope.PERMANENT) {
                originalEdge.getToVertex().removeIncoming(originalEdge);
                originalEdge.getFromVertex().removeOutgoing(originalEdge);
                this.removeEdgeFromIndex(originalEdge, scope);
            }
        }
        return v;
    }

    public void setAddExtraEdgesToAreas(Boolean addExtraEdgesToAreas) {
        this.addExtraEdgesToAreas = addExtraEdgesToAreas;
    }

    private static class DistanceTo<T> {
        T item;
        double distanceDegreesLat;

        public DistanceTo(T item, double distanceDegreesLat) {
            this.item = item;
            this.distanceDegreesLat = distanceDegreesLat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistanceTo that = (DistanceTo)o;
            return Objects.equals(this.item, that.item);
        }

        public int hashCode() {
            return Objects.hash(this.item);
        }
    }
}

