/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.linking;

import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.graph_builder.linking.Scope;
import org.opentripplanner.routing.graph.Edge;

class StreetSpatialIndex {
    private final HashGridSpatialIndex<Edge> permanentIndex = new HashGridSpatialIndex();
    private final HashGridSpatialIndex<Edge> realTimeIndex = new HashGridSpatialIndex();

    StreetSpatialIndex() {
    }

    void insert(LineString lineString, Object obj, Scope scope) {
        switch (scope) {
            case PERMANENT: {
                this.permanentIndex.insert(lineString, obj);
                break;
            }
            case REALTIME: {
                this.realTimeIndex.insert(lineString, obj);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    void remove(Envelope envelope, Object item, Scope scope) {
        switch (scope) {
            case PERMANENT: {
                this.permanentIndex.remove(envelope, item);
                return;
            }
            case REALTIME: {
                this.realTimeIndex.remove(envelope, item);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    final Stream<Edge> query(Envelope envelope, Scope scope) {
        switch (scope) {
            case PERMANENT: 
            case REALTIME: {
                return this.permanentIndex.query(envelope).stream();
            }
            case REQUEST: {
                return Stream.concat(this.permanentIndex.query(envelope).stream(), this.realTimeIndex.query(envelope).stream());
            }
        }
        throw new IllegalArgumentException();
    }
}

