/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.linking;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.Scope;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.TemporaryFreeEdge;
import org.opentripplanner.routing.edgetype.TemporaryPartialStreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.NonLocalizedString;

public class SameEdgeAdjuster {
    private SameEdgeAdjuster() {
    }

    public static DisposableEdgeCollection adjust(Vertex from, Vertex to, Graph graph) {
        DisposableEdgeCollection tempEdges = new DisposableEdgeCollection(graph, Scope.REQUEST);
        if (from == null || to == null) {
            return tempEdges;
        }
        try {
            HashSet<StreetVertex> fromVertices = new HashSet<StreetVertex>();
            for (Edge outgoing : from.getOutgoing()) {
                Vertex toVertex = outgoing.getToVertex();
                if (outgoing instanceof TemporaryFreeEdge && toVertex instanceof StreetVertex && toVertex.getOutgoing().stream().anyMatch(edge -> edge instanceof TemporaryPartialStreetEdge)) {
                    fromVertices.add((StreetVertex)toVertex);
                    continue;
                }
                if (!(outgoing instanceof TemporaryPartialStreetEdge) || !(from instanceof StreetVertex)) continue;
                fromVertices.add((StreetVertex)from);
            }
            HashSet<StreetVertex> toVertices = new HashSet<StreetVertex>();
            for (Edge incoming : to.getIncoming()) {
                Vertex fromVertex = incoming.getFromVertex();
                if (incoming instanceof TemporaryFreeEdge && fromVertex instanceof StreetVertex && fromVertex.getIncoming().stream().anyMatch(edge -> edge instanceof TemporaryPartialStreetEdge)) {
                    toVertices.add((StreetVertex)fromVertex);
                    continue;
                }
                if (!(incoming instanceof TemporaryPartialStreetEdge) || !(to instanceof StreetVertex)) continue;
                toVertices.add((StreetVertex)to);
            }
            for (StreetVertex fromStreetVertex : fromVertices) {
                for (StreetVertex toStreetVertex : toVertices) {
                    Set<StreetEdge> overlap = SameEdgeAdjuster.overlappingParentStreetEdges(fromStreetVertex, toStreetVertex);
                    for (StreetEdge pse : overlap) {
                        SameEdgeAdjuster.makePartialEdgeAlong(pse, fromStreetVertex, toStreetVertex, tempEdges);
                    }
                }
            }
        }
        catch (Exception e) {
            tempEdges.disposeEdges();
            throw e;
        }
        return tempEdges;
    }

    private static Set<StreetEdge> overlappingParentStreetEdges(Vertex u, Vertex v) {
        Set<StreetEdge> vEdges = SameEdgeAdjuster.getConnectedParentEdges(v);
        Set<StreetEdge> uEdges = SameEdgeAdjuster.getConnectedParentEdges(u);
        return Sets.intersection(uEdges, vEdges);
    }

    private static Set<StreetEdge> getConnectedParentEdges(Vertex loc) {
        return Stream.concat(loc.getIncoming().stream(), loc.getOutgoing().stream()).filter(it -> it instanceof TemporaryPartialStreetEdge).map(it -> ((TemporaryPartialStreetEdge)it).getParentEdge()).collect(Collectors.toSet());
    }

    private static void makePartialEdgeAlong(StreetEdge streetEdge, StreetVertex from, StreetVertex to, DisposableEdgeCollection tempEdges) {
        LineString parent = streetEdge.getGeometry();
        LineString head = GeometryUtils.getInteriorSegment((Geometry)parent, streetEdge.getFromVertex().getCoordinate(), from.getCoordinate());
        LineString tail = GeometryUtils.getInteriorSegment((Geometry)parent, to.getCoordinate(), streetEdge.getToVertex().getCoordinate());
        if (parent.getLength() > head.getLength() + tail.getLength()) {
            LineString partial = GeometryUtils.getInteriorSegment((Geometry)parent, from.getCoordinate(), to.getCoordinate());
            double lengthRatio = partial.getLength() / parent.getLength();
            double length = streetEdge.getDistanceMeters() * lengthRatio;
            String name = from.getLabel() + " to " + to.getLabel();
            tempEdges.addEdge(new TemporaryPartialStreetEdge(streetEdge, from, to, partial, new NonLocalizedString(name), length));
        }
    }
}

