/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issues;

import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.model.Trip;

public class HopSpeedSlow
implements DataImportIssue {
    public static final String FMT = "Very slow speed of %.2f kph over %.1fm on route %s trip %s stop sequence %d.";
    final float metersPerSecond;
    final float distance;
    final Trip trip;
    final int seq;

    public HopSpeedSlow(float metersPerSecond, float distance, Trip trip, int seq) {
        this.metersPerSecond = metersPerSecond;
        this.distance = distance;
        this.trip = trip;
        this.seq = seq;
    }

    @Override
    public String getMessage() {
        double kph = (double)this.metersPerSecond * 3.6;
        return String.format(FMT, kph, Float.valueOf(this.distance), this.trip.getRoute().getId(), this.trip.getId(), this.seq);
    }
}

