/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.csvreader.CsvWriter;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.SerializedGraphObject;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStats {
    private static final Logger LOG = LoggerFactory.getLogger(GraphStats.class);
    @Parameter(names={"-v", "--verbose"}, description="Verbose output")
    private boolean verbose = false;
    @Parameter(names={"-d", "--debug"}, description="Debug mode")
    private boolean debug = false;
    @Parameter(names={"-h", "--help"}, description="Print this help message and exit", help=true)
    private boolean help;
    @Parameter(names={"-g", "--graph"}, description="path to the graph file", required=true)
    private String graphPath;
    @Parameter(names={"-o", "--out"}, description="output file")
    private String outPath;
    private CommandEndpoints commandEndpoints = new CommandEndpoints();
    private CommandPatternStats commandPatternStats = new CommandPatternStats();
    private JCommander jc = new JCommander((Object)this);
    private Graph graph;
    private CsvWriter writer;

    public static void main(String[] args) {
        GraphStats graphStats = new GraphStats(args);
        try {
            graphStats.run();
        }
        catch (OtpAppException otpAppException) {
            // empty catch block
        }
    }

    private GraphStats(String[] args) {
        this.jc.addCommand((Object)this.commandEndpoints);
        this.jc.addCommand((Object)this.commandPatternStats);
        try {
            this.jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.jc.usage();
            System.exit(1);
        }
        if (this.help || this.jc.getParsedCommand() == null) {
            this.jc.usage();
            System.exit(0);
        }
    }

    private void run() {
        File graphFile = new File(this.graphPath);
        this.graph = SerializedGraphObject.load(graphFile);
        if (this.outPath != null) {
            try {
                this.writer = new CsvWriter(this.outPath, ',', Charset.forName("UTF8"));
            }
            catch (Exception e) {
                LOG.error("Exception while opening output file " + this.outPath);
                return;
            }
        } else {
            this.writer = new CsvWriter((OutputStream)System.out, ',', Charset.forName("UTF8"));
        }
        LOG.info("done loading graph.");
        String command = this.jc.getParsedCommand();
        if (command.equals("endpoints")) {
            this.commandEndpoints.run();
        } else if (command.equals("patternstats")) {
            this.commandPatternStats.run();
        }
        this.writer.close();
    }

    @Parameters(commandNames={"patternstats"}, commandDescription="trip pattern stats")
    class CommandPatternStats {
        CommandPatternStats() {
        }

        public void run() {
            LOG.info("counting number of trips per pattern...");
            try {
                GraphStats.this.writer.writeRecord(new String[]{"nTripsInPattern", "frequency", "cumulativePatterns", "empiricalDistPatterns", "cumulativeTrips", "empiricalDistTrips"});
                Collection<TripPattern> patterns = GraphStats.this.graph.tripPatternForId.values();
                TreeMultiset counts = TreeMultiset.create();
                int nPatterns = patterns.size();
                LOG.info("total number of patterns is: {}", (Object)nPatterns);
                int nTrips = 0;
                for (TripPattern ttp : patterns) {
                    int patternNumTrips = (int)ttp.scheduledTripsAsStream().count();
                    counts.add((Object)patternNumTrips);
                    nTrips += patternNumTrips;
                }
                LOG.info("total number of trips is: {}", (Object)nTrips);
                LOG.info("average number of trips per pattern is: {}", (Object)(nTrips / nPatterns));
                int cPatterns = 0;
                int cTrips = 0;
                for (Multiset.Entry count : counts.entrySet()) {
                    GraphStats.this.writer.writeRecord(new String[]{((Integer)count.getElement()).toString(), Integer.toString(count.getCount()), Integer.toString(cPatterns += count.getCount()), Double.toString((double)cPatterns / (double)nPatterns), Integer.toString(cTrips += count.getCount() * (Integer)count.getElement()), Double.toString((double)cTrips / (double)nTrips)});
                }
            }
            catch (IOException e) {
                LOG.error("Exception writing CSV: {}", (Object)e.getMessage());
                return;
            }
            LOG.info("done.");
        }
    }

    @Parameters(commandNames={"endpoints"}, commandDescription="Generate random endpoints for performance testing")
    class CommandEndpoints {
        @Parameter(names={"-r", "--radius"}, description="perturbation radius in meters")
        private double radius = 100.0;
        @Parameter(names={"-n", "--number"}, description="number of endpoints to generate")
        private int n = 20;
        @Parameter(names={"-s", "--stops"}, description="choose endpoints near stops not street vertices")
        private boolean useStops = false;
        @Parameter(names={"-rs", "--seed"}, description="random seed, allows reproducible results")
        private Long seed = null;

        CommandEndpoints() {
        }

        public void run() {
            LOG.info(String.format("Producing %d random endpoints within radius %2.2fm around %s.", this.n, this.radius, this.useStops ? "stops" : "streets"));
            List vertices = new ArrayList<Vertex>();
            GeodeticCalculator gc = new GeodeticCalculator();
            Class klasse = this.useStops ? TransitStopVertex.class : StreetVertex.class;
            for (Vertex v : GraphStats.this.graph.getVertices()) {
                if (!klasse.isInstance(v)) continue;
                vertices.add(v);
            }
            Random random = new Random();
            if (this.seed != null) {
                random.setSeed(this.seed);
            }
            Collections.shuffle(vertices, random);
            vertices = vertices.subList(0, this.n);
            try {
                GraphStats.this.writer.writeRecord(new String[]{"n", "name", "lon", "lat"});
                int i = 0;
                for (Vertex v : vertices) {
                    Coordinate c;
                    if (v instanceof StreetVertex) {
                        LineString ls = ((StreetVertex)v).getOutgoing().iterator().next().getGeometry();
                        int numPoints = ls.getNumPoints();
                        LocationIndexedLine lil = new LocationIndexedLine((Geometry)ls);
                        int seg = random.nextInt(numPoints);
                        double frac = random.nextDouble();
                        LinearLocation ll = new LinearLocation(seg, frac);
                        c = lil.extractPoint(ll);
                    } else {
                        c = v.getCoordinate();
                    }
                    double distance = random.nextDouble() * this.radius;
                    double azimuth = random.nextDouble() * 360.0 - 180.0;
                    gc.setStartingGeographicPoint(c.x, c.y);
                    gc.setDirection(azimuth, distance);
                    Point2D dest = gc.getDestinationGeographicPoint();
                    String name = v.getDefaultName();
                    String[] entries = new String[]{Integer.toString(i), name, Double.toString(dest.getX()), Double.toString(dest.getY())};
                    GraphStats.this.writer.writeRecord(entries);
                    ++i;
                }
            }
            catch (IOException ioe) {
                LOG.error("Excpetion while writing CSV: {}", (Object)ioe.getMessage());
            }
            LOG.info("done.");
        }
    }
}

