/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilderDataSources {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilderDataSources.class);
    private static final String BULLET_POINT = "- ";
    private final OtpDataStore store;
    private final Multimap<FileType, DataSource> inputData = ArrayListMultimap.create();
    private final Multimap<FileType, DataSource> skipData = ArrayListMultimap.create();
    private final Set<FileType> includeTypes = EnumSet.complementOf(EnumSet.of(FileType.UNKNOWN));
    private final File cacheDirectory;
    private final DataSource outputGraph;

    private GraphBuilderDataSources(CommandLineParameters cli, BuildConfig bc, OtpDataStore store) {
        this.store = store;
        this.cacheDirectory = cli.cacheDirectory;
        this.outputGraph = this.getOutputGraph(cli);
        this.include(cli.doBuildStreet() && bc.streets, FileType.OSM);
        this.include(cli.doBuildStreet() && bc.streets, FileType.DEM);
        this.include(cli.doBuildTransit() && bc.transit, FileType.GTFS);
        this.include(cli.doBuildTransit() && bc.transit, FileType.NETEX);
        this.selectFilesToImport();
        this.logSkippedAndSelectedFiles();
        this.validateCliMatchesInputData(cli);
    }

    public static GraphBuilderDataSources create(CommandLineParameters cli, BuildConfig bc, OtpDataStore store) {
        return new GraphBuilderDataSources(cli, bc, store);
    }

    boolean has(FileType type) {
        return this.inputData.containsKey((Object)type);
    }

    Iterable<DataSource> get(FileType type) {
        return this.inputData.get((Object)type);
    }

    CompositeDataSource getBuildReportDir() {
        return this.store.getBuildReportDir();
    }

    File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public DataSource getOutputGraph() {
        return this.outputGraph;
    }

    private boolean hasOneOf(FileType ... types) {
        for (FileType type : types) {
            if (!this.has(type)) continue;
            return true;
        }
        return false;
    }

    private void logSkippedAndSelectedFiles() {
        LOG.info("Data source location(s): {}", (Object)String.join((CharSequence)", ", this.store.getRepositoryDescriptions()));
        LOG.info("Existing files expected to be read or written:");
        for (FileType type : FileType.values()) {
            for (DataSource source : this.inputData.get((Object)type)) {
                LOG.info(BULLET_POINT + source.detailedInfo());
            }
        }
        if (!this.skipData.values().isEmpty()) {
            LOG.info("Files excluded due to command line switches or unknown type:");
            for (FileType type : FileType.values()) {
                for (DataSource source : this.skipData.get((Object)type)) {
                    LOG.info(BULLET_POINT + source.detailedInfo());
                }
            }
        }
    }

    private void validateCliMatchesInputData(CommandLineParameters cli) {
        if (cli.build) {
            if (!this.hasOneOf(FileType.OSM, FileType.GTFS, FileType.NETEX)) {
                throw new OtpAppException("Unable to build graph, no transit data available.");
            }
        } else if (cli.buildStreet) {
            if (!this.has(FileType.OSM)) {
                throw new OtpAppException("Unable to build street graph, no OSM data available.");
            }
        } else if (cli.load) {
            if (!this.store.getGraph().exists()) {
                throw new OtpAppException("Unable to load graph, no graph file found: %s", this.store.getGraph().path());
            }
        } else if (cli.loadStreet && !this.store.getStreetGraph().exists()) {
            throw new OtpAppException("Unable to load street graph, no street graph file found: %s", this.store.getStreetGraph().path());
        }
    }

    private DataSource getOutputGraph(CommandLineParameters cli) {
        if (cli.doSaveGraph()) {
            return this.store.getGraph();
        }
        if (cli.doSaveStreetGraph()) {
            return this.store.getStreetGraph();
        }
        return null;
    }

    private void include(boolean include, FileType type) {
        if (include) {
            this.includeTypes.add(type);
        } else {
            this.includeTypes.remove((Object)type);
        }
    }

    private void selectFilesToImport() {
        for (FileType type : FileType.values()) {
            if (this.includeTypes.contains((Object)type)) {
                this.inputData.putAll((Object)type, this.store.listExistingSourcesFor(type));
                continue;
            }
            this.skipData.putAll((Object)type, this.store.listExistingSourcesFor(type));
        }
    }
}

