/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.ext.dataoverlay.configure.DataOverlayFactory;
import org.opentripplanner.ext.flex.FlexLocationsToStreetEdgesMapper;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.DataImportIssuesToHTML;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.model.GtfsBundle;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GtfsModule;
import org.opentripplanner.graph_builder.module.PruneNoThruIslands;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TransitToTaggedStopsModule;
import org.opentripplanner.graph_builder.module.map.BusRouteStreetMatcher;
import org.opentripplanner.graph_builder.module.ned.DegreeGridNEDTileSource;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.ned.GeotiffGridCoverageFactoryImpl;
import org.opentripplanner.graph_builder.module.ned.NEDGridCoverageFactoryImpl;
import org.opentripplanner.graph_builder.module.osm.OpenStreetMapModule;
import org.opentripplanner.graph_builder.services.DefaultStreetEdgeFactory;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.graph_builder.services.ned.ElevationGridCoverageFactory;
import org.opentripplanner.netex.configure.NetexConfig;
import org.opentripplanner.openstreetmap.BinaryOpenStreetMapProvider;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.S3BucketConfig;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilder
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilder.class);
    private final List<GraphBuilderModule> graphBuilderModules = new ArrayList<GraphBuilderModule>();
    private final Graph graph;

    private GraphBuilder(Graph baseGraph) {
        this.graph = baseGraph == null ? new Graph() : baseGraph;
    }

    private void addModule(GraphBuilderModule loader) {
        this.graphBuilderModules.add(loader);
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        for (GraphBuilderModule builder : this.graphBuilderModules) {
            builder.checkInputs();
        }
        DataImportIssueStore issueStore = new DataImportIssueStore(true);
        HashMap extra = new HashMap();
        for (GraphBuilderModule load : this.graphBuilderModules) {
            load.buildGraph(this.graph, extra, issueStore);
        }
        issueStore.summarize();
        long endTime = System.currentTimeMillis();
        LOG.info(String.format("Graph building took %.1f minutes.", (double)((endTime - startTime) / 1000L) / 60.0));
        LOG.info("Main graph size: |V|={} |E|={}", (Object)this.graph.countVertices(), (Object)this.graph.countEdges());
    }

    public static GraphBuilder create(BuildConfig config, GraphBuilderDataSources dataSources, Graph baseGraph, boolean loadStreetGraph, boolean saveStreetGraph) {
        GraphBuilderModule module;
        boolean hasOsm = dataSources.has(FileType.OSM);
        boolean hasDem = dataSources.has(FileType.DEM);
        boolean hasGtfs = dataSources.has(FileType.GTFS);
        boolean hasNetex = dataSources.has(FileType.NETEX);
        boolean hasTransitData = hasGtfs || hasNetex;
        GraphBuilder graphBuilder = new GraphBuilder(baseGraph);
        if (hasOsm) {
            ArrayList osmProviders = Lists.newArrayList();
            for (DataSource osmFile : dataSources.get(FileType.OSM)) {
                osmProviders.add(new BinaryOpenStreetMapProvider(osmFile, config.osmCacheDataInMem));
            }
            OpenStreetMapModule osmModule = new OpenStreetMapModule(osmProviders);
            DefaultStreetEdgeFactory streetEdgeFactory = new DefaultStreetEdgeFactory();
            streetEdgeFactory.useElevationData = hasDem;
            osmModule.edgeFactory = streetEdgeFactory;
            osmModule.customNamer = config.customNamer;
            osmModule.setDefaultWayPropertySetSource(config.osmWayPropertySet);
            osmModule.skipVisibility = !config.areaVisibility;
            osmModule.platformEntriesLinking = config.platformEntriesLinking;
            osmModule.staticBikeParkAndRide = config.staticBikeParkAndRide;
            osmModule.staticParkAndRide = config.staticParkAndRide;
            osmModule.banDiscouragedWalking = config.banDiscouragedWalking;
            osmModule.banDiscouragedBiking = config.banDiscouragedBiking;
            osmModule.maxAreaNodes = config.maxAreaNodes;
            graphBuilder.addModule(osmModule);
        }
        if (hasGtfs) {
            ArrayList gtfsBundles = Lists.newArrayList();
            for (DataSource gtfsData : dataSources.get(FileType.GTFS)) {
                GtfsBundle gtfsBundle = new GtfsBundle((CompositeDataSource)gtfsData);
                if (config.parentStopLinking) {
                    gtfsBundle.linkStopsToParentStations = true;
                }
                gtfsBundle.parentStationTransfers = config.stationTransfers;
                gtfsBundle.subwayAccessTime = config.getSubwayAccessTimeSeconds();
                gtfsBundle.maxInterlineDistance = config.maxInterlineDistance;
                gtfsBundle.setMaxStopToShapeSnapDistance(config.maxStopToShapeSnapDistance);
                gtfsBundles.add(gtfsBundle);
            }
            GtfsModule gtfsModule = new GtfsModule(gtfsBundles, config.getTransitServicePeriod());
            gtfsModule.setFareServiceFactory(config.fareServiceFactory);
            graphBuilder.addModule(gtfsModule);
        }
        if (hasNetex) {
            graphBuilder.addModule(NetexConfig.netexModule(config, dataSources.get(FileType.NETEX)));
        }
        if (hasTransitData && (hasOsm || graphBuilder.graph.hasStreets)) {
            if (config.matchBusRoutesToStreets) {
                graphBuilder.addModule(new BusRouteStreetMatcher());
            }
            graphBuilder.addModule(new TransitToTaggedStopsModule());
        }
        StreetLinkerModule streetLinkerModule = new StreetLinkerModule();
        streetLinkerModule.setAddExtraEdgesToAreas(config.areaVisibility);
        graphBuilder.addModule(streetLinkerModule);
        if (hasOsm && !saveStreetGraph || loadStreetGraph) {
            PruneNoThruIslands pruneNoThruIslands = new PruneNoThruIslands(streetLinkerModule);
            pruneNoThruIslands.setPruningThresholdIslandWithoutStops(config.pruningThresholdIslandWithoutStops);
            pruneNoThruIslands.setPruningThresholdIslandWithStops(config.pruningThresholdIslandWithStops);
            graphBuilder.addModule(pruneNoThruIslands);
        }
        ArrayList<ElevationGridCoverageFactory> elevationGridCoverageFactories = new ArrayList<ElevationGridCoverageFactory>();
        if (config.elevationBucket != null) {
            Iterator<DataSource> bucketConfig = config.elevationBucket;
            File cacheDirectory = new File(dataSources.getCacheDirectory(), "ned");
            DegreeGridNEDTileSource awsTileSource = new DegreeGridNEDTileSource();
            awsTileSource.awsAccessKey = ((S3BucketConfig)((Object)bucketConfig)).accessKey;
            awsTileSource.awsSecretKey = ((S3BucketConfig)((Object)bucketConfig)).secretKey;
            awsTileSource.awsBucketName = ((S3BucketConfig)((Object)bucketConfig)).bucketName;
            elevationGridCoverageFactories.add(new NEDGridCoverageFactoryImpl(cacheDirectory, awsTileSource));
        } else if (dataSources.has(FileType.DEM)) {
            for (DataSource demSource : dataSources.get(FileType.DEM)) {
                elevationGridCoverageFactories.add(new GeotiffGridCoverageFactoryImpl(demSource));
            }
        }
        for (ElevationGridCoverageFactory factory : elevationGridCoverageFactories) {
            graphBuilder.addModule(new ElevationModule(factory, new File(dataSources.getCacheDirectory(), "cached_elevations.obj"), config.readCachedElevations, config.writeCachedElevations, config.elevationUnitMultiplier, config.distanceBetweenElevationSamples, config.includeEllipsoidToGeoidDifference, config.multiThreadElevationCalculations));
        }
        if (hasTransitData) {
            if (OTPFeature.FlexRouting.isOn()) {
                graphBuilder.addModule(new FlexLocationsToStreetEdgesMapper());
            }
            graphBuilder.addModule(new DirectTransferGenerator(config.maxTransferDurationSeconds, config.transferRequests));
            if (OTPFeature.TransferAnalyzer.isOn()) {
                graphBuilder.addModule(new DirectTransferAnalyzer(config.maxTransferDurationSeconds * new RoutingRequest().walkSpeed));
            }
        }
        if (config.dataImportReport) {
            graphBuilder.addModule(new DataImportIssuesToHTML(dataSources.getBuildReportDir(), config.maxDataImportIssuesPerFile));
        }
        if (OTPFeature.DataOverlay.isOn() && (module = DataOverlayFactory.create(config.dataOverlay)) != null) {
            graphBuilder.addModule(module);
        }
        return graphBuilder;
    }
}

