/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehiclerentalservicedirectory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.ext.vehiclerentalservicedirectory.GbfsDataSourceParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.VehicleRentalParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.GraphUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdater;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSourceFactory;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalServiceDirectoryFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalServiceDirectoryFetcher.class);
    private static final int DEFAULT_FREQUENCY_SEC = 15;

    public static List<GraphUpdater> createUpdatersFromEndpoint(VehicleRentalServiceDirectoryFetcherParameters parameters) {
        LOG.info("Fetching list of updaters from {}", (Object)parameters.getUrl());
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        try {
            InputStream is = HttpUtils.getData(parameters.getUrl());
            JsonNode node = new ObjectMapper().readTree(is);
            JsonNode sources = node.get(parameters.getSourcesName());
            if (sources == null) {
                LOG.warn("Error reading json from {}. Are json tag names configured properly?", (Object)parameters.getUrl());
                return updaters;
            }
            for (JsonNode source : sources) {
                JsonNode network = source.get(parameters.getSourceNetworkName());
                JsonNode updaterUrl = source.get(parameters.getSourceUrlName());
                if (network == null || updaterUrl == null) {
                    LOG.warn("Error reading json from {}. Are json tag names configured properly?", (Object)parameters.getUrl());
                    return updaters;
                }
                VehicleRentalParameters vehicleRentalParameters = new VehicleRentalParameters("vehicle-rental-service-directory:" + network, 15, new GbfsDataSourceParameters(updaterUrl.asText(), parameters.getLanguage(), parameters.getHeaders()));
                LOG.info("Fetched updater info for {} at url {}", (Object)network, (Object)updaterUrl);
                DataSource<VehicleRentalPlace> dataSource = VehicleRentalDataSourceFactory.create(vehicleRentalParameters.sourceParameters());
                VehicleRentalUpdater updater = new VehicleRentalUpdater(vehicleRentalParameters, dataSource);
                updaters.add(updater);
            }
        }
        catch (IOException e) {
            LOG.warn("Error fetching list of vehicle rental endpoints from {}", (Object)parameters.getUrl(), (Object)e);
        }
        LOG.info("{} updaters fetched", (Object)updaters.size());
        return updaters;
    }
}

