/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.parkapi;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.ext.vehicleparking.parkapi.ParkAPIUpdaterParameters;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingState;
import org.opentripplanner.updater.GenericJsonDataSource;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;
import org.opentripplanner.util.TranslatedString;

abstract class ParkAPIUpdater
extends GenericJsonDataSource<VehicleParking> {
    private static final String JSON_PARSE_PATH = "lots";
    private final String feedId;
    private final Collection<String> staticTags;

    public ParkAPIUpdater(ParkAPIUpdaterParameters parameters) {
        super(parameters.getUrl(), JSON_PARSE_PATH, parameters.getHttpHeaders());
        this.feedId = parameters.getFeedId();
        this.staticTags = parameters.getTags();
    }

    @Override
    protected VehicleParking parseElement(JsonNode jsonNode) {
        VehicleParkingSpaces capacity = this.parseCapacity(jsonNode);
        VehicleParkingSpaces availability = this.parseAvailability(jsonNode);
        I18NString note = null;
        if (jsonNode.has("notes") && !jsonNode.get("notes").isEmpty()) {
            Iterator noteFieldIterator = jsonNode.path("notes").fields();
            HashMap<String, String> noteLocalizations = new HashMap<String, String>();
            while (noteFieldIterator.hasNext()) {
                Map.Entry noteFiled = (Map.Entry)noteFieldIterator.next();
                noteLocalizations.put((String)noteFiled.getKey(), ((JsonNode)noteFiled.getValue()).asText());
            }
            note = TranslatedString.getI18NString(noteLocalizations);
        }
        FeedScopedId vehicleParkId = this.createIdForNode(jsonNode);
        double x = jsonNode.path("coords").path("lng").asDouble();
        double y = jsonNode.path("coords").path("lat").asDouble();
        VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(this.feedId, vehicleParkId.getId() + "/entrance")).name(new NonLocalizedString(jsonNode.path("name").asText())).x(x).y(y).walkAccessible(true).carAccessible(true);
        String stateText = jsonNode.get("state").asText();
        VehicleParkingState state = stateText.equals("closed") ? VehicleParkingState.CLOSED : VehicleParkingState.OPERATIONAL;
        List<String> tags = this.parseTags(jsonNode, "lot_type", "address", "forecast", "state");
        tags.addAll(this.staticTags);
        Optional<VehicleParkingSpaces> maybeCapacity = Optional.ofNullable(capacity);
        Boolean bicyclePlaces = maybeCapacity.map(c -> this.hasPlaces(capacity.getBicycleSpaces())).orElse(false);
        Boolean carPlaces = maybeCapacity.map(c -> this.hasPlaces(capacity.getCarSpaces())).orElse(true);
        Boolean wheelChairAccessiblePlaces = maybeCapacity.map(c -> this.hasPlaces(capacity.getWheelchairAccessibleCarSpaces())).orElse(false);
        return VehicleParking.builder().id(vehicleParkId).name(new NonLocalizedString(jsonNode.path("name").asText())).state(state).x(x).y(y).detailsUrl(jsonNode.has("url") ? jsonNode.get("url").asText() : null).imageUrl(jsonNode.has("image_url") ? jsonNode.get("image_url").asText() : null).note(note).capacity(capacity).availability(availability).bicyclePlaces(bicyclePlaces).carPlaces(carPlaces).wheelchairAccessibleCarPlaces(wheelChairAccessiblePlaces).entrance(entrance).tags(tags).build();
    }

    abstract VehicleParkingSpaces parseCapacity(JsonNode var1);

    abstract VehicleParkingSpaces parseAvailability(JsonNode var1);

    protected VehicleParkingSpaces parseVehicleSpaces(JsonNode node, String bicycleTag, String carTag, String wheelchairAccessibleCarTag) {
        Integer bicycleSpaces = this.parseSpacesValue(node, bicycleTag);
        Integer carSpaces = this.parseSpacesValue(node, carTag);
        Integer wheelchairAccessibleCarSpaces = this.parseSpacesValue(node, wheelchairAccessibleCarTag);
        if (bicycleSpaces == null && carSpaces == null && wheelchairAccessibleCarSpaces == null) {
            return null;
        }
        return this.createVehiclePlaces(carSpaces, wheelchairAccessibleCarSpaces, bicycleSpaces);
    }

    private VehicleParkingSpaces createVehiclePlaces(Integer carSpaces, Integer wheelchairAccessibleCarSpaces, Integer bicycleSpaces) {
        return VehicleParkingSpaces.builder().bicycleSpaces(bicycleSpaces).carSpaces(carSpaces).wheelchairAccessibleCarSpaces(wheelchairAccessibleCarSpaces).build();
    }

    private boolean hasPlaces(Integer spaces) {
        return spaces != null && spaces > 0;
    }

    private Integer parseSpacesValue(JsonNode jsonNode, String fieldName) {
        if (!jsonNode.has(fieldName)) {
            return null;
        }
        return jsonNode.get(fieldName).asInt();
    }

    private FeedScopedId createIdForNode(JsonNode jsonNode) {
        String id = jsonNode.has("id") ? jsonNode.path("id").asText() : String.format("%s/%f/%f", jsonNode.get("name"), jsonNode.path("coords").path("lng").asDouble(), jsonNode.path("coords").path("lat").asDouble());
        return new FeedScopedId(this.feedId, id);
    }

    private List<String> parseTags(JsonNode node, String ... tagNames) {
        ArrayList<String> tagList = new ArrayList<String>();
        for (String tagName : tagNames) {
            if (!node.has(tagName)) continue;
            tagList.add(tagName + ":" + node.get(tagName).asText());
        }
        return tagList;
    }
}

