/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.hslpark;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkPatch;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkToVehicleParkingMapper;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUtilizationToPatchMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.util.xml.JsonDataListDownloader;

public class HslParkUpdater
implements DataSource<VehicleParking> {
    private static final String JSON_PARSE_PATH = "results";
    private final JsonDataListDownloader facilitiesDownloader;
    private final int facilitiesFrequencySec;
    private final JsonDataListDownloader utilizationsDownloader;
    private final HslParkToVehicleParkingMapper vehicleParkingMapper;
    private final HslParkUtilizationToPatchMapper parkPatchMapper;
    private long lastFacilitiesFetchTime;
    private List<VehicleParking> parks;

    public HslParkUpdater(HslParkUpdaterParameters parameters) {
        String feedId = parameters.getFeedId();
        this.vehicleParkingMapper = new HslParkToVehicleParkingMapper(feedId);
        this.parkPatchMapper = new HslParkUtilizationToPatchMapper(feedId);
        this.facilitiesDownloader = new JsonDataListDownloader<VehicleParking>(parameters.getFacilitiesUrl(), JSON_PARSE_PATH, this.vehicleParkingMapper::parsePark, null);
        this.utilizationsDownloader = new JsonDataListDownloader<HslParkPatch>(parameters.getUtilizationsUrl(), "", this.parkPatchMapper::parseUtilization, null);
        this.facilitiesFrequencySec = parameters.getFacilitiesFrequencySec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        List<VehicleParking> parks;
        if (this.fetchFacilitiesNow()) {
            parks = this.facilitiesDownloader.download();
            if (parks != null) {
                this.lastFacilitiesFetchTime = System.currentTimeMillis();
            }
        } else {
            parks = this.parks;
        }
        if (parks != null) {
            List utilizations = this.utilizationsDownloader.download();
            if (utilizations != null) {
                Map<FeedScopedId, List<HslParkPatch>> patches = utilizations.stream().collect(Collectors.groupingBy(utilization -> utilization.getId()));
                parks.forEach(park -> {
                    List patchesForPark = (List)patches.get(park.getId());
                    if (patchesForPark != null) {
                        park.updateAvailability(HslParkUpdater.createVehicleAvailability(patchesForPark));
                    }
                });
            } else if (this.parks != null) {
                return false;
            }
            HslParkUpdater hslParkUpdater = this;
            synchronized (hslParkUpdater) {
                this.parks = parks;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<VehicleParking> getUpdates() {
        return this.parks;
    }

    private boolean fetchFacilitiesNow() {
        if (this.parks == null) {
            return true;
        }
        if (this.facilitiesFrequencySec <= 0) {
            return false;
        }
        return System.currentTimeMillis() > this.lastFacilitiesFetchTime + (long)(this.facilitiesFrequencySec * 1000);
    }

    private static VehicleParkingSpaces createVehicleAvailability(List<HslParkPatch> patches) {
        VehicleParkingSpaces.VehicleParkingSpacesBuilder availabilityBuilder = VehicleParkingSpaces.builder();
        boolean hasHandledSpaces = false;
        block10: for (int i = 0; i < patches.size(); ++i) {
            HslParkPatch patch = patches.get(i);
            String type = patch.getCapacityType();
            if (type == null) continue;
            Integer spaces = patch.getSpacesAvailable();
            switch (type) {
                case "CAR": {
                    availabilityBuilder.carSpaces(spaces);
                    hasHandledSpaces = true;
                    continue block10;
                }
                case "BICYCLE": {
                    availabilityBuilder.bicycleSpaces(spaces);
                    hasHandledSpaces = true;
                    continue block10;
                }
                case "DISABLED": {
                    availabilityBuilder.wheelchairAccessibleCarSpaces(spaces);
                    hasHandledSpaces = true;
                }
            }
        }
        return hasHandledSpaces ? availabilityBuilder.build() : null;
    }
}

