/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehicleparkings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.TranslatedString;

public class DigitransitVehicleParkingPropertyMapper
extends PropertyMapper<VehicleParking> {
    public static DigitransitVehicleParkingPropertyMapper create(Graph graph) {
        return new DigitransitVehicleParkingPropertyMapper();
    }

    @Override
    protected Collection<T2<String, Object>> map(VehicleParking vehicleParking) {
        ArrayList<T2<String, Object>> items = new ArrayList<T2<String, Object>>();
        items.addAll(List.of(new T2<String, String>("id", vehicleParking.getId().toString()), new T2<String, Boolean>("realTimeData", vehicleParking.getAvailability() != null), new T2<String, String>("detailsUrl", vehicleParking.getDetailsUrl()), new T2<String, String>("imageUrl", vehicleParking.getImageUrl()), new T2<String, String>("tags", String.join((CharSequence)",", vehicleParking.getTags())), new T2<String, String>("state", vehicleParking.getState().name()), new T2<String, Boolean>("bicyclePlaces", vehicleParking.hasBicyclePlaces()), new T2<String, Boolean>("anyCarPlaces", vehicleParking.hasAnyCarPlaces()), new T2<String, Boolean>("carPlaces", vehicleParking.hasCarPlaces()), new T2<String, Boolean>("wheelchairAccessibleCarPlaces", vehicleParking.hasWheelchairAccessibleCarPlaces()), new T2<String, Boolean>("realTimeData", vehicleParking.hasRealTimeData())));
        items.addAll(DigitransitVehicleParkingPropertyMapper.mapI18NString("name", vehicleParking.getName()));
        items.addAll(DigitransitVehicleParkingPropertyMapper.mapI18NString("note", vehicleParking.getNote()));
        items.addAll(DigitransitVehicleParkingPropertyMapper.mapPlaces("capacity", vehicleParking.getCapacity()));
        items.addAll(DigitransitVehicleParkingPropertyMapper.mapPlaces("availability", vehicleParking.getAvailability()));
        items.addAll(DigitransitVehicleParkingPropertyMapper.mapPlaces("availability", vehicleParking.getAvailability()));
        return items;
    }

    private static List<T2<String, Object>> mapI18NString(String key, Object object) {
        if (object instanceof I18NString) {
            return DigitransitVehicleParkingPropertyMapper.mapI18NString(key, (I18NString)object);
        }
        return List.of();
    }

    private static List<T2<String, Object>> mapI18NString(String key, I18NString i18n) {
        if (i18n == null) {
            return List.of();
        }
        ArrayList<T2<String, Object>> items = new ArrayList<T2<String, Object>>();
        items.add(new T2<String, String>(key, i18n.toString()));
        if (i18n instanceof TranslatedString) {
            ((TranslatedString)i18n).getTranslations().forEach(e -> {
                if (e.getKey() != null) {
                    items.add(new T2(DigitransitVehicleParkingPropertyMapper.subKey(key, (String)e.getKey()), e.getValue()));
                }
            });
        }
        return items;
    }

    private static List<T2<String, Object>> mapPlaces(String key, VehicleParkingSpaces places) {
        if (places == null) {
            return List.of();
        }
        JSONObject json = new JSONObject();
        json.put((Object)"bicyclePlaces", (Object)places.getBicycleSpaces());
        json.put((Object)"carPlaces", (Object)places.getCarSpaces());
        json.put((Object)"wheelchairAccessibleCarPlaces", (Object)places.getWheelchairAccessibleCarSpaces());
        return List.of(new T2<String, String>(key, JSONObject.toJSONString((Map)json)), new T2<String, Integer>(DigitransitVehicleParkingPropertyMapper.subKey(key, "bicyclePlaces"), places.getBicycleSpaces()), new T2<String, Integer>(DigitransitVehicleParkingPropertyMapper.subKey(key, "carPlaces"), places.getCarSpaces()), new T2<String, Integer>(DigitransitVehicleParkingPropertyMapper.subKey(key, "wheelchairAccessibleCarPlaces"), places.getWheelchairAccessibleCarSpaces()));
    }

    private static String subKey(String key, String subkey) {
        return String.format("%s.%s", key, subkey);
    }
}

