/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stops;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public class DigitransitStopPropertyMapper
extends PropertyMapper<TransitStopVertex> {
    private final Graph graph;

    public static DigitransitStopPropertyMapper create(Graph graph) {
        return new DigitransitStopPropertyMapper(graph);
    }

    private DigitransitStopPropertyMapper(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Collection<T2<String, Object>> map(TransitStopVertex input) {
        Stop stop = input.getStop();
        Collection<TripPattern> patternsForStop = this.graph.index.getPatternsForStop(stop);
        String type = patternsForStop.stream().map(TripPattern::getMode).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::name).orElse(null);
        String patterns = JSONArray.toJSONString(patternsForStop.stream().map((? super T tripPattern) -> {
            int stopPos = tripPattern.findStopPosition(stop);
            String headsign = stopPos < 0 ? "Not Available" : tripPattern.getScheduledTimetable().getTripTimes().get(0).getHeadsign(stopPos);
            JSONObject pattern = new JSONObject();
            pattern.put((Object)"headsign", (Object)headsign);
            pattern.put((Object)"type", (Object)tripPattern.getRoute().getMode().name());
            pattern.put((Object)"shortName", (Object)tripPattern.getRoute().getShortName());
            return pattern;
        }).collect(Collectors.toList()));
        return List.of(new T2<String, String>("gtfsId", stop.getId().toString()), new T2<String, String>("name", stop.getName()), new T2<String, String>("code", stop.getCode()), new T2<String, String>("platform", stop.getPlatformCode()), new T2<String, String>("desc", stop.getDescription()), new T2<String, String>("parentStation", (String)(stop.getParentStation() != null ? stop.getParentStation().getId() : "null")), new T2<String, String>("type", type), new T2<String, String>("patterns", patterns));
    }
}

