/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stations;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.ext.vectortiles.LayerBuilder;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.ext.vectortiles.layers.stations.DigitransitStationPropertyMapper;
import org.opentripplanner.model.Station;
import org.opentripplanner.routing.graph.Graph;

public class StationsLayerBuilder
extends LayerBuilder<Station> {
    static Map<MapperType, Function<Graph, PropertyMapper<Station>>> mappers = Map.of(MapperType.Digitransit, DigitransitStationPropertyMapper::create);
    private final Graph graph;

    public StationsLayerBuilder(Graph graph, VectorTilesResource.LayerParameters layerParameters) {
        super(layerParameters.name(), mappers.get((Object)MapperType.valueOf(layerParameters.mapper())).apply(graph));
        this.graph = graph;
    }

    @Override
    protected List<Geometry> getGeometries(Envelope query) {
        return this.graph.getStations().stream().map(station -> {
            Coordinate coordinate = station.getCoordinate().asJtsCoordinate();
            Point point = GeometryUtils.getGeometryFactory().createPoint(coordinate);
            point.setUserData(station);
            return point;
        }).collect(Collectors.toList());
    }

    static enum MapperType {
        Digitransit;

    }
}

