/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.stations;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.vectortiles.PropertyMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.routing.graph.Graph;

public class DigitransitStationPropertyMapper
extends PropertyMapper<Station> {
    private final Graph graph;

    private DigitransitStationPropertyMapper(Graph graph) {
        this.graph = graph;
    }

    public static DigitransitStationPropertyMapper create(Graph graph) {
        return new DigitransitStationPropertyMapper(graph);
    }

    @Override
    public Collection<T2<String, Object>> map(Station station) {
        Collection<StopLocation> childStops = station.getChildStops();
        return List.of(new T2<String, String>("gtfsId", station.getId().toString()), new T2<String, String>("name", station.getName()), new T2<String, String>("type", childStops.stream().flatMap(stop -> this.graph.index.getPatternsForStop((StopLocation)stop).stream()).map((? super T tripPattern) -> tripPattern.getMode().name()).distinct().collect(Collectors.joining(","))), new T2<String, String>("stops", JSONArray.toJSONString(childStops.stream().map(StopLocation::getId).map(FeedScopedId::toString).collect(Collectors.toUnmodifiableList()))), new T2<String, String>("routes", JSONArray.toJSONString(childStops.stream().flatMap(stop -> this.graph.index.getRoutesForStop((StopLocation)stop).stream()).distinct().map((? super T route) -> route.getShortName() == null ? Map.of("mode", route.getMode().name()) : Map.of("mode", route.getMode().name(), "shortName", route.getShortName())).collect(Collectors.toList()))));
    }
}

