/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.geotools.geometry.Envelope2D;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.common.geometry.WebMercatorTile;
import org.opentripplanner.ext.vectortiles.LayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.stations.StationsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.stops.StopsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalLayerBuilder;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;

@Path(value="/routers/{ignoreRouterId}/vectorTiles")
public class VectorTilesResource {
    static Map<LayerType, BiFunction<Graph, LayerParameters, LayerBuilder>> layers = new HashMap<LayerType, BiFunction<Graph, LayerParameters, LayerBuilder>>();
    @Context
    private OTPServer otpServer;
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    @GET
    @Path(value="/{layers}/{z}/{x}/{y}.pbf")
    @Produces(value={"application/x-protobuf"})
    public Response tileGet(@PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layers") String requestedLayers) throws Exception {
        VectorTile.Tile.Builder mvtBuilder = VectorTile.Tile.newBuilder();
        if (z < 9) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)mvtBuilder.build().toByteArray()).build();
        }
        Envelope2D env = WebMercatorTile.tile2Envelope(x, y, z);
        Envelope envelope = new Envelope(env.getMaxX(), env.getMinX(), env.getMaxY(), env.getMinY());
        List<String> layers = Arrays.asList(requestedLayers.split(","));
        Router router = this.otpServer.getRouter();
        int cacheMaxSeconds = Integer.MAX_VALUE;
        for (LayerParameters layerParameters : router.routerConfig.vectorTileLayers().layers()) {
            if (!layers.contains(layerParameters.name()) || layerParameters.minZoom() > z || z > layerParameters.maxZoom()) continue;
            cacheMaxSeconds = Math.min(cacheMaxSeconds, layerParameters.cacheMaxSeconds());
            mvtBuilder.addLayers(VectorTilesResource.layers.get((Object)LayerType.valueOf(layerParameters.type())).apply(router.graph, layerParameters).build(envelope, layerParameters));
        }
        CacheControl cacheControl = new CacheControl();
        if (cacheMaxSeconds != Integer.MAX_VALUE) {
            cacheControl.setMaxAge(cacheMaxSeconds);
        }
        byte[] bytes = mvtBuilder.build().toByteArray();
        return Response.status((Response.Status)Response.Status.OK).cacheControl(cacheControl).entity((Object)bytes).build();
    }

    @GET
    @Path(value="/{layers}/tilejson.json")
    @Produces(value={"application/json"})
    public TileJson getTileJson(@Context UriInfo uri, @Context HttpHeaders headers, @PathParam(value="layers") String requestedLayers) {
        return new TileJson(this, this.otpServer.getRouter().graph, uri, headers, requestedLayers);
    }

    private String getBaseAddress(UriInfo uri, HttpHeaders headers, String layers) {
        String protocol = headers.getRequestHeader("X-Forwarded-Proto") != null ? (String)headers.getRequestHeader("X-Forwarded-Proto").get(0) : uri.getRequestUri().getScheme();
        Object host = headers.getRequestHeader("X-Forwarded-Host") != null ? (String)headers.getRequestHeader("X-Forwarded-Host").get(0) : (headers.getRequestHeader("Host") != null ? (String)headers.getRequestHeader("Host").get(0) : uri.getBaseUri().getHost() + ":" + uri.getBaseUri().getPort());
        return protocol + "://" + (String)host;
    }

    static {
        layers.put(LayerType.Stop, StopsLayerBuilder::new);
        layers.put(LayerType.Station, StationsLayerBuilder::new);
        layers.put(LayerType.VehicleRental, VehicleRentalLayerBuilder::new);
        layers.put(LayerType.VehicleParking, VehicleParkingsLayerBuilder::new);
    }

    public static interface LayerParameters {
        public String name();

        public String type();

        public String mapper();

        public int maxZoom();

        public int minZoom();

        public int cacheMaxSeconds();

        public double expansionFactor();
    }

    public static interface LayersParameters {
        public List<LayerParameters> layers();
    }

    private class TileJson
    implements Serializable {
        public final String tilejson = "2.2.0";
        public final String name = "OpenTripPlanner";
        public final String attribution;
        public final String scheme = "xyz";
        public final String[] tiles;
        public final int minzoom = 9;
        public final int maxzoom = 20;
        public final double[] bounds;
        public final double[] center;
        final /* synthetic */ VectorTilesResource this$0;

        /*
         * Exception decompiling
         */
        private TileJson(VectorTilesResource var1_1, Graph graph, UriInfo uri, HttpHeaders headers, String layers) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static enum LayerType {
        Stop,
        Station,
        VehicleRental,
        VehicleParking;

    }
}

