/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;

public class DataFetcherDecorator {
    private final DataFetchingEnvironment environment;

    public DataFetcherDecorator(DataFetchingEnvironment e) {
        this.environment = e;
    }

    public <T> void argument(String name, Consumer<T> consumer) {
        DataFetcherDecorator.call(this.environment, name, consumer);
    }

    public <T> void argument(String name, Consumer<T> consumer, Runnable alternativeAction) {
        if (GqlUtil.hasArgument(this.environment, name)) {
            this.argument(name, consumer);
        } else {
            alternativeAction.run();
        }
    }

    private static <T> void call(Map<String, T> m, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (DataFetcherDecorator.hasArgument(m, name)) {
                T v = m.get(name);
                consumer.accept(v);
            }
        } else {
            String[] parts = name.split("\\.");
            if (DataFetcherDecorator.hasArgument(m, parts[0])) {
                Map nm = (Map)m.get(parts[0]);
                DataFetcherDecorator.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    private static <T> void call(DataFetchingEnvironment environment, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (GqlUtil.hasArgument(environment, name)) {
                consumer.accept(environment.getArgument(name));
            }
        } else {
            String[] parts = name.split("\\.");
            if (GqlUtil.hasArgument(environment, parts[0])) {
                Map nm = (Map)environment.getArgument(parts[0]);
                DataFetcherDecorator.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    public static <T> boolean hasArgument(Map<String, T> m, String name) {
        return m.containsKey(name) && m.get(name) != null;
    }
}

