/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import com.google.common.collect.Lists;
import graphql.AssertException;
import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.util.PolylineEncoder;

public class ServiceJourneyType {
    private static final String NAME = "ServiceJourney";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("ServiceJourney");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType linkGeometryType, GraphQLOutputType operatorType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLOutputType lineType, GraphQLOutputType ptSituationElementType, GraphQLOutputType journeyPatternType, GraphQLOutputType estimatedCallType, GraphQLOutputType timetabledPassingTimeType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("A planned vehicle journey with passengers.").field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)lineType)).dataFetcher(environment -> ServiceJourneyType.trip(environment).getRoute()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("activeDates").withDirective(gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)gqlUtil.dateScalar))).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getCalendarService().getServiceDatesForServiceId(ServiceJourneyType.trip(environment).getServiceId()).stream().map(gqlUtil.serviceDateMapper::serviceDateToSecondsSinceEpoch).sorted().collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportMode").type((GraphQLOutputType)EnumTypes.TRANSPORT_MODE).dataFetcher(environment -> ServiceJourneyType.trip(environment).getMode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").type((GraphQLOutputType)EnumTypes.TRANSPORT_SUBMODE).dataFetcher(environment -> {
            String netexSubmode = ServiceJourneyType.trip(environment).getNetexSubmode();
            return netexSubmode != null ? TransmodelTransportSubmode.fromValue(netexSubmode) : null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("publicCode").type((GraphQLOutputType)Scalars.GraphQLString).description("Publicly announced code for service journey, differentiating it from other service journeys for the same line.").dataFetcher(environment -> ServiceJourneyType.trip(environment).getTripShortName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("privateCode").type((GraphQLOutputType)Scalars.GraphQLString).description("For internal use by operators.").dataFetcher(environment -> ServiceJourneyType.trip(environment).getInternalPlanningCode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").type(operatorType).dataFetcher(environment -> ServiceJourneyType.trip(environment).getOperator()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directionType").type((GraphQLOutputType)EnumTypes.DIRECTION_TYPE).dataFetcher(environment -> ServiceJourneyType.trip(environment).getDirection()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceAlteration").deprecate("The service journey alteration will be moved out of SJ and grouped together with the SJ and date. In Netex this new type is called DatedServiceJourney. We will create artificial DSJs for the old SJs.").type((GraphQLOutputType)EnumTypes.SERVICE_ALTERATION).dataFetcher(environment -> ServiceJourneyType.trip(environment).getTripAlteration()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("wheelchairAccessible").type((GraphQLOutputType)EnumTypes.WHEELCHAIR_BOARDING).description("Whether service journey is accessible with wheelchair.").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikesAllowed").type((GraphQLOutputType)EnumTypes.BIKES_ALLOWED).description("Whether bikes are allowed on service journey.").build()).field(GraphQLFieldDefinition.newFieldDefinition().name("journeyPattern").type(journeyPatternType).dataFetcher(env -> GqlUtil.getRoutingService(env).getPatternForTrip().get(ServiceJourneyType.trip(env))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Quays visited by service journey").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).argument(GraphQLArgument.newArgument().name("first").description("Only fetch the first n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("last").description("Only fetch the last n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).dataFetcher(environment -> {
            Integer first = (Integer)environment.getArgument("first");
            Integer last = (Integer)environment.getArgument("last");
            List stops = GqlUtil.getRoutingService(environment).getPatternForTrip().get(ServiceJourneyType.trip(environment)).getStops();
            if (first != null && last != null) {
                throw new AssertException("Both first and last can't be defined simultaneously.");
            }
            if (first != null) {
                stops = stops.stream().limit(first.intValue()).collect(Collectors.toList());
            } else if (last != null) {
                List reversedStops = Lists.reverse(stops).stream().limit(last.intValue()).collect(Collectors.toList());
                stops = Lists.reverse(reversedStops);
            }
            return stops;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("passingTimes").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)timetabledPassingTimeType))).withDirective(gqlUtil.timingData).description("Returns scheduled passing times only - without realtime-updates, for realtime-data use 'estimatedCalls'").dataFetcher(env -> {
            Trip trip = ServiceJourneyType.trip(env);
            return TripTimeOnDate.fromTripTimes(GqlUtil.getRoutingService(env).getPatternForTrip().get(trip).getScheduledTimetable(), trip);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("estimatedCalls").type((GraphQLOutputType)new GraphQLList((GraphQLType)estimatedCallType)).withDirective(gqlUtil.timingData).description("Returns scheduled passingTimes for this ServiceJourney for a given date, updated with realtime-updates (if available). NB! This takes a date as argument (default=today) and returns estimatedCalls for that date and should only be used if the date is known when creating the request. For fetching estimatedCalls for a given trip.leg, use leg.serviceJourneyEstimatedCalls instead.").argument(GraphQLArgument.newArgument().name("date").type((GraphQLInputType)gqlUtil.dateScalar).description("Date to get estimated calls for. Defaults to today.").build()).dataFetcher(environment -> {
            Trip trip = ServiceJourneyType.trip(environment);
            ServiceDate serviceDate = gqlUtil.serviceDateMapper.secondsSinceEpochToServiceDate((Long)environment.getArgument("date"));
            return GqlUtil.getRoutingService(environment).getTripTimesShort(trip, serviceDate);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pointsOnLink").type(linkGeometryType).description("Detailed path travelled by service journey. Not available for flexible trips.").dataFetcher(environment -> {
            TripPattern tripPattern = GqlUtil.getRoutingService(environment).getPatternForTrip().get(ServiceJourneyType.trip(environment));
            if (tripPattern == null) {
                return null;
            }
            LineString geometry = tripPattern.getGeometry();
            if (geometry == null) {
                return null;
            }
            return PolylineEncoder.createEncodings((Geometry)geometry);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)noticeType))).dataFetcher(env -> GqlUtil.getRoutingService(env).getNoticesByEntity(ServiceJourneyType.trip(env))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all situations active for the service journey.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)ptSituationElementType))).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getTransitAlertService().getTripAlerts(ServiceJourneyType.trip(environment).getId(), null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").description("Booking arrangements for flexible services.").type(bookingArrangementType).deprecate("BookingArrangements are defined per stop, and can be found under `passingTimes` or `estimatedCalls`").build()).build();
    }

    private static Trip trip(DataFetchingEnvironment environment) {
        return (Trip)environment.getSource();
    }
}

