/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.function.Function;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPoint;

public class InterchangeType {
    public static GraphQLObjectType create(GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType) {
        return GraphQLObjectType.newObject().name("Interchange").field(GraphQLFieldDefinition.newFieldDefinition().name("staySeated").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> InterchangeType.constraint(env).isStaySeated()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("guaranteed").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> InterchangeType.constraint(env).isGuaranteed()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("priority").description("The transfer priority is used to decide where a transfer should happen, at the highest prioritized location. If the guarantied flag is set it take precedence priority. A guarantied ALLOWED transfer is preferred over a PREFERRED none-guarantied transfer.").type((GraphQLOutputType)EnumTypes.INTERCHANGE_PRIORITY).dataFetcher(env -> InterchangeType.constraint(env).getPriority()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("maximumWaitTime").description("Maximum time after scheduled departure time the connecting transport is guarantied to wait for the delayed trip. [NOT RESPECTED DURING ROUTING, JUST PASSED THROUGH]").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> InterchangeType.constraint(env).getMaxWaitTime()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("FromLine").deprecate("This is the same as using the `fromServiceJourney { line }` field.").type(lineType).dataFetcher(env -> InterchangeType.transferRoute(env, ConstrainedTransfer::getFrom)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ToLine").deprecate("This is the same as using the `toServiceJourney { line }` field.").type(lineType).dataFetcher(env -> InterchangeType.transferRoute(env, ConstrainedTransfer::getTo)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromServiceJourney").type(serviceJourneyType).dataFetcher(env -> InterchangeType.transferTrip(env, ConstrainedTransfer::getFrom)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toServiceJourney").type(serviceJourneyType).dataFetcher(env -> InterchangeType.transferTrip(env, ConstrainedTransfer::getTo)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("FromServiceJourney").type(serviceJourneyType).deprecate("Use fromServiceJourney instead").dataFetcher(env -> InterchangeType.transferTrip(env, ConstrainedTransfer::getFrom)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ToServiceJourney").type(serviceJourneyType).deprecate("Use toServiceJourney instead").dataFetcher(env -> InterchangeType.transferTrip(env, ConstrainedTransfer::getTo)).build()).build();
    }

    private static ConstrainedTransfer transfer(DataFetchingEnvironment environment) {
        return (ConstrainedTransfer)environment.getSource();
    }

    private static TransferPoint transferPoint(DataFetchingEnvironment environment, Function<ConstrainedTransfer, TransferPoint> fromTo) {
        return fromTo.apply(InterchangeType.transfer(environment));
    }

    private static Trip transferTrip(DataFetchingEnvironment environment, Function<ConstrainedTransfer, TransferPoint> fromTo) {
        return TransferPoint.getTrip(InterchangeType.transferPoint(environment, fromTo));
    }

    private static Route transferRoute(DataFetchingEnvironment environment, Function<ConstrainedTransfer, TransferPoint> fromTo) {
        return TransferPoint.getRoute(InterchangeType.transferPoint(environment, fromTo));
    }

    private static TransferConstraint constraint(DataFetchingEnvironment environment) {
        return InterchangeType.transfer(environment).getTransferConstraint();
    }
}

