/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.stop;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.model.plan.JourneyWhiteListed;
import org.opentripplanner.ext.transmodelapi.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopCollection;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;

public class StopPlaceType {
    public static final String NAME = "StopPlace";
    public static final GraphQLOutputType REF = new GraphQLTypeReference("StopPlace");

    public static GraphQLObjectType create(GraphQLInterfaceType placeInterface, GraphQLOutputType quayType, GraphQLOutputType tariffZoneType, GraphQLOutputType estimatedCallType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("Named place where public transport may be accessed. May be a building complex (e.g. a station) or an on-street location.").withInterface(placeInterface).field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latitude").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getLat()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("longitude").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getLon()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getDescription()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("weighting").description("Relative weighting of this stop with regards to interchanges. NOT IMPLEMENTED").type((GraphQLOutputType)EnumTypes.INTERCHANGE_WEIGHTING).dataFetcher(environment -> 0).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tariffZones").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)tariffZoneType))).description("NOT IMPLEMENTED").dataFetcher(environment -> List.of()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportMode").description("The transport modes of quays under this stop place.").type((GraphQLOutputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_MODE)).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getChildStops().stream().map(StopLocation::getVehicleType).filter(Objects::nonNull).collect(Collectors.toSet())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").description("The transport submode serviced by this stop place.").type((GraphQLOutputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_SUBMODE)).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getChildStops().stream().map(StopLocation::getVehicleSubmode).filter(Objects::nonNull).map(TransmodelTransportSubmode::fromValue).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").withDirective(gqlUtil.timingData).description("Returns all quays that are children of this stop place").type((GraphQLOutputType)new GraphQLList((GraphQLType)quayType)).argument(GraphQLArgument.newArgument().name("filterByInUse").description("If true only quays with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).dataFetcher(environment -> {
            Collection quays = ((MonoOrMultiModalStation)environment.getSource()).getChildStops();
            if (Boolean.TRUE.equals(environment.getArgument("filterByInUse"))) {
                quays = quays.stream().filter(stop -> !GqlUtil.getRoutingService(environment).getPatternsForStop((StopLocation)stop, true).isEmpty()).collect(Collectors.toList());
            }
            return quays;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("parent").description("Returns parent stop for this stop").type((GraphQLOutputType)new GraphQLTypeReference(NAME)).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getParentStation()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tariffZones").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)tariffZoneType))).dataFetcher(environment -> ((MonoOrMultiModalStation)environment.getSource()).getChildStops().stream().flatMap(s -> s.getFareZones().stream()).collect(Collectors.toSet())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("estimatedCalls").withDirective(gqlUtil.timingData).description("List of visits to this stop place as part of vehicle journeys.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).argument(GraphQLArgument.newArgument().name("startTime").type((GraphQLInputType)gqlUtil.dateTimeScalar).description("DateTime for when to fetch estimated calls from. Default value is current time").build()).argument(GraphQLArgument.newArgument().name("timeRange").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)86400).build()).argument(GraphQLArgument.newArgument().name("numberOfDepartures").description("Limit the total number of departures returned.").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)5).build()).argument(GraphQLArgument.newArgument().name("numberOfDeparturesPerLineAndDestinationDisplay").description("Limit the number of departures per line and destination display returned. The parameter is only applied when the value is between 1 and 'numberOfDepartures'.").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("arrivalDeparture").type((GraphQLInputType)EnumTypes.ARRIVAL_DEPARTURE).defaultValue((Object)ArrivalDeparture.DEPARTURES).build()).argument(GraphQLArgument.newArgument().name("whiteListed").description("Whitelisted").description("Parameters for indicating the only authorities and/or lines or quays to list estimatedCalls for").type((GraphQLInputType)JourneyWhiteListed.INPUT_TYPE).build()).argument(GraphQLArgument.newArgument().name("whiteListedModes").description("Only show estimated calls for selected modes.").type((GraphQLInputType)GraphQLList.list((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("includeCancelledTrips").description("Indicates that realtime-cancelled trips should also be included. NOT IMPLEMENTED").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).build()).dataFetcher(environment -> {
            ArrivalDeparture arrivalDeparture = (ArrivalDeparture)((Object)((Object)environment.getArgument("arrivalDeparture")));
            boolean includeCancelledTrips = (Boolean)environment.getArgument("includeCancelledTrips");
            int numberOfDepartures = (Integer)environment.getArgument("numberOfDepartures");
            Integer departuresPerLineAndDestinationDisplay = (Integer)environment.getArgument("numberOfDeparturesPerLineAndDestinationDisplay");
            int timeRage = (Integer)environment.getArgument("timeRange");
            MonoOrMultiModalStation monoOrMultiModalStation = (MonoOrMultiModalStation)environment.getSource();
            JourneyWhiteListed whiteListed = new JourneyWhiteListed(environment);
            Collection transitModes = (Collection)environment.getArgument("whiteListedModes");
            Long startTimeMs = environment.getArgument("startTime") == null ? Long.valueOf(0L) : (Long)environment.getArgument("startTime");
            Long startTimeSeconds = startTimeMs / 1000L;
            return monoOrMultiModalStation.getChildStops().stream().flatMap(singleStop -> StopPlaceType.getTripTimesForStop(singleStop, startTimeSeconds, timeRage, arrivalDeparture, includeCancelledTrips, numberOfDepartures, departuresPerLineAndDestinationDisplay, whiteListed.authorityIds, whiteListed.lineIds, transitModes, environment)).sorted(TripTimeOnDate.compareByDeparture()).distinct().limit(numberOfDepartures).collect(Collectors.toList());
        }).build()).build();
    }

    public static Stream<TripTimeOnDate> getTripTimesForStop(StopLocation stop, Long startTimeSeconds, int timeRage, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips, int numberOfDepartures, Integer departuresPerLineAndDestinationDisplay, Collection<FeedScopedId> authorityIdsWhiteListed, Collection<FeedScopedId> lineIdsWhiteListed, Collection<TransitMode> transitModes, DataFetchingEnvironment environment) {
        RoutingService routingService = GqlUtil.getRoutingService(environment);
        boolean limitOnDestinationDisplay = departuresPerLineAndDestinationDisplay != null && departuresPerLineAndDestinationDisplay > 0 && departuresPerLineAndDestinationDisplay < numberOfDepartures;
        int departuresPerTripPattern = limitOnDestinationDisplay ? departuresPerLineAndDestinationDisplay : numberOfDepartures;
        List<StopTimesInPattern> stopTimesInPatterns = routingService.stopTimesForStop(stop, startTimeSeconds, timeRage, departuresPerTripPattern, arrivalDeparture, includeCancelledTrips);
        Stream<Object> stopTimesStream = stopTimesInPatterns.stream();
        if (transitModes != null && !transitModes.isEmpty()) {
            stopTimesStream = stopTimesStream.filter(it -> transitModes.contains((Object)it.pattern.getMode()));
        }
        Stream<TripTimeOnDate> tripTimesStream = stopTimesStream.flatMap(p -> p.times.stream());
        tripTimesStream = JourneyWhiteListed.whiteListAuthoritiesAndOrLines(tripTimesStream, authorityIdsWhiteListed, lineIdsWhiteListed);
        if (!limitOnDestinationDisplay) {
            return tripTimesStream;
        }
        return tripTimesStream.collect(Collectors.groupingBy(t -> StopPlaceType.destinationDisplayPerLine(t))).values().stream().flatMap(tripTimes -> tripTimes.stream().sorted(TripTimeOnDate.compareByDeparture()).distinct().limit(departuresPerLineAndDestinationDisplay.intValue()));
    }

    public static MonoOrMultiModalStation fetchStopPlaceById(FeedScopedId id, DataFetchingEnvironment environment) {
        RoutingService routingService = GqlUtil.getRoutingService(environment);
        Station station = routingService.getStationById(id);
        if (station != null) {
            return new MonoOrMultiModalStation(station, routingService.getMultiModalStationForStations().get(station));
        }
        MultiModalStation multiModalStation = routingService.getMultiModalStation(id);
        if (multiModalStation != null) {
            return new MonoOrMultiModalStation(multiModalStation);
        }
        return null;
    }

    public static Collection<MonoOrMultiModalStation> fetchStopPlaces(double minLat, double minLon, double maxLat, double maxLon, String authority, Boolean filterByInUse, String multiModalMode, DataFetchingEnvironment environment) {
        RoutingService routingService = GqlUtil.getRoutingService(environment);
        Stream<Station> stations = routingService.getStopsByBoundingBox(minLat, minLon, maxLat, maxLon).stream().map(StopLocation::getParentStation).filter(Objects::nonNull).distinct();
        if (authority != null) {
            stations = stations.filter(s -> s.getId().getFeedId().equalsIgnoreCase(authority));
        }
        if (Boolean.TRUE.equals(filterByInUse)) {
            stations = stations.filter(s -> StopPlaceType.isStopPlaceInUse(s, routingService));
        }
        if ("child".equals(multiModalMode)) {
            return stations.map(s -> {
                MultiModalStation parent = routingService.getMultiModalStationForStations().get(s);
                return new MonoOrMultiModalStation((Station)s, parent);
            }).collect(Collectors.toList());
        }
        if ("all".equals(multiModalMode)) {
            HashSet<MonoOrMultiModalStation> result = new HashSet<MonoOrMultiModalStation>();
            stations.forEach(it -> {
                MultiModalStation p = routingService.getMultiModalStationForStations().get(it);
                result.add(new MonoOrMultiModalStation((Station)it, p));
                if (p != null) {
                    result.add(new MonoOrMultiModalStation(p));
                }
            });
            return result;
        }
        if ("parent".equals(multiModalMode)) {
            HashSet<MonoOrMultiModalStation> result = new HashSet<MonoOrMultiModalStation>();
            stations.forEach(it -> {
                MultiModalStation p = routingService.getMultiModalStationForStations().get(it);
                if (p != null) {
                    result.add(new MonoOrMultiModalStation(p));
                } else {
                    result.add(new MonoOrMultiModalStation((Station)it, null));
                }
            });
            return result;
        }
        throw new IllegalArgumentException("Unexpected multiModalMode: " + multiModalMode);
    }

    public static boolean isStopPlaceInUse(StopCollection station, RoutingService routingService) {
        for (StopLocation quay : station.getChildStops()) {
            if (routingService.getPatternsForStop(quay, true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String destinationDisplayPerLine(TripTimeOnDate t) {
        Trip trip = t.getTrip();
        return trip == null ? t.getHeadsign() : trip.getRoute().getId() + "|" + t.getHeadsign();
    }
}

