/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.stop;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.transmodelapi.model.TransmodelPlaceType;
import org.opentripplanner.ext.transmodelapi.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;

public class PlaceAtDistanceType {
    public static final String NAME = "PlaceAtDistance";

    public static GraphQLObjectType create(Relay relay, GraphQLInterfaceType placeInterface) {
        return GraphQLObjectType.newObject().name(NAME).field(GraphQLFieldDefinition.newFieldDefinition().name("id").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).deprecate("Id is not referable or meaningful and will be removed").dataFetcher(environment -> relay.toGlobalId(NAME, "N/A")).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("place").type((GraphQLOutputType)placeInterface).dataFetcher(environment -> ((PlaceAtDistance)environment.getSource()).place).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("distance").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((PlaceAtDistance)environment.getSource()).distance).build()).build();
    }

    public static List<PlaceAtDistance> convertQuaysToStopPlaces(List<TransmodelPlaceType> placeTypes, List<PlaceAtDistance> places, String multiModalMode, RoutingService routingService) {
        if (placeTypes == null || placeTypes.contains((Object)TransmodelPlaceType.STOP_PLACE)) {
            List stations = places.stream().filter(p -> p.place instanceof Stop).flatMap(p -> PlaceAtDistanceType.getStopPlaces(p, multiModalMode, routingService)).sorted(Comparator.comparing(p -> p.distance)).filter(new SeenPlacePredicate()).collect(Collectors.toList());
            places.addAll(stations);
            if (placeTypes != null && !placeTypes.contains((Object)TransmodelPlaceType.QUAY)) {
                places = places.stream().filter(p -> !(p.place instanceof Stop)).collect(Collectors.toList());
            }
        }
        places.sort(Comparator.comparing(p -> p.distance));
        HashSet uniquePlaces = new HashSet();
        return places.stream().filter(s -> uniquePlaces.add(s.place)).collect(Collectors.toList());
    }

    private static Stream<PlaceAtDistance> getStopPlaces(PlaceAtDistance p, String multiModalMode, RoutingService routingService) {
        Station stopPlace = ((Stop)p.place).getParentStation();
        if (stopPlace == null) {
            return Stream.of(new PlaceAtDistance[0]);
        }
        ArrayList<PlaceAtDistance> res = new ArrayList<PlaceAtDistance>();
        MultiModalStation multiModalStation = routingService.getMultiModalStationForStations().get(stopPlace);
        if ("child".equals(multiModalMode) || "all".equals(multiModalMode) || multiModalStation == null) {
            res.add(new PlaceAtDistance(new MonoOrMultiModalStation(stopPlace, multiModalStation), p.distance));
        }
        if (multiModalStation == null) {
            return res.stream();
        }
        if ("parent".equals(multiModalMode) || "all".equals(multiModalMode)) {
            res.add(new PlaceAtDistance(new MonoOrMultiModalStation(multiModalStation), p.distance));
        }
        return res.stream();
    }

    static class SeenPlacePredicate
    implements Predicate<PlaceAtDistance> {
        Set<Object> seen = new HashSet<Object>();

        SeenPlacePredicate() {
        }

        @Override
        public boolean test(PlaceAtDistance p) {
            return this.seen.add(p.place);
        }
    }
}

