/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.stop;

import java.util.Collection;
import java.util.TimeZone;
import org.opentripplanner.model.MultiModalStation;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;

public class MonoOrMultiModalStation
extends TransitEntity {
    private final String name;
    private final double lat;
    private final double lon;
    private final String code;
    private final String description;
    private final String url;
    private final TimeZone timezone;
    private final Collection<StopLocation> childStops;
    private final MonoOrMultiModalStation parentStation;

    public MonoOrMultiModalStation(Station station, MultiModalStation parentStation) {
        super(station.getId());
        this.name = station.getName();
        this.lat = station.getLat();
        this.lon = station.getLon();
        this.code = station.getCode();
        this.description = station.getDescription();
        this.url = station.getUrl();
        this.timezone = station.getTimezone();
        this.childStops = station.getChildStops();
        this.parentStation = parentStation != null ? new MonoOrMultiModalStation(parentStation) : null;
    }

    public MonoOrMultiModalStation(MultiModalStation multiModalStation) {
        super(multiModalStation.getId());
        this.name = multiModalStation.getName();
        this.lat = multiModalStation.getLat();
        this.lon = multiModalStation.getLon();
        this.code = multiModalStation.getCode();
        this.description = multiModalStation.getDescription();
        this.url = multiModalStation.getUrl();
        this.timezone = null;
        this.childStops = multiModalStation.getChildStops();
        this.parentStation = null;
    }

    public String getName() {
        return this.name;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public Collection<StopLocation> getChildStops() {
        return this.childStops;
    }

    public MonoOrMultiModalStation getParentStation() {
        return this.parentStation;
    }

    @Override
    public String toString() {
        return "<MonoOrMultiModalStation " + this.getId() + ">";
    }
}

