/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.siri.sx;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opentripplanner.ext.transmodelapi.mapping.SeverityMapper;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.util.TranslatedString;

public class PtSituationElementType {
    private static final String NAME = "PtSituationElement";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("PtSituationElement");

    public static GraphQLObjectType create(GraphQLOutputType authorityType, GraphQLOutputType quayType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType multilingualStringType, GraphQLObjectType validityPeriodType, GraphQLObjectType infoLinkType, Relay relay) {
        return GraphQLObjectType.newObject().name(NAME).description("Simple public transport situation element").field(GraphQLFieldDefinition.newFieldDefinition().name("id").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).dataFetcher(environment -> relay.toGlobalId(NAME, ((TransitAlert)environment.getSource()).getId())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").type(authorityType).description("Get affected authority for this situation element").dataFetcher(environment -> GqlUtil.getRoutingService(environment).getAgencyForId(((TransitAlert)environment.getSource()).getEntities().stream().filter(EntitySelector.Agency.class::isInstance).map(EntitySelector.Agency.class::cast).findAny().map(entitySelector -> entitySelector.agencyId).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).dataFetcher(environment -> {
            RoutingService routingService = GqlUtil.getRoutingService(environment);
            return ((TransitAlert)environment.getSource()).getEntities().stream().filter(EntitySelector.Route.class::isInstance).map(EntitySelector.Route.class::cast).map(entitySelector -> entitySelector.routeId).map(routeId -> routingService.getRouteForId((FeedScopedId)routeId)).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)serviceJourneyType))).dataFetcher(environment -> {
            RoutingService routingService = GqlUtil.getRoutingService(environment);
            return ((TransitAlert)environment.getSource()).getEntities().stream().filter(EntitySelector.Trip.class::isInstance).map(EntitySelector.Trip.class::cast).map(entitySelector -> entitySelector.tripId).map(tripId -> routingService.getTripForId().get(tripId)).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).dataFetcher(environment -> {
            RoutingService routingService = GqlUtil.getRoutingService(environment);
            return ((TransitAlert)environment.getSource()).getEntities().stream().filter(EntitySelector.Stop.class::isInstance).map(EntitySelector.Stop.class::cast).map(entitySelector -> entitySelector.stopId).map(stopId -> routingService.getStopForId((FeedScopedId)stopId)).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("summary").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Summary of situation in all different translations available").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            if (alert.alertHeaderText instanceof TranslatedString) {
                return ((TranslatedString)alert.alertHeaderText).getTranslations();
            }
            if (alert.alertHeaderText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, alert.alertHeaderText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Description of situation in all different translations available").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            if (alert.alertDescriptionText instanceof TranslatedString) {
                return ((TranslatedString)alert.alertDescriptionText).getTranslations();
            }
            if (alert.alertDescriptionText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, alert.alertDescriptionText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("advice").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)multilingualStringType)))).description("Advice of situation in all different translations available").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            if (alert.alertAdviceText instanceof TranslatedString) {
                return ((TranslatedString)alert.alertAdviceText).getTranslations();
            }
            if (alert.alertAdviceText != null) {
                return List.of(new AbstractMap.SimpleEntry<Object, String>(null, alert.alertAdviceText.toString()));
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("infoLinks").type((GraphQLOutputType)new GraphQLList((GraphQLType)infoLinkType)).description("Optional links to more information.").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            if (!alert.getAlertUrlList().isEmpty()) {
                return alert.getAlertUrlList();
            }
            return null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("validityPeriod").type((GraphQLOutputType)validityPeriodType).description("Period this situation is in effect").dataFetcher(environment -> {
            TransitAlert alert = (TransitAlert)environment.getSource();
            Long startTime = alert.getEffectiveStartDate() != null ? Long.valueOf(alert.getEffectiveStartDate().getTime()) : null;
            Long endTime = alert.getEffectiveEndDate() != null ? Long.valueOf(alert.getEffectiveEndDate().getTime()) : null;
            return Pair.of((Object)startTime, (Object)endTime);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("reportType").type((GraphQLOutputType)EnumTypes.REPORT_TYPE).description("ReportType of this situation").dataFetcher(environment -> ((TransitAlert)environment.getSource()).alertType).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situationNumber").type((GraphQLOutputType)Scalars.GraphQLString).description("Operator's internal id for this situation").dataFetcher(environment -> ((TransitAlert)environment.getSource()).getId()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("severity").type((GraphQLOutputType)EnumTypes.SEVERITY).description("Severity of this situation ").dataFetcher(environment -> SeverityMapper.getTransmodelSeverity(((TransitAlert)environment.getSource()).severity)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("priority").type((GraphQLOutputType)Scalars.GraphQLInt).description("Priority of this situation ").dataFetcher(environment -> ((TransitAlert)environment.getSource()).priority).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("reportAuthority").type(authorityType).description("Authority that reported this situation").deprecate("Not yet officially supported. May be removed or renamed.").dataFetcher(environment -> GqlUtil.getRoutingService(environment).getAgencyForId(((TransitAlert)environment.getSource()).getEntities().stream().filter(EntitySelector.Agency.class::isInstance).map(EntitySelector.Agency.class::cast).findAny().map(entitySelector -> entitySelector.agencyId).orElse(null))).build()).build();
    }
}

