/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.scalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;

public class DateScalarFactory {
    private static final String DOCUMENTATION = "Local date using the ISO 8601 format: `YYYY-MM-DD`. Example: `2020-05-17`.";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;

    private DateScalarFactory() {
    }

    public static GraphQLScalarType createSecondsSinceEpochAsDateStringScalar(final TimeZone timeZone) {
        return GraphQLScalarType.newScalar().name("Date").description(DOCUMENTATION).coercing((Coercing)new Coercing<Object, Object>(){

            public String serialize(Object input) {
                if (input instanceof Long) {
                    return Instant.ofEpochSecond((Long)input).atZone(timeZone.toZoneId()).toLocalDateTime().plusHours(1L).toLocalDate().format(FORMATTER);
                }
                return null;
            }

            public Long parseValue(Object input) {
                try {
                    return LocalDate.from(FORMATTER.parse((CharSequence)input)).atStartOfDay(timeZone.toZoneId()).toEpochSecond();
                }
                catch (DateTimeParseException dtpe) {
                    throw new CoercingParseValueException("Expected type 'Date' but was '" + input + "'.");
                }
            }

            public Long parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    return this.parseValue(((StringValue)input).getValue());
                }
                return null;
            }
        }).build();
    }
}

