/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.plan;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.stream.Collectors;
import org.opentripplanner.api.mapping.PlannerErrorMapper;
import org.opentripplanner.ext.transmodelapi.model.PlanResponse;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.util.ResourceBundleSingleton;

public class TripType {
    public static GraphQLObjectType create(GraphQLObjectType placeType, GraphQLObjectType tripPatternType, GraphQLObjectType tripMetadataType, GraphQLObjectType routingErrorType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name("Trip").description("Description of a travel between two places.").field(GraphQLFieldDefinition.newFieldDefinition().name("dateTime").description("The time and date of travel").type((GraphQLOutputType)gqlUtil.dateTimeScalar).dataFetcher(env -> ((PlanResponse)env.getSource()).plan.date.getTime()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("metadata").description("The trip request metadata.").type((GraphQLOutputType)tripMetadataType).dataFetcher(env -> ((PlanResponse)env.getSource()).metadata).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromPlace").description("The origin").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> ((PlanResponse)env.getSource()).plan.from).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toPlace").description("The destination").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> ((PlanResponse)env.getSource()).plan.to).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tripPatterns").description("A list of possible trip patterns").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)tripPatternType)))).dataFetcher(env -> ((PlanResponse)env.getSource()).plan.itineraries).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("messageEnums").description("A list of possible error messages as enum").deprecate("Use routingErrors instead").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).dataFetcher(env -> ((PlanResponse)env.getSource()).messages.stream().map(routingError -> PlannerErrorMapper.mapMessage((RoutingError)routingError).message).map(Enum::name).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("messageStrings").deprecate("Use routingErrors instead").description("A list of possible error messages in cleartext").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).dataFetcher(env -> ((PlanResponse)env.getSource()).messages.stream().map(routingError -> PlannerErrorMapper.mapMessage((RoutingError)routingError).message).map(message -> message.get(ResourceBundleSingleton.INSTANCE.getLocale((String)env.getArgument("locale")))).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("routingErrors").description("A list of routing errors, and fields which caused them").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)routingErrorType)))).dataFetcher(env -> ((PlanResponse)env.getSource()).messages).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("debugOutput").description("Information about the timings for the trip generation").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)GraphQLObjectType.newObject().name("debugOutput").field(GraphQLFieldDefinition.newFieldDefinition().name("totalTime").type((GraphQLOutputType)ExtendedScalars.GraphQLLong).build()).build())).dataFetcher(env -> ((PlanResponse)env.getSource()).debugOutput).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("previousPageCursor").description("Use the cursor to get the previous page of results. Use this cursor for the pageCursor parameter in the trip query in order to get the previous page.\nThe previous page is a set of itineraries departing BEFORE the first itinerary in this result.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(env -> {
            PageCursor pageCursor = ((PlanResponse)env.getSource()).previousPageCursor;
            return pageCursor != null ? pageCursor.encode() : null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("nextPageCursor").description("Use the cursor to get the next page of results. Use this cursor for the pageCursor parameter in the trip query in order to get the next page.\nThe next page is a set of itineraries departing AFTER the last itinerary in this result.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(env -> {
            PageCursor pageCursor = ((PlanResponse)env.getSource()).nextPageCursor;
            return pageCursor != null ? pageCursor.encode() : null;
        }).build()).build();
    }
}

