/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.plan;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.model.TripTimeShortHelper;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.util.PolylineEncoder;

public class LegType {
    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType interchangeType, GraphQLOutputType linkGeometryType, GraphQLOutputType authorityType, GraphQLOutputType operatorType, GraphQLOutputType quayType, GraphQLOutputType estimatedCallType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType ptSituationElementType, GraphQLObjectType placeType, GraphQLObjectType pathGuidanceType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name("Leg").description("Part of a trip pattern. Either a ride on a public transport vehicle or access or path link to/from/between places").field(GraphQLFieldDefinition.newFieldDefinition().name("aimedStartTime").description("The aimed date and time this leg starts.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(env -> LegType.leg(env).getStartTime().getTimeInMillis() - 1000L * (long)LegType.leg(env).getDepartureDelay()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedStartTime").description("The expected, realtime adjusted date and time this leg starts.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(env -> LegType.leg(env).getStartTime().getTimeInMillis()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("aimedEndTime").description("The aimed date and time this leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(env -> LegType.leg(env).getEndTime().getTimeInMillis() - 1000L * (long)LegType.leg(env).getArrivalDelay()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedEndTime").description("The expected, realtime adjusted date and time this leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(env -> LegType.leg(env).getEndTime().getTimeInMillis()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("mode").description("The mode of transport or access (e.g., foot) used when traversing this leg.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)EnumTypes.MODE)).dataFetcher(env -> LegType.leg(env).getMode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").description("The transport sub mode (e.g., localBus or expressBus) used when traversing this leg. Null if leg is not a ride").type((GraphQLOutputType)EnumTypes.TRANSPORT_SUBMODE).dataFetcher(environment -> ((Leg)environment.getSource()).getTrip() != null && ((Leg)environment.getSource()).getTrip().getNetexSubmode() != null ? TransmodelTransportSubmode.fromValue(((Leg)environment.getSource()).getTrip().getNetexSubmode()) : null).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("duration").description("The legs's duration in seconds").type((GraphQLOutputType)ExtendedScalars.GraphQLLong).dataFetcher(env -> LegType.leg(env).getDuration()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directDuration").type((GraphQLOutputType)ExtendedScalars.GraphQLLong).description("NOT IMPLEMENTED").dataFetcher(env -> LegType.leg(env).getDuration()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pointsOnLink").description("The leg's geometry.").type(linkGeometryType).dataFetcher(env -> PolylineEncoder.createEncodings((Geometry)LegType.leg(env).getLegGeometry())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").description("For ride legs, the service authority used for this legs. For non-ride legs, null.").type(authorityType).dataFetcher(env -> LegType.leg(env).getAgency()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").description("For ride legs, the operator used for this legs. For non-ride legs, null.").type(operatorType).dataFetcher(env -> LegType.leg(env).getOperator()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("realtime").description("Whether there is real-time data about this leg").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).dataFetcher(env -> LegType.leg(env).getRealTime()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("distance").description("The distance traveled while traversing the leg in meters.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> LegType.leg(env).getDistanceMeters()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("generalizedCost").description("Generalized cost or weight of the leg. Used for debugging.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> LegType.leg(env).getGeneralizedCost()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ride").description("Whether this leg is a ride leg or not.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).dataFetcher(env -> LegType.leg(env).isTransitLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("walkingBike").description("Whether this leg is walking with a bike.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> LegType.leg(env).getWalkingBike()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("rentedBike").description("Whether this leg is with a rented bike.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> LegType.leg(env).getRentedVehicle()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromPlace").description("The Place where the leg originates.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> LegType.leg(env).getFrom()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toPlace").description("The Place where the leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> LegType.leg(env).getTo()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromEstimatedCall").withDirective(gqlUtil.timingData).description("EstimatedCall for the quay where the leg originates.").type(estimatedCallType).dataFetcher(env -> TripTimeShortHelper.getTripTimeShortForFromPlace((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toEstimatedCall").withDirective(gqlUtil.timingData).description("EstimatedCall for the quay where the leg ends.").type(estimatedCallType).dataFetcher(env -> TripTimeShortHelper.getTripTimeShortForToPlace((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").description("For ride legs, the line. For non-ride legs, null.").type(lineType).dataFetcher(env -> LegType.leg(env).getRoute()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").description("For ride legs, the service journey. For non-ride legs, null.").type(serviceJourneyType).dataFetcher(env -> LegType.leg(env).getTrip()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("intermediateQuays").description("For ride legs, intermediate quays between the Place where the leg originates and the Place where the leg ends. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).dataFetcher(env -> {
            List<StopArrival> stops = ((Leg)env.getSource()).getIntermediateStops();
            if (stops == null || stops.isEmpty()) {
                return List.of();
            }
            return stops.stream().map(stop -> stop.place.stop).filter(Objects::nonNull).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("intermediateEstimatedCalls").withDirective(gqlUtil.timingData).description("For ride legs, estimated calls for quays between the Place where the leg originates and the Place where the leg ends. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).dataFetcher(env -> TripTimeShortHelper.getIntermediateTripTimeShortsForLeg((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneyEstimatedCalls").withDirective(gqlUtil.timingData).description("For ride legs, all estimated calls for the service journey. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).dataFetcher(env -> TripTimeShortHelper.getAllTripTimeShortsForLegsTrip((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("All relevant situations for this leg").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(env -> LegType.leg(env).getTransitAlerts()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("steps").description("Do we continue from a specified via place").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)pathGuidanceType))).dataFetcher(env -> LegType.leg(env).getWalkSteps()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("interchangeFrom").type(interchangeType).dataFetcher(env -> LegType.leg(env).getTransferFromPrevLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("interchangeTo").type(interchangeType).dataFetcher(env -> LegType.leg(env).getTransferToNextLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").type(bookingArrangementType).dataFetcher(env -> LegType.leg(env).getPickupBookingInfo()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalNetworks").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).dataFetcher(env -> LegType.leg(env).getVehicleRentalNetwork() == null ? List.of() : List.of(LegType.leg(env).getVehicleRentalNetwork())).build()).build();
    }

    private static Leg leg(DataFetchingEnvironment environment) {
        return (Leg)environment.getSource();
    }
}

