/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.network;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.util.OTPFeature;

public class LineType {
    private static final String NAME = "Line";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("Line");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType authorityType, GraphQLOutputType operatorType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLObjectType presentationType, GraphQLOutputType journeyPatternType, GraphQLOutputType serviceJourneyType, GraphQLOutputType ptSituationElementType, GraphQLOutputType brandingType) {
        return GraphQLObjectType.newObject().name(NAME).description("A group of routes which is generally known to the public by a similar name or number").field(GraphQLFieldDefinition.newFieldDefinition().name("id").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).dataFetcher(environment -> TransitIdMapper.mapEntityIDToApi((TransitEntity)environment.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").type(authorityType).dataFetcher(environment -> ((Route)environment.getSource()).getAgency()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").type(operatorType).dataFetcher(environment -> ((Route)environment.getSource()).getOperator()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("branding").type(brandingType).dataFetcher(environment -> ((Route)environment.getSource()).getBranding())).field(GraphQLFieldDefinition.newFieldDefinition().name("publicCode").type((GraphQLOutputType)Scalars.GraphQLString).description("Publicly announced code for line, differentiating it from other lines for the same operator.").dataFetcher(environment -> ((Route)environment.getSource()).getShortName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((Route)environment.getSource()).getLongName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportMode").type((GraphQLOutputType)EnumTypes.TRANSPORT_MODE).dataFetcher(environment -> ((Route)environment.getSource()).getMode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").type((GraphQLOutputType)EnumTypes.TRANSPORT_SUBMODE).dataFetcher(environment -> {
            String netexSubMode = ((Route)environment.getSource()).getNetexSubmode();
            return netexSubMode != null ? TransmodelTransportSubmode.fromValue(netexSubMode) : null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((Route)environment.getSource()).getDesc()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("url").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("presentation").type((GraphQLOutputType)presentationType).dataFetcher(DataFetchingEnvironment::getSource).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikesAllowed").type((GraphQLOutputType)EnumTypes.BIKES_ALLOWED).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("journeyPatterns").type((GraphQLOutputType)new GraphQLList((GraphQLType)journeyPatternType)).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getPatternsForRoute().get((Object)((Route)environment.getSource()))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getPatternsForRoute().get((Object)((Route)environment.getSource())).stream().map(TripPattern::getStops).flatMap(Collection::stream).distinct().collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)serviceJourneyType))).dataFetcher(environment -> {
            List result = GqlUtil.getRoutingService(environment).getPatternsForRoute().get((Object)((Route)environment.getSource())).stream().flatMap(TripPattern::scheduledTripsAsStream).distinct().collect(Collectors.toList());
            if (OTPFeature.FlexRouting.isOn()) {
                result.addAll(GqlUtil.getRoutingService((DataFetchingEnvironment)environment).getFlexIndex().tripById.values().stream().map(FlexTrip::getTrip).filter(t -> t.getRoute().equals((Route)environment.getSource())).collect(Collectors.toList()));
            }
            return result;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)noticeType))).dataFetcher(environment -> {
            Route route = (Route)environment.getSource();
            return GqlUtil.getRoutingService(environment).getNoticesByEntity(route);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all situations active for the line.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)ptSituationElementType))).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getTransitAlertService().getRouteAlerts(((Route)environment.getSource()).getId())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("flexibleLineType").description("Type of flexible line, or null if line is not flexible.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((Route)environment.getSource()).getFlexibleLineType()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").description("Booking arrangements for flexible line.").type(bookingArrangementType).deprecate("BookingArrangements are defined per stop, and can be found under `passingTimes` or `estimatedCalls`").dataFetcher(environment -> null).build()).build();
    }
}

