/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.network;

import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.BitSet;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.util.PolylineEncoder;

public class JourneyPatternType {
    private static final String NAME = "JourneyPattern";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("JourneyPattern");

    public static GraphQLObjectType create(GraphQLOutputType linkGeometryType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLNamedOutputType ptSituationElementType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)lineType)).dataFetcher(environment -> ((TripPattern)environment.getSource()).getRoute()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directionType").type((GraphQLOutputType)EnumTypes.DIRECTION_TYPE).dataFetcher(environment -> ((TripPattern)environment.getSource()).getDirection()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((TripPattern)environment.getSource()).getName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").withDirective(gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)serviceJourneyType)))).dataFetcher(e -> ((TripPattern)e.getSource()).scheduledTripsAsStream().collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneysForDate").withDirective(gqlUtil.timingData).description("List of service journeys for the journey pattern for a given date").argument(GraphQLArgument.newArgument().name("date").type((GraphQLInputType)gqlUtil.dateScalar).build()).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)serviceJourneyType)))).dataFetcher(environment -> {
            BitSet services = GqlUtil.getRoutingService(environment).getServicesRunningForDate(gqlUtil.serviceDateMapper.secondsSinceEpochToServiceDate((Long)environment.getArgument("date")));
            return ((TripPattern)environment.getSource()).getScheduledTimetable().getTripTimes().stream().filter(times -> services.get(times.getServiceCode())).map(times -> times.getTrip()).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Quays visited by service journeys for this journey patterns").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).dataFetcher(environment -> ((TripPattern)environment.getSource()).getStops()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pointsOnLink").type(linkGeometryType).dataFetcher(environment -> {
            LineString geometry = ((TripPattern)environment.getSource()).getGeometry();
            if (geometry == null) {
                return null;
            }
            return PolylineEncoder.createEncodings((Geometry)geometry);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all situations active for the journey pattern.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)ptSituationElementType))).dataFetcher(environment -> {
            TripPattern tripPattern = (TripPattern)environment.getSource();
            return GqlUtil.getRoutingService(environment).getTransitAlertService().getDirectionAndRouteAlerts(tripPattern.getDirection().gtfsCode, tripPattern.getRoute().getId());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)noticeType))).dataFetcher(environment -> {
            TripPattern tripPattern = (TripPattern)environment.getSource();
            return GqlUtil.getRoutingService(environment).getNoticesByEntity(tripPattern);
        }).build()).build();
    }
}

