/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model;

import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.routing.trippattern.TripTimes;

public class TripTimeShortHelper {
    private TripTimeShortHelper() {
    }

    @Nullable
    public static TripTimeOnDate getTripTimeShortForFromPlace(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return null;
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        return new TripTimeOnDate(transitLeg.getTripTimes(), (int)transitLeg.getBoardStopPosInPattern(), transitLeg.getTripPattern(), transitLeg.getServiceDateMidnight());
    }

    @Nullable
    public static TripTimeOnDate getTripTimeShortForToPlace(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return null;
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        return new TripTimeOnDate(transitLeg.getTripTimes(), (int)transitLeg.getAlightStopPosInPattern(), transitLeg.getTripPattern(), transitLeg.getServiceDateMidnight());
    }

    public static List<TripTimeOnDate> getAllTripTimeShortsForLegsTrip(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return List.of();
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        TripTimes tripTimes = transitLeg.getTripTimes();
        TripPattern tripPattern = transitLeg.getTripPattern();
        Instant serviceDateMidnight = transitLeg.getServiceDateMidnight();
        return IntStream.range(0, tripPattern.numberOfStops()).mapToObj(i -> new TripTimeOnDate(tripTimes, i, tripPattern, serviceDateMidnight)).collect(Collectors.toList());
    }

    public static List<TripTimeOnDate> getIntermediateTripTimeShortsForLeg(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return List.of();
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        TripTimes tripTimes = transitLeg.getTripTimes();
        TripPattern tripPattern = transitLeg.getTripPattern();
        Instant serviceDateMidnight = transitLeg.getServiceDateMidnight();
        return IntStream.range(leg.getBoardStopPosInPattern() + 1, leg.getAlightStopPosInPattern()).mapToObj(i -> new TripTimeOnDate(tripTimes, i, tripPattern, serviceDateMidnight)).collect(Collectors.toList());
    }
}

