/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.model.TransitMode;

public class TransportModeSlack {
    private static final String BOARD_SLACK_DESCRIPTION = "The boardSlack is the minimum extra time to board a public transport vehicle. This is the same as the 'minimumTransferTime', except that this also apply to to the first transit leg in the trip.";
    private static final String ALIGHT_SLACK_DESCRIPTION = "The alightSlack is the minimum extra time after exiting a public transport vehicle.";
    private static final GraphQLNonNull INT_TYPE = GraphQLNonNull.nonNull((GraphQLType)Scalars.GraphQLInt);
    private static final GraphQLNonNull MODE_LIST_TYPE = GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)EnumTypes.TRANSPORT_MODE)));
    private static final GraphQLInputObjectType SLACK_INPUT_TYPE = GraphQLInputObjectType.newInputObject().name("TransportModeSlack").description("Used to specify board and alight slack for a given modes.").field(GraphQLInputObjectField.newInputObjectField().name("slack").description("The slack used for all given modes.").type((GraphQLInputType)INT_TYPE).build()).field(GraphQLInputObjectField.newInputObjectField().name("modes").description("List of modes for which the given slack apply.").type((GraphQLInputType)MODE_LIST_TYPE).build()).build();
    private static final GraphQLOutputType SLACK_OUTPUT_TYPE = GraphQLObjectType.newObject().name("TransportModeSlackType").description("Used to specify board and alight slack for a given modes.").field(GraphQLFieldDefinition.newFieldDefinition().name("slack").type((GraphQLOutputType)INT_TYPE).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("modes").type((GraphQLOutputType)MODE_LIST_TYPE).build()).build();
    public static final GraphQLList SLACK_LIST_INPUT_TYPE = GraphQLList.list((GraphQLType)SLACK_INPUT_TYPE);
    public static final GraphQLList SLACK_LIST_OUTPUT_TYPE = GraphQLList.list((GraphQLType)SLACK_OUTPUT_TYPE);
    public final int slack;
    public final List<TransitMode> modes;

    private TransportModeSlack(int slack, List<TransitMode> modes) {
        this.slack = slack;
        this.modes = modes;
    }

    private static String defaultDescription(String groupName) {
        return String.format("This is the default value used, if not overridden by the '%s'.", groupName);
    }

    public static String boardSlackDescription(String byGroupName) {
        return BOARD_SLACK_DESCRIPTION + " " + TransportModeSlack.defaultDescription(byGroupName);
    }

    public static String alightSlackDescription(String byGroupName) {
        return ALIGHT_SLACK_DESCRIPTION + " " + TransportModeSlack.defaultDescription(byGroupName);
    }

    public static String slackByGroupDescription(String name) {
        return String.format("List of %s for a given set of modes.", name);
    }

    public static String slackByGroupDescription(String name, Map<TransitMode, Integer> defaultValues) {
        return TransportModeSlack.slackByGroupDescription(name) + " " + TransportModeSlack.defaultsToString(defaultValues);
    }

    public String toString() {
        if (this.modes == null) {
            return "{slack: " + this.slack + "}";
        }
        return "{" + this.modes.stream().map(TransportModeSlack::serializeTransportMode).collect(Collectors.toList()) + " : " + this.slack + "}";
    }

    public static List<TransportModeSlack> mapToApiList(Map<TransitMode, Integer> domain) {
        ArrayListMultimap modesBySlack = ArrayListMultimap.create();
        domain.forEach((arg_0, arg_1) -> TransportModeSlack.lambda$mapToApiList$0((Multimap)modesBySlack, arg_0, arg_1));
        ArrayList<TransportModeSlack> result = new ArrayList<TransportModeSlack>();
        modesBySlack.asMap().forEach((k, v) -> result.add(new TransportModeSlack((int)k, List.copyOf(v))));
        result.sort(Comparator.comparingInt(a -> a.slack));
        return result;
    }

    public static EnumMap<TransitMode, Integer> mapToDomain(Object value) {
        EnumMap<TransitMode, Integer> result = new EnumMap<TransitMode, Integer>(TransitMode.class);
        if (value instanceof List) {
            List list = (List)value;
            for (Map map : list) {
                int slack = (Integer)map.get("slack");
                ((List)map.get("modes")).forEach(m -> result.put((TransitMode)((Object)m), slack));
            }
        }
        return result;
    }

    private static String defaultsToString(Map<TransitMode, Integer> byMode) {
        ArrayList groups = new ArrayList();
        byMode.forEach((m, v) -> groups.add(TransportModeSlack.serializeTransportMode(m) + " : " + v));
        Collections.sort(groups);
        return "Defaults: " + groups;
    }

    private static Object serializeTransportMode(TransitMode m) {
        return EnumTypes.TRANSPORT_MODE.serialize((Object)m);
    }

    private static /* synthetic */ void lambda$mapToApiList$0(Multimap modesBySlack, TransitMode k, Integer v) {
        modesBySlack.put((Object)v, (Object)k);
    }
}

