/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import org.opentripplanner.ext.transmodelapi.model.TransportModeSlack;
import org.opentripplanner.routing.api.request.RoutingRequest;

public class DefaultRoutingRequestType {
    public final RoutingRequest request;
    public final GraphQLObjectType graphQLType;

    public DefaultRoutingRequestType(RoutingRequest request) {
        this.request = request;
        this.graphQLType = this.createGraphQLType();
    }

    private GraphQLObjectType createGraphQLType() {
        return GraphQLObjectType.newObject().name("RoutingParameters").description("The default parameters used in travel searches.").field(GraphQLFieldDefinition.newFieldDefinition().name("walkSpeed").description("Max walk speed along streets, in meters per second").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.walkSpeed).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeSpeed").description("Max bike speed along streets, in meters per second").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.bikeSpeed).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("carSpeed").description("Max car speed along streets, in meters per second").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.carSpeed).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("maxDirectStreetDuration").description("This is the maximum duration in seconds for a direct street search. This is a performance limit and should therefore be set high. Use filters to limit what is presented to the client.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.maxDirectStreetDurationSeconds).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("wheelChairAccessible").description("Whether the trip must be wheelchair accessible.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.wheelchairAccessible).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("numItineraries").description("The maximum number of itineraries to return.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.numItineraries).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("maxSlope").description("The maximum slope of streets for wheelchair trips.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.maxWheelchairSlope).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("showIntermediateStops").description("Whether the planner should return intermediate stops lists for transit legs.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.showIntermediateStops).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transferPenalty").description("An extra penalty added on transfers (i.e. all boardings except the first one).").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.transferCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("walkReluctance").description("A multiplier for how bad walking is, compared to being in transit for equal lengths of time.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.walkReluctance).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stairsReluctance").description("Used instead of walkReluctance for stairs.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.stairsReluctance).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("turnReluctance").description("Multiplicative factor on expected turning time.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.turnReluctance).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevatorBoardTime").description("How long does it take to get on an elevator, on average.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.elevatorBoardTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevatorBoardCost").description("What is the cost of boarding a elevator?").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.elevatorBoardCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevatorHopTime").description("How long does it take to advance one floor on an elevator?").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.elevatorHopTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevatorHopCost").description("What is the cost of travelling one floor on an elevator?").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.elevatorHopCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalPickupTime").description("Time to rent a bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.vehicleRentalPickupTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalPickupCost").description("Cost to rent a bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.vehicleRentalPickupCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalDropOffTime").description("Time to drop-off a rented bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.vehicleRentalDropoffTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalDropOffCost").description("Cost to drop-off a rented bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.vehicleRentalDropoffCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeParkTime").description("Time to park a bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.bikeParkTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeParkCost").description("Cost to park a bike.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.bikeParkCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("carDropOffTime").description("Time to park a car in a park and ride, w/o taking into account driving and walking cost.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.carDropoffTime).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("waitReluctance").description("How much worse is waiting for a transit vehicle than being on a transit vehicle, as a multiplier.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.waitReluctance).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("waitAtBeginningFactor").description("How much less bad is waiting at the beginning of the trip (replaces waitReluctance on the first boarding).").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.waitAtBeginningFactor).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("walkBoardCost").description("This prevents unnecessary transfers by adding a cost for boarding a vehicle.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.walkBoardCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeBoardCost").description("Separate cost for boarding a vehicle with a bicycle, which is more difficult than on foot.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.bikeBoardCost).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("otherThanPreferredRoutesPenalty").description("Penalty added for using every route that is not preferred if user set any route as preferred. We return number of seconds that we are willing to wait for preferred route.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.otherThanPreferredRoutesPenalty).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transferSlack").description("A global minimum transfer time (in seconds) that specifies the minimum amount of time that must pass between exiting one transit vehicle and boarding another.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.transferSlack).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("boardSlackDefault").description(TransportModeSlack.boardSlackDescription("boardSlackList")).type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(e -> ((RoutingRequest)e.getSource()).boardSlack).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("boardSlackList").description(TransportModeSlack.slackByGroupDescription("boardSlack")).type((GraphQLOutputType)TransportModeSlack.SLACK_LIST_OUTPUT_TYPE).dataFetcher(e -> TransportModeSlack.mapToApiList(((RoutingRequest)e.getSource()).boardSlackForMode)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("alightSlackDefault").description(TransportModeSlack.alightSlackDescription("alightSlackList")).type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(e -> ((RoutingRequest)e.getSource()).alightSlack).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("alightSlackList").description(TransportModeSlack.slackByGroupDescription("alightSlack")).type((GraphQLOutputType)TransportModeSlack.SLACK_LIST_OUTPUT_TYPE).dataFetcher(e -> TransportModeSlack.mapToApiList(((RoutingRequest)e.getSource()).alightSlackForMode)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("maxTransfers").description("Maximum number of transfers returned in a trip plan.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> this.request.maxTransfers).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("reverseOptimizeOnTheFly").deprecate("NOT IN USE IN OTP2.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(e -> false).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("compactLegsByReversedSearch").deprecate("NOT IN USE IN OTP2.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(e -> false).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("carDecelerationSpeed").description("The deceleration speed of an automobile, in meters per second per second.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.carDecelerationSpeed).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("carAccelerationSpeed").description("The acceleration speed of an automobile, in meters per second per second.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> this.request.carAccelerationSpeed).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ignoreRealTimeUpdates").description("When true, realtime updates are ignored during this search.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.ignoreRealtimeUpdates).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("includedPlannedCancellations").description("When true, service journeys cancelled in scheduled route data will be included during this search.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.includePlannedCancellations).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("disableRemainingWeightHeuristic").description("If true, the remaining weight heuristic is disabled.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.disableRemainingWeightHeuristic).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("allowBikeRental").description("").type((GraphQLOutputType)Scalars.GraphQLBoolean).deprecate("Rental is specified by modes").dataFetcher(env -> this.request.vehicleRental).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("parkAndRide").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.parkAndRide).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("kissAndRide").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.carPickup).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("debugItineraryFilter").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.itineraryFilters.debug).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("onlyTransitTrips").description("Accept only paths that use transit (no street-only paths).").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.onlyTransitTrips).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("disableAlertFiltering").description("Option to disable the default filtering of GTFS-RT alerts by time.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.disableAlertFiltering).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("geoIdElevation").description("Whether to apply the ellipsoid->geoid offset to all elevations in the response.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> this.request.geoidElevation).build()).build();
    }
}

