/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi;

import graphql.Scalars;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultPageInfo;
import graphql.relay.PageInfo;
import graphql.relay.Relay;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.opentripplanner.ext.transmodelapi.mapping.PlaceMapper;
import org.opentripplanner.ext.transmodelapi.mapping.SeverityMapper;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.DefaultRoutingRequestType;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.TransmodelPlaceType;
import org.opentripplanner.ext.transmodelapi.model.framework.AuthorityType;
import org.opentripplanner.ext.transmodelapi.model.framework.BrandingType;
import org.opentripplanner.ext.transmodelapi.model.framework.InfoLinkType;
import org.opentripplanner.ext.transmodelapi.model.framework.MultilingualStringType;
import org.opentripplanner.ext.transmodelapi.model.framework.NoticeType;
import org.opentripplanner.ext.transmodelapi.model.framework.OperatorType;
import org.opentripplanner.ext.transmodelapi.model.framework.PointsOnLinkType;
import org.opentripplanner.ext.transmodelapi.model.framework.RentalVehicleTypeType;
import org.opentripplanner.ext.transmodelapi.model.framework.ServerInfoType;
import org.opentripplanner.ext.transmodelapi.model.framework.SystemNoticeType;
import org.opentripplanner.ext.transmodelapi.model.framework.ValidityPeriodType;
import org.opentripplanner.ext.transmodelapi.model.network.DestinationDisplayType;
import org.opentripplanner.ext.transmodelapi.model.network.JourneyPatternType;
import org.opentripplanner.ext.transmodelapi.model.network.LineType;
import org.opentripplanner.ext.transmodelapi.model.network.PresentationType;
import org.opentripplanner.ext.transmodelapi.model.plan.LegType;
import org.opentripplanner.ext.transmodelapi.model.plan.PathGuidanceType;
import org.opentripplanner.ext.transmodelapi.model.plan.PlanPlaceType;
import org.opentripplanner.ext.transmodelapi.model.plan.RoutingErrorType;
import org.opentripplanner.ext.transmodelapi.model.plan.TripPatternType;
import org.opentripplanner.ext.transmodelapi.model.plan.TripQuery;
import org.opentripplanner.ext.transmodelapi.model.plan.TripType;
import org.opentripplanner.ext.transmodelapi.model.siri.et.EstimatedCallType;
import org.opentripplanner.ext.transmodelapi.model.siri.sx.PtSituationElementType;
import org.opentripplanner.ext.transmodelapi.model.stop.BikeParkType;
import org.opentripplanner.ext.transmodelapi.model.stop.BikeRentalStationType;
import org.opentripplanner.ext.transmodelapi.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.ext.transmodelapi.model.stop.PlaceAtDistanceType;
import org.opentripplanner.ext.transmodelapi.model.stop.PlaceInterfaceType;
import org.opentripplanner.ext.transmodelapi.model.stop.QuayAtDistanceType;
import org.opentripplanner.ext.transmodelapi.model.stop.QuayType;
import org.opentripplanner.ext.transmodelapi.model.stop.RentalVehicleType;
import org.opentripplanner.ext.transmodelapi.model.stop.StopPlaceType;
import org.opentripplanner.ext.transmodelapi.model.stop.TariffZoneType;
import org.opentripplanner.ext.transmodelapi.model.timetable.BookingArrangementType;
import org.opentripplanner.ext.transmodelapi.model.timetable.InterchangeType;
import org.opentripplanner.ext.transmodelapi.model.timetable.ServiceJourneyType;
import org.opentripplanner.ext.transmodelapi.model.timetable.TimetabledPassingTimeType;
import org.opentripplanner.ext.transmodelapi.model.timetable.TripMetadataType;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmodelGraphQLSchema {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelGraphQLSchema.class);
    private final DefaultRoutingRequestType routing;
    private final GqlUtil gqlUtil;
    private final Relay relay = new Relay();

    private TransmodelGraphQLSchema(RoutingRequest defaultRequest, GqlUtil gqlUtil) {
        this.gqlUtil = gqlUtil;
        this.routing = new DefaultRoutingRequestType(defaultRequest);
    }

    public static GraphQLSchema create(RoutingRequest defaultRequest, GqlUtil qglUtil) {
        return new TransmodelGraphQLSchema(defaultRequest, qglUtil).create();
    }

    private GraphQLSchema create() {
        GraphQLObjectType multilingualStringType = MultilingualStringType.create();
        GraphQLObjectType validityPeriodType = ValidityPeriodType.create(this.gqlUtil);
        GraphQLObjectType infoLinkType = InfoLinkType.create();
        GraphQLObjectType bookingArrangementType = BookingArrangementType.create(this.gqlUtil);
        GraphQLObjectType systemNoticeType = SystemNoticeType.create();
        GraphQLObjectType linkGeometryType = PointsOnLinkType.create();
        GraphQLOutputType serverInfoType = ServerInfoType.create();
        GraphQLObjectType authorityType = AuthorityType.create((GraphQLOutputType)LineType.REF, (GraphQLOutputType)PtSituationElementType.REF, this.gqlUtil);
        GraphQLObjectType operatorType = OperatorType.create((GraphQLOutputType)LineType.REF, (GraphQLOutputType)ServiceJourneyType.REF, this.gqlUtil);
        GraphQLObjectType brandingType = BrandingType.create();
        GraphQLObjectType noticeType = NoticeType.create();
        GraphQLObjectType rentalVehicleTypeType = RentalVehicleTypeType.create();
        GraphQLObjectType tariffZoneType = TariffZoneType.createTZ();
        GraphQLInterfaceType placeInterface = PlaceInterfaceType.create();
        GraphQLObjectType bikeRentalStationType = BikeRentalStationType.create(placeInterface);
        GraphQLObjectType rentalVehicleType = RentalVehicleType.create((GraphQLOutputType)rentalVehicleTypeType, placeInterface);
        GraphQLObjectType bikeParkType = BikeParkType.createB(placeInterface);
        GraphQLObjectType stopPlaceType = StopPlaceType.create(placeInterface, QuayType.REF, (GraphQLOutputType)tariffZoneType, (GraphQLOutputType)EstimatedCallType.REF, this.gqlUtil);
        GraphQLObjectType quayType = QuayType.create(placeInterface, (GraphQLOutputType)stopPlaceType, (GraphQLOutputType)LineType.REF, (GraphQLOutputType)JourneyPatternType.REF, (GraphQLOutputType)EstimatedCallType.REF, (GraphQLOutputType)PtSituationElementType.REF, (GraphQLOutputType)tariffZoneType, this.gqlUtil);
        GraphQLObjectType quayAtDistance = QuayAtDistanceType.createQD((GraphQLOutputType)quayType, this.relay);
        GraphQLObjectType placeAtDistanceType = PlaceAtDistanceType.create(this.relay, placeInterface);
        GraphQLObjectType presentationType = PresentationType.create();
        GraphQLObjectType destinationDisplayType = DestinationDisplayType.create();
        GraphQLObjectType lineType = LineType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)authorityType, (GraphQLOutputType)operatorType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, presentationType, (GraphQLOutputType)JourneyPatternType.REF, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)PtSituationElementType.REF, (GraphQLOutputType)brandingType);
        GraphQLObjectType interchangeType = InterchangeType.create((GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF);
        GraphQLObjectType ptSituationElementType = PtSituationElementType.create((GraphQLOutputType)authorityType, (GraphQLOutputType)quayType, (GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)multilingualStringType, validityPeriodType, infoLinkType, this.relay);
        GraphQLObjectType journeyPatternType = JourneyPatternType.create((GraphQLOutputType)linkGeometryType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLNamedOutputType)ptSituationElementType, this.gqlUtil);
        GraphQLObjectType estimatedCallType = EstimatedCallType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)destinationDisplayType, (GraphQLOutputType)ptSituationElementType, (GraphQLOutputType)ServiceJourneyType.REF, this.gqlUtil);
        GraphQLObjectType serviceJourneyType = ServiceJourneyType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)linkGeometryType, (GraphQLOutputType)operatorType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)lineType, (GraphQLOutputType)ptSituationElementType, (GraphQLOutputType)journeyPatternType, (GraphQLOutputType)estimatedCallType, (GraphQLOutputType)TimetabledPassingTimeType.REF, this.gqlUtil);
        GraphQLObjectType timetabledPassingTime = TimetabledPassingTimeType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)destinationDisplayType, (GraphQLOutputType)serviceJourneyType, this.gqlUtil);
        GraphQLObjectType tripType = this.createPlanType((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)interchangeType, (GraphQLOutputType)linkGeometryType, (GraphQLOutputType)systemNoticeType, (GraphQLOutputType)authorityType, (GraphQLOutputType)operatorType, (GraphQLOutputType)bikeRentalStationType, (GraphQLOutputType)rentalVehicleType, (GraphQLOutputType)quayType, (GraphQLOutputType)estimatedCallType, (GraphQLOutputType)lineType, (GraphQLOutputType)serviceJourneyType, (GraphQLOutputType)ptSituationElementType);
        GraphQLFieldDefinition tripQuery = TripQuery.create(this.routing, (GraphQLOutputType)tripType, this.gqlUtil);
        GraphQLInputObjectType inputPlaceIds = GraphQLInputObjectType.newInputObject().name("InputPlaceIds").field(GraphQLInputObjectField.newInputObjectField().name("quays").description("Quays to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("lines").description("Lines to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("bikeRentalStations").description("Bike rentals to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("bikeParks").description("Bike parks to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("carParks").description("Car parks to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).build();
        GraphQLObjectType queryType = GraphQLObjectType.newObject().name("QueryType").field(tripQuery).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").description("Get a single stopPlace based on its id)").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)stopPlaceType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(env -> StopPlaceType.fetchStopPlaceById(TransitIdMapper.mapIDToDomain((String)env.getArgument("id")), env)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlaces").description("Get all stopPlaces").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)stopPlaceType))).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(env -> {
            if (env.getArgument("ids") instanceof List) {
                return ((List)env.getArgument("ids")).stream().map(TransitIdMapper::mapIDToDomain).map(id -> StopPlaceType.fetchStopPlaceById(id, env)).collect(Collectors.toList());
            }
            RoutingService routingService = GqlUtil.getRoutingService(env);
            return routingService.getStations().stream().map(station -> new MonoOrMultiModalStation((Station)station, routingService.getMultiModalStationForStations().get(station))).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlacesByBbox").description("Get all stop places within the specified bounding box").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)stopPlaceType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("multiModalMode").type((GraphQLInputType)EnumTypes.MULTI_MODAL_MODE).description("MultiModalMode for query. To control whether multi modal parent stop places, their mono modal children or both are included in the response. Does not affect mono modal stop places that do not belong to a multi modal stop place.").defaultValue((Object)"parent").build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("If true only stop places with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).dataFetcher(env -> {
            double minLat = (Double)env.getArgument("minimumLatitude");
            double minLon = (Double)env.getArgument("minimumLongitude");
            double maxLat = (Double)env.getArgument("maximumLatitude");
            double maxLon = (Double)env.getArgument("maximumLongitude");
            String authority = (String)env.getArgument("authority");
            boolean filterByInUse = Boolean.TRUE.equals(env.getArgument("filterByInUse"));
            String multiModalMode = (String)env.getArgument("multiModalMode");
            return StopPlaceType.fetchStopPlaces(minLat, minLon, maxLat, maxLon, authority, filterByInUse, multiModalMode, env);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quay").description("Get a single quay based on its id)").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)quayType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getStopForId(TransitIdMapper.mapIDToDomain((String)environment.getArgument("id")))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Get all quays").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).build()).dataFetcher(environment -> {
            if (environment.getArgument("ids") instanceof List) {
                if (environment.getArguments().entrySet().stream().filter(stringObjectEntry -> stringObjectEntry.getValue() != null).collect(Collectors.toList()).size() != 1) {
                    throw new IllegalArgumentException("Unable to combine other filters with ids");
                }
                RoutingService routingService = GqlUtil.getRoutingService(environment);
                return ((List)environment.getArgument("ids")).stream().map(id -> routingService.getStopForId(TransitIdMapper.mapIDToDomain(id))).collect(Collectors.toList());
            }
            if (environment.getArgument("name") == null) {
                return GqlUtil.getRoutingService(environment).getAllStops();
            }
            return Collections.emptyList();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quaysByBbox").description("Get all quays within the specified bounding box").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("If true only quays with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getStopsByBoundingBox((Double)environment.getArgument("minimumLatitude"), (Double)environment.getArgument("minimumLongitude"), (Double)environment.getArgument("maximumLatitude"), (Double)environment.getArgument("maximumLongitude")).stream().filter(stop -> environment.getArgument("authority") == null || stop.getId().getFeedId().equalsIgnoreCase((String)environment.getArgument("authority"))).filter(stop -> {
            boolean filterByInUse = Boolean.TRUE.equals(environment.getArgument("filterByInUse"));
            boolean inUse = !GqlUtil.getRoutingService(environment).getPatternsForStop((StopLocation)stop, true).isEmpty();
            return !filterByInUse || inUse;
        }).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quaysByRadius").description("Get all quays within the specified walking radius from a location. The returned type has two fields quay and distance").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)this.relay.connectionType("quayAtDistance", this.relay.edgeType("quayAtDistance", (GraphQLOutputType)quayAtDistance, null, new ArrayList()), new ArrayList())).argument(GraphQLArgument.newArgument().name("latitude").description("Latitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("longitude").description("Longitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("radius").description("Radius via streets (in meters) to search for from the specified location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").type((GraphQLInputType)Scalars.GraphQLString).build()).arguments(this.relay.getConnectionFieldArguments()).dataFetcher(environment -> {
            List<Object> stops;
            try {
                stops = GqlUtil.getRoutingService(environment).findClosestStops((Double)environment.getArgument("latitude"), (Double)environment.getArgument("longitude"), (Double)environment.getArgument("radius")).stream().filter(stopAtDistance -> environment.getArgument("authority") == null || stopAtDistance.stop.getId().getFeedId().equalsIgnoreCase((String)environment.getArgument("authority"))).sorted(Comparator.comparing(s -> s.distance)).collect(Collectors.toList());
            }
            catch (RoutingValidationException e) {
                LOG.warn("findClosestPlacesByWalking failed with exception, returning empty list of places. ", (Throwable)e);
                stops = List.of();
            }
            if (stops.isEmpty()) {
                return new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
            }
            return new SimpleListConnection(stops).get(environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("nearest").description("Get all places (quays, stop places, car parks etc. with coordinates) within the specified radius from a location. The returned type has two fields place and distance. The search is done by walking so the distance is according to the network of walkables.").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)this.relay.connectionType("placeAtDistance", this.relay.edgeType("placeAtDistance", (GraphQLOutputType)placeAtDistanceType, null, new ArrayList()), new ArrayList())).argument(GraphQLArgument.newArgument().name("latitude").description("Latitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("longitude").description("Longitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumDistance").description("Maximum distance (in meters) to search for from the specified location. Default is 2000m.").defaultValueProgrammatic((Object)2000).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumResults").description("Maximum number of results. Search is stopped when this limit is reached. Default is 20.").defaultValue((Object)20).type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("filterByPlaceTypes").description("Only include places of given types if set. Default accepts all types").defaultValue(Arrays.asList(TransmodelPlaceType.values())).type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.filterPlaceTypeEnum)).build()).argument(GraphQLArgument.newArgument().name("filterByModes").description("Only include places that include this mode. Only checked for places with mode i.e. quays, departures.").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("Only affects queries for quays and stop places. If true only quays and stop places with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).argument(GraphQLArgument.newArgument().name("filterByIds").description("Only include places that match one of the given ids.").type((GraphQLInputType)inputPlaceIds).build()).argument(GraphQLArgument.newArgument().name("multiModalMode").type((GraphQLInputType)EnumTypes.MULTI_MODAL_MODE).description("MultiModalMode for query. To control whether multi modal parent stop places, their mono modal children or both are included in the response. Does not affect mono modal stop places that do not belong to a multi modal stop place. Only applicable for placeType StopPlace").defaultValue((Object)"parent").build()).argument(this.relay.getConnectionFieldArguments()).dataFetcher(environment -> {
            int orgMaxResults;
            List<FeedScopedId> filterByStops = null;
            List<FeedScopedId> filterByRoutes = null;
            List filterByBikeRentalStations = null;
            List filterByBikeParks = null;
            List filterByCarParks = null;
            Map filterByIds = (Map)environment.getArgument("filterByIds");
            if (filterByIds != null) {
                filterByStops = this.toIdList((List)filterByIds.get("quays"));
                filterByRoutes = this.toIdList((List)filterByIds.get("lines"));
                filterByBikeRentalStations = filterByIds.get("bikeRentalStations") != null ? (List)filterByIds.get("bikeRentalStations") : Collections.emptyList();
                filterByBikeParks = filterByIds.get("bikeParks") != null ? (List)filterByIds.get("bikeParks") : Collections.emptyList();
                filterByCarParks = filterByIds.get("carParks") != null ? (List)filterByIds.get("carParks") : Collections.emptyList();
            }
            List filterByTransportModes = (List)environment.getArgument("filterByModes");
            List<TransmodelPlaceType> placeTypes = (List<TransmodelPlaceType>)environment.getArgument("filterByPlaceTypes");
            if (placeTypes == null || placeTypes.isEmpty()) {
                placeTypes = Arrays.asList(TransmodelPlaceType.values());
            }
            List<PlaceType> filterByPlaceTypes = PlaceMapper.mapToDomain(placeTypes);
            int maxResults = orgMaxResults = ((Integer)environment.getArgument("maximumResults")).intValue();
            if (placeTypes.contains((Object)TransmodelPlaceType.STOP_PLACE)) {
                maxResults *= 5;
            }
            List<PlaceAtDistance> places = GqlUtil.getRoutingService(environment).findClosestPlaces((Double)environment.getArgument("latitude"), (Double)environment.getArgument("longitude"), (Double)environment.getArgument("maximumDistance"), maxResults, filterByTransportModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, filterByBikeParks, filterByCarParks, GqlUtil.getRoutingService(environment));
            if ((places = PlaceAtDistanceType.convertQuaysToStopPlaces(placeTypes, places, (String)environment.getArgument("multiModalMode"), GqlUtil.getRoutingService(environment)).stream().limit(orgMaxResults).collect(Collectors.toList())).isEmpty()) {
                return new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
            }
            return new SimpleListConnection(places).get(environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").description("Get an authority by ID").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)authorityType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getAgencyForId(TransitIdMapper.mapIDToDomain((String)environment.getArgument("id")))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authorities").description("Get all authorities").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)authorityType))).dataFetcher(environment -> new ArrayList<Agency>(GqlUtil.getRoutingService(environment).getAgencies())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").description("Get a operator by ID").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)operatorType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getOperatorForId().get(TransitIdMapper.mapIDToDomain((String)environment.getArgument("id")))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operators").description("Get all operators").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)operatorType))).dataFetcher(environment -> new ArrayList<Operator>(GqlUtil.getRoutingService(environment).getAllOperators())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").description("Get a single line based on its id").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)lineType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).build()).dataFetcher(environment -> {
            String id = (String)environment.getArgument("id");
            if (id.isBlank()) {
                return null;
            }
            return GqlUtil.getRoutingService(environment).getRouteForId(TransitIdMapper.mapIDToDomain(id));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").description("Get all lines").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).build()).argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("publicCode").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("publicCodes").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("transportModes").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("authorities").description("Set of ids of authorities to fetch lines for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("flexibleOnly").description("Filter by lines containing flexible / on demand serviceJourneys only.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).build()).dataFetcher(environment -> {
            if (environment.getArgument("ids") instanceof List) {
                if (environment.getArguments().entrySet().stream().filter(it -> it.getValue() != null && (!((String)it.getKey()).equals("flexibleOnly") || !it.getValue().equals(false))).count() != 1L) {
                    throw new IllegalArgumentException("Unable to combine other filters with ids");
                }
                return ((List)environment.getArgument("ids")).stream().map(id1 -> TransitIdMapper.mapIDToDomain(id1)).map(id -> GqlUtil.getRoutingService(environment).getRouteForId((FeedScopedId)id)).collect(Collectors.toList());
            }
            Stream<Route> stream = GqlUtil.getRoutingService(environment).getAllRoutes().stream();
            if (((Boolean)environment.getArgument("flexibleOnly")).booleanValue()) {
                stream = stream.filter(t -> GqlUtil.getRoutingService((DataFetchingEnvironment)environment).getFlexIndex().routeById.containsKey(t.getId()));
            }
            if (environment.getArgument("name") != null) {
                stream = stream.filter(route -> route.getLongName() != null).filter(route -> route.getLongName().toLowerCase().startsWith(((String)environment.getArgument("name")).toLowerCase()));
            }
            if (environment.getArgument("publicCode") != null) {
                stream = stream.filter(route -> route.getShortName() != null).filter(route -> route.getShortName().equals(environment.getArgument("publicCode")));
            }
            if (environment.getArgument("publicCodes") instanceof List) {
                Set publicCodes = Set.copyOf((Collection)environment.getArgument("publicCodes"));
                stream = stream.filter(route -> route.getShortName() != null).filter(route -> publicCodes.contains(route.getShortName()));
            }
            if (environment.getArgument("transportModes") != null) {
                Set modes = Set.copyOf((Collection)environment.getArgument("transportModes"));
                stream = stream.filter(route -> modes.contains((Object)route.getMode()));
            }
            if (environment.getArgument("authorities") instanceof Collection) {
                Collection authorityIds = (Collection)environment.getArgument("authorities");
                stream = stream.filter(route -> route.getAgency() != null && authorityIds.contains(route.getAgency().getId().getId()));
            }
            return stream.collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").description("Get a single service journey based on its id").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)serviceJourneyType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getTripForId().get(TransitIdMapper.mapIDToDomain((String)environment.getArgument("id")))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").description("Get all service journeys").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)serviceJourneyType))).argument(GraphQLArgument.newArgument().name("lines").description("Set of ids of lines to fetch serviceJourneys for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).build()).argument(GraphQLArgument.newArgument().name("privateCodes").description("Set of ids of private codes to fetch serviceJourneys for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("activeDates").description("Set of ids of active dates to fetch serviceJourneys for.").type((GraphQLInputType)new GraphQLList((GraphQLType)this.gqlUtil.dateScalar)).build()).argument(GraphQLArgument.newArgument().name("authorities").description("Set of ids of authorities to fetch serviceJourneys for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> {
            List<FeedScopedId> lineIds = TransitIdMapper.mapIDsToDomain((Collection)environment.getArgument("lines"));
            List privateCodes = (List)environment.getArgument("privateCodes");
            List activeDates = (List)environment.getArgument("activeDates");
            List authorities = (List)environment.getArgument("authorities");
            return GqlUtil.getRoutingService(environment).getTripForId().values().stream().filter(t -> lineIds == null || lineIds.isEmpty() || lineIds.contains(t.getRoute().getId())).filter(t -> CollectionUtils.isEmpty((Collection)privateCodes) || privateCodes.contains(t.getInternalPlanningCode())).filter(t -> authorities == null || authorities.isEmpty() || authorities.contains(t.getRoute().getAgency().getId().getId())).filter(t -> activeDates == null || activeDates.isEmpty() || GqlUtil.getRoutingService(environment).getCalendarService().getServiceDatesForServiceId(t.getServiceId()).stream().anyMatch(sd -> activeDates.contains(this.gqlUtil.serviceDateMapper.serviceDateToSecondsSinceEpoch((ServiceDate)sd)))).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStations").description("Get all bike rental stations").withDirective(this.gqlUtil.timingData).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeRentalStationType))).dataFetcher(environment -> {
            ArrayList<VehicleRentalStation> all = new ArrayList<VehicleRentalStation>(GqlUtil.getRoutingService(environment).getVehicleRentalStationService().getVehicleRentalStations());
            List filterByIds = (List)environment.getArgument("ids");
            if (filterByIds != null && !filterByIds.isEmpty()) {
                return all.stream().filter(station -> filterByIds.contains(station.getStationId())).collect(Collectors.toList());
            }
            return all;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStation").description("Get all bike rental stations").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)bikeRentalStationType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getVehicleRentalStationService().getVehicleRentalStations().stream().filter(bikeRentalStation -> bikeRentalStation.getStationId().equals(environment.getArgument("id"))).findFirst().orElse(null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStationsByBbox").description("Get all bike rental stations within the specified bounding box.").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeRentalStationType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getVehicleRentalStationService().getVehicleRentalStationForEnvelope((Double)environment.getArgument("minimumLongitude"), (Double)environment.getArgument("minimumLatitude"), (Double)environment.getArgument("maximumLongitude"), (Double)environment.getArgument("maximumLatitude"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikePark").description("Get a single bike park based on its id").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)bikeParkType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> {
            FeedScopedId bikeParkId = TransitIdMapper.mapIDToDomain((String)environment.getArgument("id"));
            return GqlUtil.getRoutingService(environment).getVehicleParkingService().getBikeParks().filter(bikePark -> bikePark.getId().equals(bikeParkId)).findFirst().orElse(null);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeParks").description("Get all bike parks").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeParkType))).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getVehicleParkingService().getBikeParks().collect(Collectors.toCollection(ArrayList::new))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("routingParameters").description("Get default routing parameters.").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)this.routing.graphQLType).dataFetcher(environment -> this.routing.request).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all active situations.").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)ptSituationElementType))).argument(GraphQLArgument.newArgument().name("authorities").description("Filter by reporting authorities.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("severities").description("Filter by severity.").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.SEVERITY)).build()).dataFetcher(environment -> {
            Collection alerts = GqlUtil.getRoutingService(environment).getTransitAlertService().getAllAlerts();
            if (environment.getArgument("authorities") instanceof List) {
                List authorities = (List)environment.getArgument("authorities");
                alerts = alerts.stream().filter(alert -> authorities.contains(alert.getFeedId())).collect(Collectors.toSet());
            }
            if (environment.getArgument("severities") instanceof List) {
                List severities = (List)environment.getArgument("severities");
                alerts = alerts.stream().filter(alert -> severities.contains(SeverityMapper.getTransmodelSeverity(alert.severity))).collect(Collectors.toSet());
            }
            return alerts;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situation").description("Get a single situation based on its situationNumber").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)ptSituationElementType).argument(GraphQLArgument.newArgument().name("situationNumber").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getRoutingService(environment).getTransitAlertService().getAlertById((String)environment.getArgument("situationNumber"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serverInfo").description("Get OTP server information").withDirective(this.gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)serverInfoType)).dataFetcher(e -> OtpProjectInfo.projectInfo()).build()).build();
        HashSet<Object> dictionary = new HashSet<Object>();
        dictionary.add(placeInterface);
        dictionary.add(timetabledPassingTime);
        dictionary.add(Relay.pageInfoType);
        return GraphQLSchema.newSchema().query(queryType).build(dictionary);
    }

    public GraphQLObjectType createPlanType(GraphQLOutputType bookingArrangementType, GraphQLOutputType interchangeType, GraphQLOutputType linkGeometryType, GraphQLOutputType systemNoticeType, GraphQLOutputType authorityType, GraphQLOutputType operatorType, GraphQLOutputType bikeRentalStationType, GraphQLOutputType rentalVehicleType, GraphQLOutputType quayType, GraphQLOutputType estimatedCallType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType ptSituationElementType) {
        GraphQLObjectType tripMetadataType = TripMetadataType.create(this.gqlUtil);
        GraphQLObjectType placeType = PlanPlaceType.create(bikeRentalStationType, rentalVehicleType, quayType);
        GraphQLObjectType pathGuidanceType = PathGuidanceType.create();
        GraphQLObjectType legType = LegType.create(bookingArrangementType, interchangeType, linkGeometryType, authorityType, operatorType, quayType, estimatedCallType, lineType, serviceJourneyType, ptSituationElementType, placeType, pathGuidanceType, this.gqlUtil);
        GraphQLObjectType tripPatternType = TripPatternType.create(systemNoticeType, legType, this.gqlUtil);
        GraphQLObjectType routingErrorType = RoutingErrorType.create();
        return TripType.create(placeType, tripPatternType, tripMetadataType, routingErrorType, this.gqlUtil);
    }

    private List<FeedScopedId> toIdList(List<String> ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(TransitIdMapper::mapIDToDomain).collect(Collectors.toList());
    }
}

