/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi;

import graphql.GraphQLException;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opentripplanner.api.common.ParameterException;
import org.opentripplanner.ext.transmodelapi.TransmodelRequestContext;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.PlanResponse;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.ext.transmodelapi.model.TransportModeSlack;
import org.opentripplanner.ext.transmodelapi.model.plan.ItineraryFiltersInputType;
import org.opentripplanner.ext.transmodelapi.support.DataFetcherDecorator;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.modes.AllowedTransitMode;
import org.opentripplanner.routing.algorithm.mapping.TripPlanMapper;
import org.opentripplanner.routing.api.request.BannedStopSet;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.standalone.server.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmodelGraphQLPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelGraphQLPlanner.class);

    public DataFetcherResult<PlanResponse> plan(DataFetchingEnvironment environment) {
        PlanResponse response = new PlanResponse();
        TransmodelRequestContext ctx = (TransmodelRequestContext)environment.getContext();
        Router router = ctx.getRouter();
        Locale locale = router.defaultRoutingRequest.locale;
        RoutingRequest request = null;
        try {
            request = this.createRequest(environment);
            locale = request.locale;
            RoutingResponse res = ctx.getRoutingService().route(request, router);
            response.plan = res.getTripPlan();
            response.metadata = res.getMetadata();
            response.messages = res.getRoutingErrors();
            response.debugOutput = res.getDebugTimingAggregator().finishedRendering();
            response.previousPageCursor = res.getPreviousPageCursor();
            response.nextPageCursor = res.getNextPageCursor();
        }
        catch (ParameterException e) {
            String msg = e.message.get();
            throw new GraphQLException(msg, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("System error: " + e.getMessage(), (Throwable)e);
            response.plan = TripPlanMapper.mapTripPlan(request, List.of());
            response.messages.add(new RoutingError(RoutingErrorCode.SYSTEM_ERROR, null));
        }
        return DataFetcherResult.newResult().data((Object)response).localContext(Map.of("locale", locale)).build();
    }

    private GenericLocation toGenericLocation(Map<String, Object> m) {
        String placeRef;
        Map coordinates = (Map)m.get("coordinates");
        Double lat = null;
        Double lon = null;
        if (coordinates != null) {
            lat = (Double)coordinates.get("latitude");
            lon = (Double)coordinates.get("longitude");
        }
        FeedScopedId stopId = (placeRef = (String)m.get("place")) == null ? null : TransitIdMapper.mapIDToDomain(placeRef);
        String name = (String)m.get("name");
        name = name == null ? "" : name;
        return new GenericLocation(name, stopId, lat, lon);
    }

    private RoutingRequest createRequest(DataFetchingEnvironment environment) throws ParameterException {
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        Router router = context.getRouter();
        RoutingRequest request = router.defaultRoutingRequest.clone();
        DataFetcherDecorator callWith = new DataFetcherDecorator(environment);
        callWith.argument("locale", v -> {
            request.locale = Locale.forLanguageTag(v);
        });
        callWith.argument("from", v -> {
            request.from = this.toGenericLocation((Map<String, Object>)v);
        });
        callWith.argument("to", v -> {
            request.to = this.toGenericLocation((Map<String, Object>)v);
        });
        callWith.argument("dateTime", millisSinceEpoch -> request.setDateTime(Instant.ofEpochMilli((Long)millisSinceEpoch)), Date::new);
        callWith.argument("searchWindow", m -> {
            request.searchWindow = Duration.ofMinutes(m.intValue());
        });
        callWith.argument("pageCursor", request::setPageCursor);
        callWith.argument("timetableView", v -> {
            request.timetableView = v;
        });
        callWith.argument("wheelchair", request::setWheelchairAccessible);
        callWith.argument("numTripPatterns", request::setNumItineraries);
        callWith.argument("transitGeneralizedCostLimit", it -> {
            request.itineraryFilters.transitGeneralizedCostLimit = it;
        });
        callWith.argument("walkBoardCost", request::setWalkBoardCost);
        callWith.argument("walkReluctance", request::setNonTransitReluctance);
        callWith.argument("waitReluctance", request::setWaitReluctance);
        callWith.argument("walkBoardCost", request::setWalkBoardCost);
        callWith.argument("waitReluctance", request::setWaitReluctance);
        callWith.argument("waitAtBeginningFactor", request::setWaitAtBeginningFactor);
        callWith.argument("walkSpeed", v -> {
            request.walkSpeed = v;
        });
        callWith.argument("bikeSpeed", v -> {
            request.bikeSpeed = v;
        });
        callWith.argument("bikeSwitchTime", v -> {
            request.bikeSwitchTime = v;
        });
        callWith.argument("bikeSwitchCost", v -> {
            request.bikeSwitchCost = v;
        });
        BicycleOptimizeType bicycleOptimizeType = (BicycleOptimizeType)((Object)environment.getArgument("bicycleOptimisationMethod"));
        if (bicycleOptimizeType == BicycleOptimizeType.TRIANGLE) {
            double[] args = new double[3];
            callWith.argument("triangleFactors.safety", v -> {
                args[0] = v;
            });
            callWith.argument("triangleFactors.slope", v -> {
                args[1] = v;
            });
            callWith.argument("triangleFactors.time", v -> {
                args[2] = v;
            });
            request.setTriangleNormalized(args[0], args[1], args[2]);
        }
        if (bicycleOptimizeType == BicycleOptimizeType.TRANSFERS) {
            bicycleOptimizeType = BicycleOptimizeType.QUICK;
            request.transferCost += 1800;
        }
        if (bicycleOptimizeType != null) {
            request.bicycleOptimizeType = bicycleOptimizeType;
        }
        callWith.argument("arriveBy", request::setArriveBy);
        request.showIntermediateStops = true;
        callWith.argument("vias", v -> {
            request.intermediatePlaces = v.stream().map(this::toGenericLocation).collect(Collectors.toList());
        });
        callWith.argument("preferred.authorities", authorities -> request.setPreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("unpreferred.authorities", authorities -> request.setUnpreferredAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("whiteListed.authorities", authorities -> request.setWhiteListedAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("banned.authorities", authorities -> request.setBannedAgencies(TransitIdMapper.mapIDsToDomain(authorities)));
        callWith.argument("preferred.otherThanPreferredLinesPenalty", request::setOtherThanPreferredRoutesPenalty);
        callWith.argument("preferred.lines", lines -> request.setPreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("unpreferred.lines", lines -> request.setUnpreferredRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("whiteListed.lines", lines -> request.setWhiteListedRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("banned.lines", lines -> request.setBannedRoutes(TransitIdMapper.mapIDsToDomain(lines)));
        callWith.argument("banned.serviceJourneys", serviceJourneys -> {
            request.bannedTrips = this.toBannedTrips((Collection<String>)serviceJourneys);
        });
        callWith.argument("debugItineraryFilter", v -> {
            request.itineraryFilters.debug = v;
        });
        callWith.argument("transferPenalty", v -> {
            request.transferCost = v;
        });
        RequestModes modes = this.getModes(environment, callWith);
        if (modes != null) {
            request.modes = modes;
        }
        ItineraryFiltersInputType.mapToRequest(environment, callWith, request.itineraryFilters);
        if (request.vehicleRental && !GqlUtil.hasArgument(environment, "bikeSpeed")) {
            request.bikeSpeed = 4.3;
        }
        callWith.argument("minimumTransferTime", v -> {
            request.transferSlack = v;
        });
        callWith.argument("transferSlack", v -> {
            request.transferSlack = v;
        });
        callWith.argument("boardSlackDefault", v -> {
            request.boardSlack = v;
        });
        callWith.argument("boardSlackList", v -> {
            request.boardSlackForMode = TransportModeSlack.mapToDomain(v);
        });
        callWith.argument("alightSlackDefault", v -> {
            request.alightSlack = v;
        });
        callWith.argument("alightSlackList", v -> {
            request.alightSlackForMode = TransportModeSlack.mapToDomain(v);
        });
        callWith.argument("maximumTransfers", v -> {
            request.maxTransfers = v;
        });
        callWith.argument("useBikeRentalAvailabilityInformation", v -> {
            request.useVehicleRentalAvailabilityInformation = v;
        });
        callWith.argument("ignoreRealtimeUpdates", v -> {
            request.ignoreRealtimeUpdates = v;
        });
        callWith.argument("includePlannedCancellations", v -> {
            request.includePlannedCancellations = v;
        });
        return request;
    }

    private RequestModes getModes(DataFetchingEnvironment environment, DataFetcherDecorator callWith) {
        if (GqlUtil.hasArgument(environment, "modes")) {
            ElementWrapper accessMode = new ElementWrapper();
            ElementWrapper egressMode = new ElementWrapper();
            ElementWrapper directMode = new ElementWrapper();
            ElementWrapper transportModes = new ElementWrapper();
            callWith.argument("modes.accessMode", accessMode::set);
            callWith.argument("modes.egressMode", egressMode::set);
            callWith.argument("modes.directMode", directMode::set);
            callWith.argument("modes.transportModes", transportModes::set);
            ArrayList<AllowedTransitMode> transitModes = new ArrayList<AllowedTransitMode>();
            if (transportModes.get() == null) {
                transitModes.addAll(Collections.emptyList());
            } else {
                for (LinkedHashMap modeWithSubmodes : (List)transportModes.get()) {
                    if (!modeWithSubmodes.containsKey("transportMode")) continue;
                    TransitMode mainMode = (TransitMode)((Object)modeWithSubmodes.get("transportMode"));
                    if (modeWithSubmodes.containsKey("transportSubModes")) {
                        List transportSubModes = (List)modeWithSubmodes.get("transportSubModes");
                        for (TransmodelTransportSubmode transitMode : transportSubModes) {
                            transitModes.add(new AllowedTransitMode(mainMode, transitMode.getValue()));
                        }
                        continue;
                    }
                    transitModes.add(AllowedTransitMode.fromMainModeEnum(mainMode));
                }
            }
            return new RequestModes((StreetMode)((Object)accessMode.get()), accessMode.get() == StreetMode.BIKE ? StreetMode.BIKE : StreetMode.WALK, (StreetMode)((Object)egressMode.get()), (StreetMode)((Object)directMode.get()), transitModes);
        }
        return null;
    }

    private HashMap<FeedScopedId, BannedStopSet> toBannedTrips(Collection<String> serviceJourneyIds) {
        Map bannedTrips = serviceJourneyIds.stream().map(TransitIdMapper::mapIDToDomain).collect(Collectors.toMap(Function.identity(), id -> BannedStopSet.ALL));
        return new HashMap<FeedScopedId, BannedStopSet>(bannedTrips);
    }

    private static class ElementWrapper<T> {
        private T element;

        private ElementWrapper() {
        }

        void set(T element) {
            this.element = element;
        }

        T get() {
            return this.element;
        }
    }
}

