/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transferanalyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.transferanalyzer.annotations.TransferCouldNotBeRouted;
import org.opentripplanner.ext.transferanalyzer.annotations.TransferRoutingDistanceTooLong;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.model.Stop;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.StreetGraphFinder;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTransferAnalyzer
implements GraphBuilderModule {
    private static final int RADIUS_MULTIPLIER = 5;
    private static final int MIN_RATIO_TO_LOG = 2;
    private static final int MIN_STREET_DISTANCE_TO_LOG = 100;
    private static final Logger LOG = LoggerFactory.getLogger(DirectTransferAnalyzer.class);
    private final double radiusMeters;

    public DirectTransferAnalyzer(double radiusMeters) {
        this.radiusMeters = radiusMeters;
    }

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        graph.index = new GraphIndex(graph);
        LOG.info("Analyzing transfers (this can be time consuming)...");
        ArrayList<TransferInfo> directTransfersTooLong = new ArrayList<TransferInfo>();
        ArrayList<TransferInfo> directTransfersNotFound = new ArrayList<TransferInfo>();
        DirectGraphFinder nearbyStopFinderEuclidian = new DirectGraphFinder(graph);
        StreetGraphFinder nearbyStopFinderStreets = new StreetGraphFinder(graph);
        int stopsAnalyzed = 0;
        for (TransitStopVertex originStopVertex : graph.getVerticesOfType(TransitStopVertex.class)) {
            NearbyStop euclideanStop;
            if (++stopsAnalyzed % 1000 == 0) {
                LOG.info("{} stops analyzed", (Object)stopsAnalyzed);
            }
            Coordinate c0 = originStopVertex.getCoordinate();
            Map<Stop, NearbyStop> stopsEuclidean = nearbyStopFinderEuclidian.findClosestStops(c0.y, c0.x, this.radiusMeters).stream().filter(t -> t.stop instanceof Stop).collect(Collectors.toMap(t -> (Stop)t.stop, t -> t));
            Map<Stop, NearbyStop> stopsStreets = nearbyStopFinderStreets.findClosestStops(c0.y, c0.x, this.radiusMeters * 5.0).stream().filter(t -> t.stop instanceof Stop).collect(Collectors.toMap(t -> (Stop)t.stop, t -> t));
            Stop originStop = originStopVertex.getStop();
            List stopsConnected = stopsEuclidean.keySet().stream().filter(t -> stopsStreets.keySet().contains(t) && t != originStop).collect(Collectors.toList());
            List stopsUnconnected = stopsEuclidean.keySet().stream().filter(t -> !stopsStreets.keySet().contains(t) && t != originStop).collect(Collectors.toList());
            for (Stop destStop : stopsConnected) {
                euclideanStop = stopsEuclidean.get(destStop);
                NearbyStop streetStop = stopsStreets.get(destStop);
                TransferInfo transferInfo = new TransferInfo(originStop, destStop, euclideanStop.distance, streetStop.distance);
                if (!(transferInfo.ratio > 2.0) || !(transferInfo.streetDistance > 100.0)) continue;
                directTransfersTooLong.add(transferInfo);
            }
            for (Stop destStop : stopsUnconnected) {
                euclideanStop = stopsEuclidean.get(destStop);
                directTransfersNotFound.add(new TransferInfo(originStop, destStop, euclideanStop.distance, -1.0));
            }
        }
        directTransfersTooLong.sort(Comparator.comparingDouble(t -> t.ratio));
        Collections.reverse(directTransfersTooLong);
        for (TransferInfo transferInfo : directTransfersTooLong) {
            issueStore.add(new TransferRoutingDistanceTooLong(transferInfo.origin, transferInfo.destination, transferInfo.directDistance, transferInfo.streetDistance, transferInfo.ratio));
        }
        directTransfersNotFound.sort(Comparator.comparingDouble(t -> t.directDistance));
        for (TransferInfo transferInfo : directTransfersNotFound) {
            issueStore.add(new TransferCouldNotBeRouted(transferInfo.origin, transferInfo.destination, transferInfo.directDistance));
        }
        LOG.info("Done analyzing transfers. {} transfers could not be routed and {} transfers had a too long routing distance.", (Object)directTransfersNotFound.size(), (Object)directTransfersTooLong.size());
    }

    @Override
    public void checkInputs() {
    }

    private static class TransferInfo {
        final Stop origin;
        final Stop destination;
        final double directDistance;
        final double streetDistance;
        final double ratio;

        TransferInfo(Stop origin, Stop destination, double directDistance, double streetDistance) {
            this.origin = origin;
            this.destination = destination;
            this.directDistance = directDistance;
            this.streetDistance = streetDistance;
            this.ratio = directDistance != 0.0 ? streetDistance / directDistance : 0.0;
        }
    }
}

