/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.smoovebikerental;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.updater.GenericJsonDataSource;
import org.opentripplanner.util.NonLocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmooveBikeRentalDataSource
extends GenericJsonDataSource<VehicleRentalPlace> {
    private static final Logger log = LoggerFactory.getLogger(SmooveBikeRentalDataSource.class);
    public static final String DEFAULT_NETWORK_NAME = "smoove";
    private final boolean allowOverloading;
    private final String networkName;
    private final RentalVehicleType vehicleType;

    public SmooveBikeRentalDataSource(SmooveBikeRentalDataSourceParameters config) {
        super(config.getUrl(), "result", config.getHttpHeaders());
        this.networkName = config.getNetwork(DEFAULT_NETWORK_NAME);
        this.vehicleType = RentalVehicleType.getDefaultType(this.networkName);
        this.allowOverloading = config.isAllowOverloading();
    }

    @Override
    protected VehicleRentalStation parseElement(JsonNode node) {
        VehicleRentalStation station = new VehicleRentalStation();
        String[] nameParts = node.path("name").asText().split("\\s", 2);
        station.id = new FeedScopedId(this.networkName, nameParts[0]);
        station.name = new NonLocalizedString(nameParts[1]);
        String[] coordinates = node.path("coordinates").asText().split(",");
        try {
            station.latitude = Double.parseDouble(coordinates[0].trim());
            station.longitude = Double.parseDouble(coordinates[1].trim());
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing bike rental station " + station.id, (Throwable)e);
            return null;
        }
        if (!node.path("operative").asText().equals("true")) {
            station.isRenting = false;
            station.isReturning = false;
            station.vehiclesAvailable = 0;
            station.spacesAvailable = 0;
            station.capacity = node.path("total_slots").asInt();
        } else {
            station.vehiclesAvailable = node.path("avl_bikes").asInt();
            station.spacesAvailable = node.path("free_slots").asInt();
            station.capacity = node.path("total_slots").asInt();
        }
        station.vehicleTypesAvailable = Map.of(this.vehicleType, station.vehiclesAvailable);
        station.vehicleSpacesAvailable = Map.of(this.vehicleType, station.spacesAvailable);
        station.allowOverloading = this.allowOverloading;
        return station;
    }
}

